/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachListener;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\"\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/impl/VcsModuleAttachListener;", "Lcom/intellij/platform/ModuleAttachListener;", "()V", "addVcsMapping", "", "primaryModule", "Lcom/intellij/openapi/module/Module;", "addedModuleContentRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "afterAttach", "module", "imlFile", "Ljava/nio/file/Path;", "beforeDetach", "removeVcsMapping", "intellij.platform.vcs.impl"})
public final class VcsModuleAttachListener
implements ModuleAttachListener {
    public void afterAttach(@NotNull Module module, @Nullable Module primaryModule, @NotNull Path imlFile) {
        VirtualFile dotIdeaDirParent;
        VirtualFile virtualFile;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)imlFile, (String)"imlFile");
        if (primaryModule == null) {
            return;
        }
        Path path2 = imlFile.getParent();
        if (path2 != null && (path2 = path2.getParent()) != null) {
            Path path3 = path2;
            boolean bl = false;
            boolean bl2 = false;
            Path it = path3;
            boolean bl3 = false;
            virtualFile = LocalFileSystem.getInstance().findFileByPath(((Object)it).toString());
        } else {
            virtualFile = dotIdeaDirParent = null;
        }
        if (dotIdeaDirParent != null) {
            this.addVcsMapping(primaryModule, dotIdeaDirParent);
        }
    }

    public void beforeDetach(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        this.removeVcsMapping(module);
    }

    private final void addVcsMapping(Module primaryModule, VirtualFile addedModuleContentRoot) {
        AbstractVcs vcs;
        ProjectLevelVcsManager vcsManager2;
        Project project = primaryModule.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"primaryModule.project");
        Project project2 = project;
        ProjectLevelVcsManager projectLevelVcsManager = vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectLevelVcsManager, (String)"vcsManager");
        List mappings = projectLevelVcsManager.getDirectoryMappings();
        if (mappings.size() == 1) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)primaryModule);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(primaryModule)");
            VirtualFile[] contentRoots = moduleRootManager.getContentRoots();
            if (contentRoots.length == 1) {
                AbstractVcs vcs2;
                VirtualFile virtualFile = contentRoots[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"contentRoots[0]");
                File file = new File(virtualFile.getPath());
                Object e = mappings.get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"mappings[0]");
                if (FileUtil.filesEqual((File)file, (File)new File(((VcsDirectoryMapping)e).getDirectory())) && (vcs2 = vcsManager2.findVersioningVcs(addedModuleContentRoot)) != null) {
                    String string = vcs2.getName();
                    Object e2 = mappings.get(0);
                    Intrinsics.checkExpressionValueIsNotNull(e2, (String)"mappings[0]");
                    if (Intrinsics.areEqual((Object)string, (Object)((VcsDirectoryMapping)e2).getVcs())) {
                        vcsManager2.setDirectoryMappings(CollectionsKt.listOf((Object)VcsDirectoryMapping.createDefault((String)vcs2.getName())));
                        return;
                    }
                }
            }
        }
        if ((vcs = vcsManager2.findVersioningVcs(addedModuleContentRoot)) != null) {
            ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(mappings);
            newMappings.add(new VcsDirectoryMapping(addedModuleContentRoot.getPath(), vcs.getName()));
            vcsManager2.setDirectoryMappings((List)newMappings);
        }
    }

    private final void removeVcsMapping(Module module) {
        ProjectLevelVcsManager vcsManager2;
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        Project project2 = project;
        ProjectLevelVcsManager projectLevelVcsManager = vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectLevelVcsManager, (String)"vcsManager");
        List mappings = projectLevelVcsManager.getDirectoryMappings();
        ArrayList newMappings = new ArrayList(mappings);
        for (VcsDirectoryMapping mapping : mappings) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            VirtualFile[] virtualFileArray = moduleRootManager.getContentRoots();
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile root;
                VirtualFile virtualFile = root = virtualFileArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root");
                File file = new File(virtualFile.getPath());
                VcsDirectoryMapping vcsDirectoryMapping = mapping;
                Intrinsics.checkExpressionValueIsNotNull((Object)vcsDirectoryMapping, (String)"mapping");
                if (!FileUtil.filesEqual((File)file, (File)new File(vcsDirectoryMapping.getDirectory()))) continue;
                newMappings.remove(mapping);
            }
        }
        vcsManager2.setDirectoryMappings((List)newMappings);
    }
}

