/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.AbstractDataGetter;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsCommitCache;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.util.TroveUtil;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniDetailsGetter
extends AbstractDataGetter<VcsCommitMetadata> {
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final VcsLogObjectsFactory myFactory;

    MiniDetailsGetter(@NotNull Project project, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull VcsLogIndex index, @NotNull Disposable parentDisposable) {
        if (project == null) {
            MiniDetailsGetter.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            MiniDetailsGetter.$$$reportNull$$$0(1);
        }
        if (logProviders == null) {
            MiniDetailsGetter.$$$reportNull$$$0(2);
        }
        if (topCommitsDetailsCache == null) {
            MiniDetailsGetter.$$$reportNull$$$0(3);
        }
        if (index == null) {
            MiniDetailsGetter.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            MiniDetailsGetter.$$$reportNull$$$0(5);
        }
        super(storage, logProviders, new VcsCommitCache(), index, parentDisposable);
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myFactory = (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
    }

    @Override
    @Nullable
    protected VcsCommitMetadata getFromAdditionalCache(int commitId) {
        return this.myTopCommitsDetailsCache.get(commitId);
    }

    @Override
    @NotNull
    protected List<? extends VcsCommitMetadata> readDetails(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (logProvider == null) {
            MiniDetailsGetter.$$$reportNull$$$0(6);
        }
        if (root == null) {
            MiniDetailsGetter.$$$reportNull$$$0(7);
        }
        if (hashes == null) {
            MiniDetailsGetter.$$$reportNull$$$0(8);
        }
        List list = logProvider.readMetadata(root, hashes);
        if (list == null) {
            MiniDetailsGetter.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public TIntObjectHashMap<VcsCommitMetadata> preLoadCommitData(@NotNull TIntHashSet commits) throws VcsException {
        IndexDataGetter dataGetter;
        if (commits == null) {
            MiniDetailsGetter.$$$reportNull$$$0(10);
        }
        if ((dataGetter = this.myIndex.getDataGetter()) == null) {
            TIntObjectHashMap tIntObjectHashMap = super.preLoadCommitData(commits);
            if (tIntObjectHashMap == null) {
                MiniDetailsGetter.$$$reportNull$$$0(11);
            }
            return tIntObjectHashMap;
        }
        TIntHashSet notIndexed = new TIntHashSet();
        TIntObjectHashMap<VcsCommitMetadata> result2 = TroveUtil.map2MapNotNull(commits, commit -> {
            VcsCommitMetadata metadata = IndexedDetails.createMetadata(commit, dataGetter, this.myStorage, this.myFactory);
            if (metadata == null) {
                notIndexed.add(commit);
            }
            return metadata;
        });
        this.saveInCache((TIntObjectHashMap)result2);
        if (!notIndexed.isEmpty()) {
            TroveUtil.putAll(result2, super.preLoadCommitData(notIndexed));
        }
        TIntObjectHashMap<VcsCommitMetadata> tIntObjectHashMap = result2;
        if (tIntObjectHashMap == null) {
            MiniDetailsGetter.$$$reportNull$$$0(12);
        }
        return tIntObjectHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topCommitsDetailsCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/MiniDetailsGetter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/MiniDetailsGetter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readDetails";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "preLoadCommitData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readDetails";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "preLoadCommitData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

