/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.main;

import com.intellij.rt.coverage.instrumentation.AbstractIntellijClassfileTransformer;
import com.intellij.rt.coverage.testDiscovery.instrumentation.TestDiscoveryInnerClassInstrumenter;
import com.intellij.rt.coverage.testDiscovery.instrumentation.TestDiscoveryInstrumenter;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDiscoveryTransformer
extends AbstractIntellijClassfileTransformer {
    private static final boolean COUNTERS_IN_INNER_CLASS = System.getProperty("idea.test.discovery.counters.in.inner.class") != null;
    private final List<Pattern> exclude;
    private final List<Pattern> include;

    public TestDiscoveryTransformer(List<Pattern> exclude, List<Pattern> include) {
        this.exclude = exclude;
        this.include = include;
    }

    @Override
    protected ClassVisitor createClassVisitor(String className, ClassLoader loader, ClassReader cr, ClassWriter cw) {
        return COUNTERS_IN_INNER_CLASS ? new TestDiscoveryInnerClassInstrumenter(cw, cr, className, loader) : new TestDiscoveryInstrumenter(cw, cr, className);
    }

    @Override
    protected boolean shouldExclude(String className) {
        for (Pattern e : this.exclude) {
            if (!e.matcher(className).matches()) continue;
            return true;
        }
        for (Pattern e : this.include) {
            if (!e.matcher(className).matches()) continue;
            return false;
        }
        return !this.include.isEmpty();
    }
}

