/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.ToggleModelAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.util.Alarm;
import com.intellij.util.config.AbstractProperty;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackCoverageAction
extends ToggleModelAction {
    private final TestConsoleProperties myProperties;
    private TestFrameworkRunningModel myModel;
    private TreeSelectionListener myTreeSelectionListener;

    public TrackCoverageAction(TestConsoleProperties properties) {
        super("Show coverage per test", "Show coverage per test", AllIcons.RunConfigurations.TrackCoverage, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.TRACK_CODE_COVERAGE);
        this.myProperties = properties;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            TrackCoverageAction.$$$reportNull$$$0(0);
        }
        super.setSelected(e, state);
        if (!TestConsoleProperties.TRACK_CODE_COVERAGE.value((AbstractProperty.AbstractPropertyContainer)this.myProperties)) {
            this.restoreMergedCoverage();
        } else {
            this.selectSubCoverage();
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            TrackCoverageAction.$$$reportNull$$$0(1);
        }
        return super.isSelected(e) && CoverageDataManager.getInstance(this.myProperties.getProject()).isSubCoverageActive();
    }

    private void restoreMergedCoverage() {
        CoverageSuitesBundle currentSuite;
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(this.myProperties.getProject());
        if (coverageDataManager.isSubCoverageActive() && (currentSuite = coverageDataManager.getCurrentSuitesBundle()) != null) {
            coverageDataManager.restoreMergedCoverage(currentSuite);
        }
    }

    public void setModel(TestFrameworkRunningModel model) {
        if (this.myModel != null) {
            this.myModel.getTreeView().removeTreeSelectionListener(this.myTreeSelectionListener);
        }
        this.myModel = model;
        if (model != null) {
            this.myTreeSelectionListener = new MyTreeSelectionListener();
            model.getTreeView().addTreeSelectionListener(this.myTreeSelectionListener);
            Disposer.register((Disposable)model, (Disposable)new Disposable(){

                public void dispose() {
                    TrackCoverageAction.this.restoreMergedCoverage();
                }
            });
        }
    }

    protected boolean isEnabled() {
        CoverageSuitesBundle suite = this.getCurrentCoverageSuite();
        return suite != null && suite.isCoverageByTestApplicable() && suite.isCoverageByTestEnabled();
    }

    protected boolean isVisible() {
        CoverageSuitesBundle suite = this.getCurrentCoverageSuite();
        return suite != null && suite.isCoverageByTestApplicable();
    }

    @Nullable
    private CoverageSuitesBundle getCurrentCoverageSuite() {
        Executor executor;
        if (this.myModel == null) {
            return null;
        }
        RunProfile runConf = this.myModel.getProperties().getConfiguration();
        if (runConf instanceof ModuleBasedConfiguration && CoverageEnabledConfiguration.isApplicableTo((RunConfigurationBase)((ModuleBasedConfiguration)runConf)) && (executor = this.myProperties.getExecutor()) != null && executor.getId().equals("Coverage")) {
            return CoverageDataManager.getInstance(this.myProperties.getProject()).getCurrentSuitesBundle();
        }
        return null;
    }

    private void selectSubCoverage() {
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(this.myProperties.getProject());
        CoverageSuitesBundle currentSuite = coverageDataManager.getCurrentSuitesBundle();
        if (currentSuite != null) {
            AbstractTestProxy test = this.myModel.getTreeView().getSelectedTest();
            ArrayList<String> testMethods = new ArrayList<String>();
            if (test != null && !test.isInProgress()) {
                List list = test.getAllTests();
                for (AbstractTestProxy proxy : list) {
                    Location location = proxy.getLocation(this.myProperties.getProject(), this.myProperties.getScope());
                    if (location == null) continue;
                    PsiElement element = location.getPsiElement();
                    String name = currentSuite.getCoverageEngine().getTestMethodName(element, proxy);
                    if (name == null) continue;
                    testMethods.add(name);
                }
            }
            coverageDataManager.selectSubCoverage(currentSuite, testMethods);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/coverage/actions/TrackCoverageAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyTreeSelectionListener
    implements TreeSelectionListener {
        private final Alarm myUpdateCoverageAlarm;

        MyTreeSelectionListener() {
            this.myUpdateCoverageAlarm = new Alarm((Disposable)TrackCoverageAction.this.myModel);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (this.myUpdateCoverageAlarm.isDisposed()) {
                return;
            }
            if (!TestConsoleProperties.TRACK_CODE_COVERAGE.value((AbstractProperty.AbstractPropertyContainer)TrackCoverageAction.this.myModel.getProperties()) || !TrackCoverageAction.this.isEnabled()) {
                return;
            }
            this.myUpdateCoverageAlarm.cancelAllRequests();
            Project project = TrackCoverageAction.this.myModel.getProperties().getProject();
            CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(project);
            CoverageSuitesBundle currentSuite = coverageDataManager.getCurrentSuitesBundle();
            if (currentSuite != null) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    this.myUpdateCoverageAlarm.addRequest(() -> TrackCoverageAction.this.selectSubCoverage(), 300);
                } else if (coverageDataManager.isSubCoverageActive()) {
                    coverageDataManager.restoreMergedCoverage(currentSuite);
                }
            }
        }
    }
}

