/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogBuildType;
import java.io.File;
import java.nio.file.Path;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bJ\b\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "getType", "Lcom/intellij/internal/statistic/eventLog/EventLogBuildType;", "defaultType", "parseType", "", "Companion", "intellij.platform.statistics.uploader"})
public final class EventLogFile {
    @NotNull
    private final File file;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final EventLogBuildType getType(@NotNull EventLogBuildType defaultType) {
        Intrinsics.checkParameterIsNotNull((Object)defaultType, (String)"defaultType");
        String string = this.parseType();
        return Intrinsics.areEqual((Object)string, (Object)EventLogBuildType.EAP.text) ? EventLogBuildType.EAP : (Intrinsics.areEqual((Object)string, (Object)EventLogBuildType.RELEASE.text) ? EventLogBuildType.RELEASE : defaultType);
    }

    public static /* synthetic */ EventLogBuildType getType$default(EventLogFile eventLogFile, EventLogBuildType eventLogBuildType, int n, Object object) {
        if ((n & 1) != 0) {
            eventLogBuildType = EventLogBuildType.UNKNOWN;
        }
        return eventLogFile.getType(eventLogBuildType);
    }

    private final String parseType() {
        String name;
        String string = name = this.file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        int separator = StringsKt.lastIndexOf$default((CharSequence)string, (String)"-", (int)0, (boolean)false, (int)6, null);
        if (separator + 1 < name.length()) {
            String string2;
            int n = separator + 1;
            int n2 = 0;
            boolean bl = false;
            int startIndex = Math.max(n, n2);
            int endIndex = StringsKt.indexOf$default((CharSequence)name, (String)".", (int)startIndex, (boolean)false, (int)4, null);
            if (endIndex < 0) {
                String string3 = name;
                bl = false;
                String string4 = string3.substring(startIndex);
                string2 = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                String string5 = name;
                bl = false;
                String string6 = string5.substring(startIndex, endIndex);
                string2 = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
            return string2;
        }
        return name;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public EventLogFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
    }

    @JvmStatic
    @NotNull
    public static final EventLogFile create(@NotNull Path dir, @NotNull EventLogBuildType buildType, @NotNull String suffix) {
        return Companion.create(dir, buildType, suffix);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogFile$Companion;", "", "()V", "create", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "dir", "Ljava/nio/file/Path;", "buildType", "Lcom/intellij/internal/statistic/eventLog/EventLogBuildType;", "suffix", "", "newName", "intellij.platform.statistics.uploader"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final EventLogFile create(@NotNull Path dir, @NotNull EventLogBuildType buildType, @NotNull String suffix) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            Intrinsics.checkParameterIsNotNull((Object)buildType, (String)"buildType");
            Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
            File file = dir.resolve(this.newName(buildType, suffix)).toFile();
            while (file.exists()) {
                file = dir.resolve(this.newName(buildType, suffix)).toFile();
            }
            File file2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            return new EventLogFile(file2);
        }

        private final String newName(EventLogBuildType buildType, String suffix) {
            String string;
            int n;
            CharSequence charSequence;
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UUID.randomUUID().toString()");
            String rand = string2;
            int start = StringsKt.indexOf$default((CharSequence)rand, (char)'-', (int)0, (boolean)false, (int)6, null);
            if (start > 0 && start + 1 < rand.length()) {
                charSequence = rand;
                n = start + 1;
                boolean bl = false;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)charSequence2).substring(n);
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = rand;
            }
            String unique = string;
            charSequence = suffix;
            n = 0;
            return charSequence.length() > 0 ? unique + '-' + suffix + '-' + buildType.text + ".log" : unique + '-' + buildType.text + ".log";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

