/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.settings.CompletionMLRankingSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.stats.completion.CompletionEventLogger;
import com.intellij.stats.completion.CompletionFileLogger;
import com.intellij.stats.completion.CompletionLogger;
import com.intellij.stats.completion.CompletionLoggerImplKt;
import com.intellij.stats.completion.CompletionUtil;
import com.intellij.stats.completion.LookupExtensionsKt;
import com.intellij.stats.completion.LookupState;
import com.intellij.stats.completion.LookupStateManager;
import com.intellij.stats.completion.events.BackspaceEvent;
import com.intellij.stats.completion.events.CompletionCancelledEvent;
import com.intellij.stats.completion.events.CompletionStartedEvent;
import com.intellij.stats.completion.events.CustomMessageEvent;
import com.intellij.stats.completion.events.DownPressedEvent;
import com.intellij.stats.completion.events.ExplicitSelectEvent;
import com.intellij.stats.completion.events.LogEvent;
import com.intellij.stats.completion.events.LookupStateLogData;
import com.intellij.stats.completion.events.TypeEvent;
import com.intellij.stats.completion.events.TypedSelectEvent;
import com.intellij.stats.completion.events.UpPressedEvent;
import com.intellij.stats.storage.factors.LookupStorage;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J$\u0010\u001a\u001a\u00020\u00122\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J,\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J,\u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010'\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u00070\u0003\u00a2\u0006\u0002\b\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/stats/completion/CompletionFileLogger;", "Lcom/intellij/stats/completion/CompletionLogger;", "installationUID", "", "completionUID", "bucket", "eventLogger", "Lcom/intellij/stats/completion/CompletionEventLogger;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/stats/completion/CompletionEventLogger;)V", "ideVersion", "Lorg/jetbrains/annotations/NotNull;", "getIdeVersion", "()Ljava/lang/String;", "ideVersion$delegate", "Lkotlin/Lazy;", "stateManager", "Lcom/intellij/stats/completion/LookupStateManager;", "afterBackspacePressed", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "timestamp", "", "afterCharTyped", "c", "", "completionCancelled", "performance", "", "completionStarted", "isExperimentPerformed", "", "experimentVersion", "", "customMessage", "message", "downPressed", "itemSelectedByTyping", "itemSelectedCompletionFinished", "upPressed", "intellij.statsCollector"})
public final class CompletionFileLogger
extends CompletionLogger {
    private final LookupStateManager stateManager;
    private final Lazy ideVersion$delegate;
    private final String installationUID;
    private final String completionUID;
    private final String bucket;
    private final CompletionEventLogger eventLogger;

    private final String getIdeVersion() {
        Lazy lazy = this.ideVersion$delegate;
        CompletionFileLogger completionFileLogger = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @Override
    public void completionStarted(@NotNull LookupImpl lookup, boolean isExperimentPerformed, int experimentVersion, long timestamp) {
        Object object;
        Object userFactors;
        Object object2;
        Object mlRankingVersion;
        Object object3;
        String pluginVersion;
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, false);
        Language language = LookupExtensionsKt.language(lookup);
        LookupStorage lookupStorage = LookupStorage.Companion.get(lookup);
        String string = CompletionLoggerImplKt.access$calcPluginVersion();
        if (string == null) {
            string = pluginVersion = "pluginVersion";
        }
        if ((object3 = lookupStorage) == null || (object3 = object3.getModel()) == null || (object3 = object3.version()) == null) {
            object3 = mlRankingVersion = "NONE";
        }
        if ((object2 = lookupStorage) == null || (object2 = object2.getUserFactors()) == null) {
            object2 = userFactors = MapsKt.emptyMap();
        }
        if ((object = lookupStorage) == null || (object = object.getContextFactors()) == null) {
            object = MapsKt.emptyMap();
        }
        Object contextFactors = object;
        String string2 = this.getIdeVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ideVersion");
        Language language2 = language;
        LookupStorage lookupStorage2 = lookupStorage;
        CompletionStartedEvent event = new CompletionStartedEvent(string2, pluginVersion, (String)mlRankingVersion, this.installationUID, this.completionUID, language2 != null ? language2.getDisplayName() : null, isExperimentPerformed, experimentVersion, state, (Map)userFactors, (Map)contextFactors, LookupExtensionsKt.queryLength(lookup), this.bucket, lookupStorage2 != null ? lookupStorage2.getStartedTimestamp() : timestamp);
        Long shownTimestamp = CompletionUtil.INSTANCE.getShownTimestamp(lookup);
        if (shownTimestamp != null) {
            event.lookupShownTime = shownTimestamp;
        }
        Editor editor = lookup.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"lookup.editor");
        event.isOneLineMode = editor.isOneLineMode();
        CompletionParameters completionParameters = CompletionUtil.INSTANCE.getCurrentCompletionParameters();
        event.isAutoPopup = completionParameters != null ? Boolean.valueOf(completionParameters.isAutoPopup()) : null;
        CompletionLoggerImplKt.access$fillCompletionParameters((LookupStateLogData)event);
        event.additionalDetails.put("alphabetical", String.valueOf(UISettings.Companion.getInstance().getSortLookupElementsLexicographically()));
        if (lookupStorage != null && lookupStorage.mlUsed()) {
            CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
            if (completionMLRankingSettings.isShowDiffEnabled()) {
                event.additionalDetails.put("diff", "1");
            }
        }
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void customMessage(@NotNull String message, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        CustomMessageEvent event = new CustomMessageEvent(this.installationUID, this.completionUID, message, this.bucket, timestamp);
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void afterCharTyped(char c, @NotNull LookupImpl lookup, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, true);
        TypeEvent event = new TypeEvent(this.installationUID, this.completionUID, state, LookupExtensionsKt.queryLength(lookup), this.bucket, timestamp);
        CompletionLoggerImplKt.access$fillCompletionParameters((LookupStateLogData)event);
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void downPressed(@NotNull LookupImpl lookup, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, false);
        DownPressedEvent event = new DownPressedEvent(this.installationUID, this.completionUID, state, this.bucket, timestamp);
        CompletionLoggerImplKt.access$fillCompletionParameters((LookupStateLogData)event);
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void upPressed(@NotNull LookupImpl lookup, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, false);
        UpPressedEvent event = new UpPressedEvent(this.installationUID, this.completionUID, state, this.bucket, timestamp);
        CompletionLoggerImplKt.access$fillCompletionParameters((LookupStateLogData)event);
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void completionCancelled(@NotNull Map<String, Long> performance, long timestamp) {
        Intrinsics.checkParameterIsNotNull(performance, (String)"performance");
        CompletionCancelledEvent event = new CompletionCancelledEvent(this.installationUID, this.completionUID, performance, this.bucket, timestamp);
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void itemSelectedByTyping(@NotNull LookupImpl lookup, @NotNull Map<String, Long> performance, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        Intrinsics.checkParameterIsNotNull(performance, (String)"performance");
        LookupState state = this.stateManager.update(lookup, true);
        TypedSelectEvent event = new TypedSelectEvent(this.installationUID, this.completionUID, state, CompletionLoggerImplKt.access$getSelectedId$p(state), performance, this.bucket, timestamp);
        CompletionLoggerImplKt.access$fillCompletionParameters((LookupStateLogData)event);
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void itemSelectedCompletionFinished(@NotNull LookupImpl lookup, @NotNull Map<String, Long> performance, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        Intrinsics.checkParameterIsNotNull(performance, (String)"performance");
        LookupState state = this.stateManager.update(lookup, true);
        ExplicitSelectEvent event = new ExplicitSelectEvent(this.installationUID, this.completionUID, state, CompletionLoggerImplKt.access$getSelectedId$p(state), performance, this.bucket, timestamp);
        CompletionLoggerImplKt.access$fillCompletionParameters((LookupStateLogData)event);
        this.eventLogger.log((LogEvent)event);
    }

    @Override
    public void afterBackspacePressed(@NotNull LookupImpl lookup, long timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        LookupState state = this.stateManager.update(lookup, true);
        BackspaceEvent event = new BackspaceEvent(this.installationUID, this.completionUID, state, LookupExtensionsKt.queryLength(lookup), this.bucket, timestamp);
        CompletionLoggerImplKt.access$fillCompletionParameters((LookupStateLogData)event);
        this.eventLogger.log((LogEvent)event);
    }

    public CompletionFileLogger(@NotNull String installationUID, @NotNull String completionUID, @NotNull String bucket, @NotNull CompletionEventLogger eventLogger) {
        Intrinsics.checkParameterIsNotNull((Object)installationUID, (String)"installationUID");
        Intrinsics.checkParameterIsNotNull((Object)completionUID, (String)"completionUID");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        Intrinsics.checkParameterIsNotNull((Object)eventLogger, (String)"eventLogger");
        this.installationUID = installationUID;
        this.completionUID = completionUID;
        this.bucket = bucket;
        this.eventLogger = eventLogger;
        this.stateManager = new LookupStateManager();
        this.ideVersion$delegate = LazyKt.lazy((Function0)ideVersion.2.INSTANCE);
    }
}

