/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.InlayHintsUtilsKt;
import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationListener;
import com.intellij.codeInsight.hints.presentation.PresentationUtilKt;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001*B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0002J*\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aH\u0016J\b\u0010!\u001a\u00020\u0015H\u0016J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aH\u0016J\u0018\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\n\u00a8\u0006+"}, d2={"Lcom/intellij/codeInsight/hints/presentation/VerticalListInlayPresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "presentations", "", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "(Ljava/util/List;)V", "<set-?>", "", "height", "getHeight", "()I", "presentationUnderCursor", "getPresentationUnderCursor", "()Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "setPresentationUnderCursor", "(Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;)V", "getPresentations", "()Ljava/util/List;", "width", "getWidth", "calcDimensions", "", "changePresentationUnderCursor", "presentation", "handleMouse", "original", "Ljava/awt/Point;", "action", "Lkotlin/Function2;", "mouseClicked", "event", "Ljava/awt/event/MouseEvent;", "translated", "mouseExited", "mouseMoved", "paint", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "", "InternalListener", "intellij.platform.lang.impl"})
public final class VerticalListInlayPresentation
extends BasePresentation {
    private int width;
    private int height;
    @Nullable
    private InlayPresentation presentationUnderCursor;
    @NotNull
    private final List<InlayPresentation> presentations;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Nullable
    public final InlayPresentation getPresentationUnderCursor() {
        return this.presentationUnderCursor;
    }

    public final void setPresentationUnderCursor(@Nullable InlayPresentation inlayPresentation) {
        this.presentationUnderCursor = inlayPresentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        int yOffset = 0;
        try {
            for (InlayPresentation presentation2 : this.presentations) {
                presentation2.paint(g, attributes);
                yOffset += presentation2.getHeight();
                g.translate(0, presentation2.getHeight());
            }
        }
        finally {
            g.translate(0, -yOffset);
        }
    }

    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)translated, (String)"translated");
        this.handleMouse(translated, (Function2<? super InlayPresentation, ? super Point, Unit>)((Function2)new Function2<InlayPresentation, Point, Unit>(event){
            final /* synthetic */ MouseEvent $event;

            public final void invoke(@NotNull InlayPresentation presentation2, @NotNull Point point) {
                Intrinsics.checkParameterIsNotNull((Object)presentation2, (String)"presentation");
                Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
                presentation2.mouseClicked(this.$event, point);
            }
            {
                this.$event = mouseEvent;
                super(2);
            }
        }));
    }

    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)translated, (String)"translated");
        this.handleMouse(translated, (Function2<? super InlayPresentation, ? super Point, Unit>)((Function2)new Function2<InlayPresentation, Point, Unit>(event){
            final /* synthetic */ MouseEvent $event;

            public final void invoke(@NotNull InlayPresentation presentation2, @NotNull Point point) {
                Intrinsics.checkParameterIsNotNull((Object)presentation2, (String)"presentation");
                Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
                presentation2.mouseMoved(this.$event, point);
            }
            {
                this.$event = mouseEvent;
                super(2);
            }
        }));
    }

    public void mouseExited() {
        this.changePresentationUnderCursor(null);
    }

    /*
     * WARNING - void declaration
     */
    public final void calcDimensions() {
        void var3_5;
        void $this$sumBy$iv;
        Object var10_15;
        Object e$iv;
        Object v0;
        Iterable $this$maxBy$iv;
        Iterable iterable = this.presentations;
        VerticalListInlayPresentation verticalListInlayPresentation = this;
        boolean $i$f$maxBy = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                InlayPresentation it = (InlayPresentation)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getWidth();
                do {
                    e$iv = iterator$iv.next();
                    InlayPresentation it2 = (InlayPresentation)e$iv;
                    $i$a$-maxBy-VerticalListInlayPresentation$calcDimensions$1 = false;
                    int v$iv = it2.getWidth();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Object v1 = var10_15 = v0;
        if (v1 == null) {
            Intrinsics.throwNpe();
        }
        verticalListInlayPresentation.width = ((InlayPresentation)v1).getWidth();
        $this$maxBy$iv = this.presentations;
        verticalListInlayPresentation = this;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            e$iv = (InlayPresentation)element$iv;
            int n = sum$iv;
            boolean bl = false;
            int n2 = it.getHeight();
            sum$iv = n + n2;
        }
        void var10_17 = var3_5;
        verticalListInlayPresentation.height = var10_17;
    }

    private final void handleMouse(Point original, Function2<? super InlayPresentation, ? super Point, Unit> action2) {
        int x = original.x;
        int y = original.y;
        if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight()) {
            return;
        }
        int yOffset = 0;
        for (InlayPresentation presentation2 : this.presentations) {
            int presentationHeight = presentation2.getHeight();
            if (y < yOffset + presentationHeight && x < presentation2.getWidth()) {
                this.changePresentationUnderCursor(presentation2);
                Point translated = PresentationUtilKt.translateNew(original, 0, -yOffset);
                action2.invoke((Object)presentation2, (Object)translated);
                return;
            }
            yOffset += presentationHeight;
        }
    }

    private final void changePresentationUnderCursor(InlayPresentation presentation2) {
        if (Intrinsics.areEqual((Object)this.presentationUnderCursor, (Object)presentation2) ^ true) {
            InlayPresentation inlayPresentation = this.presentationUnderCursor;
            if (inlayPresentation != null) {
                inlayPresentation.mouseExited();
            }
            this.presentationUnderCursor = presentation2;
        }
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.presentations, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final List<InlayPresentation> getPresentations() {
        return this.presentations;
    }

    public VerticalListInlayPresentation(@NotNull List<? extends InlayPresentation> presentations) {
        Intrinsics.checkParameterIsNotNull(presentations, (String)"presentations");
        this.presentations = presentations;
        this.calcDimensions();
        for (InlayPresentation presentation2 : this.presentations) {
            presentation2.addListener((PresentationListener)new InternalListener(presentation2));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInsight/hints/presentation/VerticalListInlayPresentation$InternalListener;", "Lcom/intellij/codeInsight/hints/presentation/PresentationListener;", "currentPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "(Lcom/intellij/codeInsight/hints/presentation/VerticalListInlayPresentation;Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;)V", "contentChanged", "", "area", "Ljava/awt/Rectangle;", "shiftOfCurrent", "", "sizeChanged", "previous", "Ljava/awt/Dimension;", "current", "intellij.platform.lang.impl"})
    private final class InternalListener
    implements PresentationListener {
        private final InlayPresentation currentPresentation;

        public void contentChanged(@NotNull Rectangle area) {
            Intrinsics.checkParameterIsNotNull((Object)area, (String)"area");
            area.add(this.shiftOfCurrent(), 0);
            VerticalListInlayPresentation.this.fireContentChanged(area);
        }

        public void sizeChanged(@NotNull Dimension previous, @NotNull Dimension current2) {
            Intrinsics.checkParameterIsNotNull((Object)previous, (String)"previous");
            Intrinsics.checkParameterIsNotNull((Object)current2, (String)"current");
            Dimension old = InlayHintsUtilsKt.dimension((InlayPresentation)VerticalListInlayPresentation.this);
            VerticalListInlayPresentation.this.calcDimensions();
            Dimension dimension = InlayHintsUtilsKt.dimension((InlayPresentation)VerticalListInlayPresentation.this);
            VerticalListInlayPresentation.this.fireSizeChanged(old, dimension);
        }

        private final int shiftOfCurrent() {
            int shift = 0;
            for (InlayPresentation presentation2 : VerticalListInlayPresentation.this.getPresentations()) {
                if (presentation2 == this.currentPresentation) {
                    return shift;
                }
                shift += presentation2.getHeight();
            }
            throw (Throwable)new IllegalStateException();
        }

        public InternalListener(InlayPresentation currentPresentation) {
            Intrinsics.checkParameterIsNotNull((Object)currentPresentation, (String)"currentPresentation");
            this.currentPresentation = currentPresentation;
        }
    }
}

