/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.ide.actions.CopyReferenceUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilePathMacroBase
extends Macro {
    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        VirtualFile virtualFile;
        PsiFile file2;
        if (params == null) {
            FilePathMacroBase.$$$reportNull$$$0(0);
        }
        Project project = context.getProject();
        Editor editor = context.getEditor();
        if (editor != null && (file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null && (virtualFile = file2.getVirtualFile()) != null) {
            return this.calculateResult(virtualFile, project);
        }
        return null;
    }

    @Nullable
    protected TextResult calculateResult(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            FilePathMacroBase.$$$reportNull$$$0(1);
        }
        if (project == null) {
            FilePathMacroBase.$$$reportNull$$$0(2);
        }
        return new TextResult(virtualFile.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "params";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/template/macro/FilePathMacroBase";
        objectArray[2] = "calculateResult";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FileRelativePathMacro
    extends FilePathMacroBase {
        public String getName() {
            return "fileRelativePath";
        }

        public String getPresentableName() {
            return "fileRelativePath()";
        }

        @Override
        protected TextResult calculateResult(@NotNull VirtualFile virtualFile, @NotNull Project project) {
            if (virtualFile == null) {
                FileRelativePathMacro.$$$reportNull$$$0(0);
            }
            if (project == null) {
                FileRelativePathMacro.$$$reportNull$$$0(1);
            }
            return new TextResult(FileUtil.toSystemDependentName((String)CopyReferenceUtil.getVirtualFileFqn(virtualFile, project)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/template/macro/FilePathMacroBase$FileRelativePathMacro";
            objectArray[2] = "calculateResult";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FilePathMacro
    extends FilePathMacroBase {
        public String getName() {
            return "filePath";
        }

        public String getPresentableName() {
            return "filePath()";
        }

        @Override
        protected TextResult calculateResult(@NotNull VirtualFile virtualFile, @NotNull Project project) {
            if (virtualFile == null) {
                FilePathMacro.$$$reportNull$$$0(0);
            }
            if (project == null) {
                FilePathMacro.$$$reportNull$$$0(1);
            }
            return new TextResult(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/template/macro/FilePathMacroBase$FilePathMacro";
            objectArray[2] = "calculateResult";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FileNameMacro
    extends FilePathMacroBase {
        public String getName() {
            return "fileName";
        }

        public String getPresentableName() {
            return CodeInsightBundle.message((String)"macro.file.name", (Object[])new Object[0]);
        }

        @Override
        protected TextResult calculateResult(@NotNull VirtualFile virtualFile, @NotNull Project project) {
            if (virtualFile == null) {
                FileNameMacro.$$$reportNull$$$0(0);
            }
            if (project == null) {
                FileNameMacro.$$$reportNull$$$0(1);
            }
            return new TextResult(virtualFile.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/template/macro/FilePathMacroBase$FileNameMacro";
            objectArray[2] = "calculateResult";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FileNameWithoutExtensionMacro
    extends FilePathMacroBase {
        public String getName() {
            return "fileNameWithoutExtension";
        }

        public String getPresentableName() {
            return CodeInsightBundle.message((String)"macro.file.name.without.extension", (Object[])new Object[0]);
        }

        @Override
        protected TextResult calculateResult(@NotNull VirtualFile virtualFile, @NotNull Project project) {
            if (virtualFile == null) {
                FileNameWithoutExtensionMacro.$$$reportNull$$$0(0);
            }
            if (project == null) {
                FileNameWithoutExtensionMacro.$$$reportNull$$$0(1);
            }
            return new TextResult(virtualFile.getNameWithoutExtension());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/template/macro/FilePathMacroBase$FileNameWithoutExtensionMacro";
            objectArray[2] = "calculateResult";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

