/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.project;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.project.ConvertModuleGroupsToQualifiedNamesDialog;
import com.intellij.ide.actions.project.LoadModuleRenamingSchemeAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.module.impl.ModuleRenamingHistoryState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.JdomKt;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0017\u0010\u0005\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"EXPORTED_PATH_PROPERTY", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getDefaultRenamingSchemeFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "project", "Lcom/intellij/openapi/project/Project;", "saveDefaultRenamingSchemeFilePath", "", "filePath", "saveModuleRenamingScheme", "", "dialog", "Lcom/intellij/ide/actions/project/ConvertModuleGroupsToQualifiedNamesDialog;", "intellij.platform.ide.impl"})
public final class LoadSaveModuleRenameMappingKt {
    private static final Logger LOG;
    private static final String EXPORTED_PATH_PROPERTY = "module.renaming.scheme.file";

    public static final boolean saveModuleRenamingScheme(@NotNull ConvertModuleGroupsToQualifiedNamesDialog dialog2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialog2), (String)"dialog");
        Project project = dialog2.getProject();
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor(ProjectBundle.message((String)"module.renaming.scheme.save.chooser.title", (Object[])new Object[0]), ProjectBundle.message((String)"module.renaming.scheme.save.chooser.description", (Object[])new Object[0]), new String[]{"xml"});
        VirtualFile virtualFile = LoadSaveModuleRenameMappingKt.getDefaultRenamingSchemeFile(project);
        if (virtualFile == null || (virtualFile = virtualFile.getParent()) == null) {
            virtualFile = project.getBaseDir();
        }
        VirtualFile baseDir = virtualFile;
        VirtualFileWrapper fileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, project).save(baseDir, "module-renaming-scheme.xml");
        if (fileWrapper != null) {
            File file2 = fileWrapper.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"fileWrapper.file");
            LoadSaveModuleRenameMappingKt.saveDefaultRenamingSchemeFilePath(project, FileUtil.toSystemIndependentName((String)file2.getAbsolutePath()));
            ModuleRenamingHistoryState state = new ModuleRenamingHistoryState();
            state.oldToNewName.putAll(dialog2.getRenamingScheme());
            try {
                Element element2 = XmlSerializer.serialize((Object)state);
                Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"XmlSerializer.serialize(state)");
                Parent parent = (Parent)element2;
                Path path = fileWrapper.getFile().toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"fileWrapper.file.toPath()");
                JdomKt.write$default((Parent)parent, (Path)path, null, (int)2, null);
                VirtualFile virtualFile2 = fileWrapper.getVirtualFile();
                if (virtualFile2 != null) {
                    virtualFile2.refresh(true, false);
                }
                return true;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                String string = CommonBundle.getErrorTitle();
                Object[] objectArray = new Object[1];
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = "";
                }
                objectArray[0] = string2;
                Messages.showErrorDialog((Project)project, (String)string, (String)ProjectBundle.message((String)"module.renaming.scheme.cannot.save.error", (Object[])objectArray));
            }
        }
        return false;
    }

    private static final void saveDefaultRenamingSchemeFilePath(Project project, String filePath) {
        PropertiesComponent.getInstance((Project)project).setValue(EXPORTED_PATH_PROPERTY, filePath);
    }

    private static final VirtualFile getDefaultRenamingSchemeFile(Project project) {
        VirtualFile virtualFile;
        String string = PropertiesComponent.getInstance((Project)project).getValue(EXPORTED_PATH_PROPERTY);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(it);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    static {
        Logger logger = Logger.getInstance(LoadModuleRenamingSchemeAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(LoadM\u2026SchemeAction::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ VirtualFile access$getDefaultRenamingSchemeFile(Project project) {
        return LoadSaveModuleRenameMappingKt.getDefaultRenamingSchemeFile(project);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

