/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.actions.associate.linux;

import com.intellij.ide.lightEdit.actions.associate.FileAssociationException;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.Nullable;

public final class LocalDesktopEntryCreator {
    private static final String DESKTOP_ENTRY_PATH = ".local/share/applications";

    private LocalDesktopEntryCreator() {
    }

    static String createDesktopEntry() throws FileAssociationException {
        String entryFileName = LocalDesktopEntryCreator.getDesktopEntryFileName();
        StringBuilder builder2 = new StringBuilder();
        builder2.append("[Desktop Entry]\n").append("Type=Application\n").append("Exec=").append(LocalDesktopEntryCreator.getLauncherPath()).append("\n");
        ObjectUtils.consumeIfNotNull((Object)LocalDesktopEntryCreator.getIconPath(), iconPath -> builder2.append("Icon=").append((String)iconPath).append("\n"));
        builder2.append("Name=").append(ApplicationNamesInfo.getInstance().getFullProductName()).append("\n").append("NoDisplay=true\n");
        try {
            String entryPath = System.getProperty("user.home") + File.separator + DESKTOP_ENTRY_PATH + File.separator + entryFileName;
            FileUtil.writeToFile((File)new File(entryPath), (String)builder2.toString());
        }
        catch (IOException e) {
            throw new FileAssociationException("Desktop entry file " + entryFileName + " can't be created: " + e.getMessage());
        }
        return entryFileName;
    }

    @Nullable
    private static String getIconPath() {
        String launcherPath = LocalDesktopEntryCreator.getLauncherPath();
        if (launcherPath.startsWith("/") && launcherPath.endsWith(".sh")) {
            return StringUtil.trimEnd((String)launcherPath, (String)".sh");
        }
        return null;
    }

    private static String getDesktopEntryFileName() {
        return ApplicationNamesInfo.getInstance().getDefaultLauncherName() + ".desktop";
    }

    private static String getLauncherPath() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        Path scriptPath = PathManager.findBinFile((String)(scriptName + ".sh"));
        return scriptPath != null ? scriptPath.toString() : ApplicationNamesInfo.getInstance().getDefaultLauncherName();
    }
}

