/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J3\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/ui/FontSizeInfoUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "()V", "getGroupId", "", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getVersion", "", "newFontMetric", "metricId", "fontName", "size", "lineSpacing", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Float;)Lcom/intellij/internal/statistic/beans/MetricEvent;", "intellij.platform.ide.impl"})
public final class FontSizeInfoUsageCollector
extends ApplicationUsagesCollector {
    @NotNull
    public Set<MetricEvent> getMetrics() {
        String quickDocFontSize;
        boolean bl;
        Object appPrefs;
        boolean bl2;
        Collection collection;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        EditorColorsScheme scheme = editorColorsScheme;
        UISettings ui = UISettings.Companion.getShadowInstance();
        Set usages = SetsKt.mutableSetOf((Object[])new MetricEvent[]{this.newFontMetric("UI", ui.getFontFace(), ui.getFontSize(), null), this.newFontMetric("Presentation.mode", null, ui.getPresentationModeFontSize(), null)});
        if (!scheme.isUseAppFontPreferencesInEditor()) {
            Collection collection2 = usages;
            collection = this.newFontMetric("Editor", scheme.getEditorFontName(), scheme.getEditorFontSize(), Float.valueOf(scheme.getLineSpacing()));
            bl2 = false;
            collection2.add(collection);
        } else {
            AppEditorFontOptions appEditorFontOptions = AppEditorFontOptions.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)appEditorFontOptions, (String)"AppEditorFontOptions.getInstance()");
            FontPreferences fontPreferences = appEditorFontOptions.getFontPreferences();
            Intrinsics.checkExpressionValueIsNotNull((Object)fontPreferences, (String)"AppEditorFontOptions.getInstance().fontPreferences");
            appPrefs = fontPreferences;
            collection = usages;
            MetricEvent metricEvent = this.newFontMetric("IDE.editor", appPrefs.getFontFamily(), appPrefs.getSize(appPrefs.getFontFamily()), Float.valueOf(appPrefs.getLineSpacing()));
            bl = false;
            collection.add(metricEvent);
        }
        if (!scheme.isUseEditorFontPreferencesInConsole()) {
            appPrefs = usages;
            collection = this.newFontMetric("Console", scheme.getConsoleFontName(), scheme.getConsoleFontSize(), Float.valueOf(scheme.getConsoleLineSpacing()));
            bl2 = false;
            appPrefs.add(collection);
        }
        if ((quickDocFontSize = PropertiesComponent.getInstance().getValue("quick.doc.font.size.v3")) != null) {
            collection = usages;
            MetricEvent metricEvent = MetricEventFactoryKt.newMetric((String)"QuickDoc", (FeatureUsageData)new FeatureUsageData().addData("font_size", quickDocFontSize));
            bl = false;
            collection.add(metricEvent);
        }
        return usages;
    }

    private final MetricEvent newFontMetric(String metricId, String fontName, Integer size, Float lineSpacing) {
        FeatureUsageData data2;
        block2: {
            boolean bl;
            boolean bl2;
            Object object;
            data2 = new FeatureUsageData();
            String string = fontName;
            if (string != null) {
                object = string;
                bl2 = false;
                bl = false;
                Object it = object;
                boolean bl3 = false;
                data2.addData("font_name", (String)it);
            }
            Integer n = size;
            if (n != null) {
                object = n;
                bl2 = false;
                bl = false;
                int it = ((Number)object).intValue();
                boolean bl4 = false;
                data2.addData("font_size", it);
            }
            Float f = lineSpacing;
            if (f == null) break block2;
            object = f;
            bl2 = false;
            bl = false;
            float it = ((Number)object).floatValue();
            boolean bl5 = false;
            data2.addData("line_spacing", it);
        }
        return new MetricEvent(metricId, data2);
    }

    @NotNull
    public String getGroupId() {
        return "ui.fonts";
    }

    public int getVersion() {
        return 3;
    }
}

