/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.FileInputStream;
import org.jetbrains.annotations.Nullable;

public final class MacColorSpaceLoader {
    private static final String GENERIC_RGB_PROFILE_PATH = "/System/Library/ColorSync/Profiles/Generic RGB Profile.icc";
    private static final ColorSpace ourGenericRgbColorSpace;

    @Nullable
    public static ColorSpace getGenericRgbColorSpace() {
        return ourGenericRgbColorSpace;
    }

    static {
        ICC_ColorSpace colorSpace = null;
        if (SystemInfo.isMac) {
            try (FileInputStream is = new FileInputStream(GENERIC_RGB_PROFILE_PATH);){
                ICC_Profile profile = ICC_Profile.getInstance(is);
                colorSpace = new ICC_ColorSpace(profile);
            }
            catch (Throwable e) {
                Logger.getInstance(MacColorSpaceLoader.class).warn("Couldn't load generic RGB color profile", e);
            }
        }
        ourGenericRgbColorSpace = colorSpace;
    }
}

