/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.stripe;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.stripe.ErrorStripe;
import com.intellij.ui.stripe.ErrorStripePainter;
import com.intellij.ui.stripe.ExtraErrorStripePainter;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

public abstract class Updater<Painter extends ErrorStripePainter>
implements Disposable {
    private final Painter myPainter;
    private final JScrollBar myScrollBar;
    private final MergingUpdateQueue myQueue;
    private final MouseAdapter myMouseAdapter;

    protected Updater(@NotNull Painter painter, JScrollPane pane2) {
        if (painter == null) {
            Updater.$$$reportNull$$$0(0);
        }
        this(painter, pane2.getVerticalScrollBar());
    }

    protected Updater(@NotNull Painter painter, JScrollBar bar) {
        if (painter == null) {
            Updater.$$$reportNull$$$0(1);
        }
        this.myMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                Updater.this.onMouseMove(Updater.this.myPainter, event.getX(), event.getY());
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                Updater.this.onMouseClick(Updater.this.myPainter, event.getX(), event.getY());
            }
        };
        this.myPainter = painter;
        this.myScrollBar = bar;
        this.myScrollBar.addMouseListener(this.myMouseAdapter);
        this.myScrollBar.addMouseMotionListener(this.myMouseAdapter);
        this.myQueue = new MergingUpdateQueue("ErrorStripeUpdater", 100, true, (JComponent)this.myScrollBar, (Disposable)this);
        ComponentUtil.putClientProperty((JComponent)this.myScrollBar, (Key)JBScrollBar.TRACK, (g, x, y, width, height, object) -> {
            DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
            ((ErrorStripePainter)((Object)((Object)this.myPainter))).setMinimalThickness(settings == null ? 2 : Math.min(settings.getErrorStripeMarkMinHeight(), JBUIScale.scale((int)4)));
            ((ErrorStripePainter)((Object)((Object)this.myPainter))).setErrorStripeGap(Registry.intValue((String)"error.stripe.gap", (int)0));
            if (this.myPainter instanceof ExtraErrorStripePainter) {
                ExtraErrorStripePainter extra = (ExtraErrorStripePainter)((Object)((Object)this.myPainter));
                extra.setGroupSwap(!this.myScrollBar.getComponentOrientation().isLeftToRight());
            }
            ((ErrorStripePainter)((Object)((Object)this.myPainter))).paint(g, x, y, width, height, object);
        });
    }

    public void dispose() {
        this.myScrollBar.removeMouseListener(this.myMouseAdapter);
        this.myScrollBar.removeMouseMotionListener(this.myMouseAdapter);
        ComponentUtil.putClientProperty((JComponent)this.myScrollBar, (Key)JBScrollBar.TRACK, null);
    }

    private int findErrorStripeIndex(Painter painter, int x, int y) {
        int index = ((ErrorStripePainter)((Object)painter)).findIndex(x, y);
        if (null != ((ErrorStripePainter)((Object)painter)).getErrorStripe(index)) {
            return index;
        }
        index = ((ErrorStripePainter)((Object)painter)).findIndex(x, y + 1);
        if (null != ((ErrorStripePainter)((Object)painter)).getErrorStripe(index)) {
            return index;
        }
        index = ((ErrorStripePainter)((Object)painter)).findIndex(x, y - 1);
        if (null != ((ErrorStripePainter)((Object)painter)).getErrorStripe(index)) {
            return index;
        }
        index = ((ErrorStripePainter)((Object)painter)).findIndex(x, y + 2);
        if (null != ((ErrorStripePainter)((Object)painter)).getErrorStripe(index)) {
            return index;
        }
        return -1;
    }

    protected void onMouseMove(Painter painter, int x, int y) {
        this.onMouseMove(painter, this.findErrorStripeIndex(painter, x, y));
    }

    protected void onMouseMove(Painter painter, int index) {
        this.myScrollBar.setCursor(index < 0 ? null : Cursor.getPredefinedCursor(12));
    }

    protected void onMouseClick(Painter painter, int x, int y) {
        this.onMouseClick(painter, this.findErrorStripeIndex(painter, x, y));
    }

    protected void onMouseClick(Painter painter, int index) {
        this.onSelect(painter, index);
    }

    protected void onSelect(Painter painter, int index) {
    }

    protected ShortcutSet getNextErrorShortcut() {
        return KeymapUtil.getActiveKeymapShortcuts((String)"GotoNextError");
    }

    public void selectNext(int index) {
        this.onSelect(this.myPainter, this.findNextIndex(index));
    }

    protected ShortcutSet getPreviousErrorShortcut() {
        return KeymapUtil.getActiveKeymapShortcuts((String)"GotoPreviousError");
    }

    public void selectPrevious(int index) {
        this.onSelect(this.myPainter, this.findPreviousIndex(index));
    }

    protected abstract void update(Painter var1);

    protected void update(Painter painter, int index, Object object) {
        ((ErrorStripePainter)((Object)painter)).setErrorStripe(index, this.getErrorStripe(object));
    }

    protected ErrorStripe getErrorStripe(Object object) {
        return object instanceof ErrorStripe ? (ErrorStripe)object : null;
    }

    public final void update() {
        this.myQueue.cancelAllUpdates();
        this.myQueue.queue(new Update("update"){

            public void run() {
                Updater.this.update(Updater.this.myPainter);
                if (Updater.this.myPainter.isModified()) {
                    Updater.this.myScrollBar.invalidate();
                    Updater.this.myScrollBar.repaint();
                }
            }
        });
    }

    public int findNextIndex(int current2) {
        SearchResult result2 = new SearchResult();
        int max = ((ErrorStripePainter)((Object)this.myPainter)).getErrorStripeCount() - 1;
        if (0 <= current2 && current2 < max) {
            result2.updateForward((ErrorStripePainter)((Object)this.myPainter), current2 + 1, max);
            result2.updateForward((ErrorStripePainter)((Object)this.myPainter), 0, current2);
        } else if (0 <= max) {
            result2.updateForward((ErrorStripePainter)((Object)this.myPainter), 0, max);
        }
        return result2.index;
    }

    public int findPreviousIndex(int current2) {
        SearchResult result2 = new SearchResult();
        int max = ((ErrorStripePainter)((Object)this.myPainter)).getErrorStripeCount() - 1;
        if (0 < current2 && current2 <= max) {
            result2.updateBackward((ErrorStripePainter)((Object)this.myPainter), current2 - 1, 0);
            result2.updateBackward((ErrorStripePainter)((Object)this.myPainter), max, current2);
        } else if (0 <= max) {
            result2.updateBackward((ErrorStripePainter)((Object)this.myPainter), max, 0);
        }
        return result2.index;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/ui/stripe/Updater", "<init>"));
    }

    private static final class SearchResult {
        int layer;
        int index = -1;

        private SearchResult() {
        }

        void updateForward(ErrorStripePainter painter, int index, int max) {
            while (index <= max) {
                this.update(painter, index++);
            }
        }

        void updateBackward(ErrorStripePainter painter, int index, int min) {
            while (min <= index) {
                this.update(painter, index--);
            }
        }

        void update(ErrorStripePainter painter, int index) {
            int layer;
            ErrorStripe stripe = painter.getErrorStripe(index);
            if (stripe != null && (layer = stripe.getLayer()) > this.layer) {
                this.layer = layer;
                this.index = index;
            }
        }
    }
}

