/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lang.HtmlScriptContentProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageHtmlScriptContentProvider;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.EmbeddedTokenTypesProvider;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.documentation.HtmlDescriptorsTable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseHtmlLexer
extends DelegateLexer {
    protected static final int BASE_STATE_MASK = 63;
    private static final int SEEN_TAG = 64;
    private static final int SEEN_ATTRIBUTE = 128;
    private static final int SEEN_CONTENT_TYPE = 256;
    private static final int SEEN_STYLESHEET_TYPE = 512;
    private static final int SEEN_STYLE_SCRIPT_SHIFT = 10;
    private static final int SEEN_STYLE_SCRIPT_MASK = 7168;
    protected static final int BASE_STATE_SHIFT = 13;
    protected boolean seenTag;
    protected boolean seenAttribute;
    protected boolean seenStyle;
    protected boolean seenScript;
    private static final char SCRIPT = '\u0001';
    private static final char STYLE = '\u0002';
    private final int[] scriptStyleStack = new int[]{0, 0};
    @Nullable
    protected String scriptType = null;
    @Nullable
    protected String styleType = null;
    protected final boolean caseInsensitive;
    protected boolean seenContentType;
    protected boolean seenStylesheetType;
    private CharSequence cachedBufferSequence;
    private Lexer lexerOfCacheBufferSequence;
    static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_COMMENT_CHARACTERS, XmlTokenType.XML_WHITE_SPACE, XmlTokenType.XML_REAL_WHITE_SPACE, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_DATA_CHARACTERS, XmlTokenType.XML_TAG_CHARACTERS});
    private final HashMap<IElementType, TokenHandler> tokenHandlers = new HashMap();

    protected char getFirstChar(Lexer lexer) {
        CharSequence buffer;
        if (this.lexerOfCacheBufferSequence == lexer) {
            buffer = this.cachedBufferSequence;
        } else {
            buffer = this.cachedBufferSequence = lexer.getBufferSequence();
            this.lexerOfCacheBufferSequence = lexer;
        }
        return buffer.charAt(lexer.getTokenStart());
    }

    protected void pushScriptStyle(boolean script, boolean style) {
        int position;
        int n = position = this.scriptStyleStack[0] == 0 ? 0 : 1;
        this.scriptStyleStack[position] = script ? 1 : (style ? 2 : 0);
        this.seenStyle = style;
        this.seenScript = script;
    }

    protected void popScriptStyle() {
        int position = this.scriptStyleStack[1] == 0 ? 0 : 1;
        this.scriptStyleStack[position] = 0;
        this.seenStyle = this.scriptStyleStack[0] == 2;
        this.seenScript = this.scriptStyleStack[0] == 1;
    }

    @Nullable
    protected Language getScriptLanguage() {
        Collection instancesByMimeType = Language.findInstancesByMimeType(this.scriptType != null ? this.scriptType.trim() : null);
        return instancesByMimeType.isEmpty() ? null : (Language)instancesByMimeType.iterator().next();
    }

    @Nullable
    protected Language getStyleLanguage() {
        Language cssLanguage = Language.findLanguageByID((String)"CSS");
        if (cssLanguage != null && this.styleType != null && !"text/css".equals(this.styleType)) {
            for (Language language : cssLanguage.getDialects()) {
                for (String mimeType : language.getMimeTypes()) {
                    if (!this.styleType.equals(mimeType)) continue;
                    return language;
                }
            }
        }
        return cssLanguage;
    }

    @Nullable
    protected IElementType getCurrentScriptElementType() {
        HtmlScriptContentProvider scriptContentProvider = this.findScriptContentProvider(this.scriptType);
        return scriptContentProvider == null ? null : scriptContentProvider.getScriptElementType();
    }

    @Nullable
    protected IElementType getCurrentStylesheetElementType() {
        Language language = this.getStyleLanguage();
        if (language != null) {
            for (EmbeddedTokenTypesProvider provider : EmbeddedTokenTypesProvider.EXTENSION_POINT_NAME.getExtensionList()) {
                IElementType elementType = provider.getElementType();
                if (!language.is(elementType.getLanguage())) continue;
                return elementType;
            }
        }
        return null;
    }

    @Nullable
    protected HtmlScriptContentProvider findScriptContentProvider(@Nullable String mimeType) {
        if (StringUtil.isEmpty((String)mimeType)) {
            Language defaultLanguage = Language.findLanguageByID((String)"JavaScript");
            return defaultLanguage != null ? LanguageHtmlScriptContentProvider.getScriptContentProvider(defaultLanguage) : null;
        }
        List<HTMLLanguage> instancesByMimeType = Language.findInstancesByMimeType((String)mimeType.trim());
        if (instancesByMimeType.isEmpty() && mimeType.contains("template")) {
            instancesByMimeType = Collections.singletonList(HTMLLanguage.INSTANCE);
        }
        for (Language language : instancesByMimeType) {
            HtmlScriptContentProvider scriptContentProvider = LanguageHtmlScriptContentProvider.getScriptContentProvider(language);
            if (scriptContentProvider == null) continue;
            return scriptContentProvider;
        }
        return null;
    }

    protected BaseHtmlLexer(Lexer _baseLexer, boolean _caseInsensitive) {
        super(_baseLexer);
        this.caseInsensitive = _caseInsensitive;
        XmlNameHandler value = new XmlNameHandler();
        this.tokenHandlers.put(XmlTokenType.XML_NAME, value);
        this.tokenHandlers.put(XmlTokenType.XML_TAG_NAME, value);
        this.tokenHandlers.put(XmlTokenType.XML_TAG_END, new XmlTagClosedHandler());
        this.tokenHandlers.put(XmlTokenType.XML_END_TAG_START, new XmlTagEndHandler());
        this.tokenHandlers.put(XmlTokenType.XML_EMPTY_ELEMENT_END, new XmlTagEndHandler());
        this.tokenHandlers.put(XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER, new XmlAttributeValueEndHandler());
        this.tokenHandlers.put(XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, new XmlAttributeValueHandler());
    }

    protected void registerHandler(IElementType elementType, TokenHandler value) {
        final TokenHandler tokenHandler = this.tokenHandlers.get(elementType);
        if (tokenHandler != null) {
            final TokenHandler newHandler = value;
            value = new TokenHandler(){

                @Override
                public void handleElement(Lexer lexer) {
                    tokenHandler.handleElement(lexer);
                    newHandler.handleElement(lexer);
                }
            };
        }
        this.tokenHandlers.put(elementType, value);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            BaseHtmlLexer.$$$reportNull$$$0(0);
        }
        this.initState(initialState);
        super.start(buffer, startOffset, endOffset, initialState & 0x3F);
    }

    private void initState(int initialState) {
        this.seenTag = (initialState & 0x40) != 0;
        this.seenAttribute = (initialState & 0x80) != 0;
        this.seenContentType = (initialState & 0x100) != 0;
        this.seenStylesheetType = (initialState & 0x200) != 0;
        this.decodeScriptStack((initialState & 0x1C00) >> 10);
        int position = this.scriptStyleStack[1] == 0 ? 0 : 1;
        this.seenStyle = this.scriptStyleStack[position] == 2;
        this.seenScript = this.scriptStyleStack[position] == 1;
        this.lexerOfCacheBufferSequence = null;
        this.cachedBufferSequence = null;
    }

    protected int skipToTheEndOfTheEmbeddment() {
        Lexer base = this.getDelegate();
        int initialStart = base.getTokenStart();
        int tokenEnd = base.getTokenEnd();
        int lastState = 0;
        int lastStart = 0;
        CharSequence buf = base.getBufferSequence();
        char[] bufArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)buf);
        if (this.seenTag) {
            while (true) {
                block15: {
                    if (base.getTokenType() != XmlTokenType.XML_END_TAG_START) {
                        if (base.getTokenType() == XmlTokenType.XML_COMMENT_CHARACTERS) {
                            int end = base.getTokenEnd();
                            for (int i = base.getTokenStart(); i < end; ++i) {
                                if ((bufArray != null ? bufArray[i] : buf.charAt(i)) != '<' || i + 1 >= end || (bufArray != null ? bufArray[i + 1] : buf.charAt(i + 1)) != '/') continue;
                                tokenEnd = i;
                                lastStart = i - 1;
                                lastState = 0;
                                break block15;
                            }
                        }
                        lastState = base.getState();
                        tokenEnd = base.getTokenEnd();
                        lastStart = base.getTokenStart();
                        if (tokenEnd != this.getBufferEnd()) {
                            base.advance();
                            continue;
                        }
                        break;
                    }
                }
                if (base.getTokenType() != XmlTokenType.XML_END_TAG_START) {
                    base.start(buf, lastStart + 1, this.getBufferEnd(), lastState);
                    base.getTokenType();
                }
                base.advance();
                while (XmlTokenType.WHITESPACES.contains(base.getTokenType())) {
                    base.advance();
                }
                if (base.getTokenType() != XmlTokenType.XML_NAME) continue;
                String name = TreeUtil.getTokenText((Lexer)base);
                if (this.caseInsensitive) {
                    name = StringUtil.toLowerCase((String)name);
                }
                if (this.endOfTheEmbeddment(name)) break;
            }
            if (lastStart < initialStart) {
                base.start(buf, initialStart, this.getBufferEnd(), lastState);
                TokenHandler tokenHandler = this.tokenHandlers.get(base.getTokenType());
                if (tokenHandler != null) {
                    tokenHandler.handleElement((Lexer)this);
                }
            } else {
                base.start(buf, lastStart, this.getBufferEnd(), lastState);
                base.getTokenType();
            }
        } else if (this.seenAttribute) {
            while (this.isValidAttributeValueTokenType(base.getTokenType())) {
                tokenEnd = base.getTokenEnd();
                lastState = base.getState();
                lastStart = base.getTokenStart();
                if (tokenEnd == this.getBufferEnd()) break;
                base.advance();
            }
            base.start(buf, lastStart, this.getBufferEnd(), lastState);
            base.getTokenType();
        }
        return tokenEnd;
    }

    protected boolean endOfTheEmbeddment(String name) {
        return this.hasSeenScript() && "script".equals(name) || this.hasSeenStyle() && "style".equals(name) || "IntellijIdeaRulezzz".equalsIgnoreCase(name);
    }

    protected boolean isValidAttributeValueTokenType(IElementType tokenType) {
        return tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || tokenType == XmlTokenType.XML_ENTITY_REF_TOKEN || tokenType == XmlTokenType.XML_CHAR_ENTITY_REF;
    }

    public void advance() {
        super.advance();
        IElementType type = this.getDelegate().getTokenType();
        TokenHandler tokenHandler = this.tokenHandlers.get(type);
        if (tokenHandler != null) {
            tokenHandler.handleElement((Lexer)this);
        }
    }

    public int getState() {
        int state = super.getState();
        state |= this.seenTag ? 64 : 0;
        state |= this.seenAttribute ? 128 : 0;
        state |= this.seenContentType ? 256 : 0;
        state |= this.seenStylesheetType ? 512 : 0;
        return state |= this.encodeScriptStack() << 10;
    }

    private int encodeScriptStack() {
        if (this.scriptStyleStack[1] == 0) {
            return this.scriptStyleStack[0];
        }
        if (this.scriptStyleStack[0] == 0) {
            throw new IllegalStateException();
        }
        return this.scriptStyleStack[0] * 2 + this.scriptStyleStack[1];
    }

    private void decodeScriptStack(int value) {
        if (value <= 2) {
            this.scriptStyleStack[0] = value;
            this.scriptStyleStack[1] = 0;
        } else {
            this.scriptStyleStack[0] = (value -= 3) / 2 + 1;
            this.scriptStyleStack[1] = value % 2 + 1;
        }
    }

    protected final boolean hasSeenStyle() {
        return this.seenStyle;
    }

    protected final boolean hasSeenAttribute() {
        return this.seenAttribute;
    }

    protected final boolean hasSeenTag() {
        return this.seenTag;
    }

    protected boolean hasSeenScript() {
        return this.seenScript;
    }

    protected int getBaseStateShift() {
        return 13;
    }

    protected abstract boolean isHtmlTagState(int var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/lexer/BaseHtmlLexer", "start"));
    }

    class XmlTagEndHandler
    implements TokenHandler {
        XmlTagEndHandler() {
        }

        @Override
        public void handleElement(Lexer lexer) {
            BaseHtmlLexer.this.popScriptStyle();
            BaseHtmlLexer.this.seenAttribute = false;
            BaseHtmlLexer.this.seenContentType = false;
            BaseHtmlLexer.this.seenStylesheetType = false;
            BaseHtmlLexer.this.scriptType = null;
            BaseHtmlLexer.this.styleType = null;
        }
    }

    class XmlTagClosedHandler
    implements TokenHandler {
        XmlTagClosedHandler() {
        }

        @Override
        public void handleElement(Lexer lexer) {
            if (BaseHtmlLexer.this.seenAttribute) {
                BaseHtmlLexer.this.popScriptStyle();
                BaseHtmlLexer.this.seenAttribute = false;
            } else if (BaseHtmlLexer.this.seenStyle || BaseHtmlLexer.this.seenScript) {
                BaseHtmlLexer.this.seenTag = true;
            }
        }
    }

    class XmlAttributeValueHandler
    implements TokenHandler {
        XmlAttributeValueHandler() {
        }

        @Override
        public void handleElement(Lexer lexer) {
            if (BaseHtmlLexer.this.seenContentType && BaseHtmlLexer.this.seenScript && !BaseHtmlLexer.this.seenAttribute) {
                String mimeType = TreeUtil.getTokenText((Lexer)lexer);
                String string = BaseHtmlLexer.this.scriptType = BaseHtmlLexer.this.caseInsensitive ? StringUtil.toLowerCase((String)mimeType) : mimeType;
            }
            if (BaseHtmlLexer.this.seenStylesheetType && BaseHtmlLexer.this.seenStyle && !BaseHtmlLexer.this.seenAttribute) {
                String type = TreeUtil.getTokenText((Lexer)lexer).trim();
                BaseHtmlLexer.this.styleType = BaseHtmlLexer.this.caseInsensitive ? StringUtil.toLowerCase((String)type) : type;
            }
        }
    }

    class XmlAttributeValueEndHandler
    implements TokenHandler {
        XmlAttributeValueEndHandler() {
        }

        @Override
        public void handleElement(Lexer lexer) {
            if (BaseHtmlLexer.this.seenAttribute) {
                BaseHtmlLexer.this.popScriptStyle();
                BaseHtmlLexer.this.seenAttribute = false;
            }
            BaseHtmlLexer.this.seenContentType = false;
            BaseHtmlLexer.this.seenStylesheetType = false;
        }
    }

    public class XmlNameHandler
    implements TokenHandler {
        @NonNls
        private static final String TOKEN_SCRIPT = "script";
        @NonNls
        private static final String TOKEN_STYLE = "style";
        @NonNls
        private static final String TOKEN_ON = "on";

        @Override
        public void handleElement(Lexer lexer) {
            boolean script;
            char firstCh = BaseHtmlLexer.this.getFirstChar(lexer);
            if (BaseHtmlLexer.this.seenScript && !BaseHtmlLexer.this.seenTag) {
                BaseHtmlLexer.this.seenContentType = false;
                if (firstCh == 'l' || firstCh == 't' || BaseHtmlLexer.this.caseInsensitive && (firstCh == 'L' || firstCh == 'T')) {
                    String name = TreeUtil.getTokenText((Lexer)lexer);
                    BaseHtmlLexer.this.seenContentType = Comparing.strEqual((String)"language", (String)name, (!BaseHtmlLexer.this.caseInsensitive ? 1 : 0) != 0) || Comparing.strEqual((String)"type", (String)name, (!BaseHtmlLexer.this.caseInsensitive ? 1 : 0) != 0);
                    return;
                }
            }
            if (BaseHtmlLexer.this.seenStyle && !BaseHtmlLexer.this.seenTag) {
                BaseHtmlLexer.this.seenStylesheetType = false;
                if (firstCh == 't' || BaseHtmlLexer.this.caseInsensitive && firstCh == 'T') {
                    BaseHtmlLexer.this.seenStylesheetType = Comparing.strEqual((String)TreeUtil.getTokenText((Lexer)lexer), (String)"type", (!BaseHtmlLexer.this.caseInsensitive ? 1 : 0) != 0);
                    return;
                }
            }
            if (firstCh != 'o' && firstCh != 's' && (!BaseHtmlLexer.this.caseInsensitive || firstCh != 'S' && firstCh != 'O')) {
                return;
            }
            String name = TreeUtil.getTokenText((Lexer)lexer);
            if (BaseHtmlLexer.this.caseInsensitive) {
                name = StringUtil.toLowerCase((String)name);
            }
            boolean style = name.equals(TOKEN_STYLE);
            int state = BaseHtmlLexer.this.getState() & 0x3F;
            boolean bl = script = name.equals(TOKEN_SCRIPT) || name.startsWith(TOKEN_ON) && name.indexOf(58) == -1 && !BaseHtmlLexer.this.isHtmlTagState(state) && HtmlDescriptorsTable.getAttributeDescriptor(name) != null;
            if (style || script) {
                if (BaseHtmlLexer.this.seenTag) {
                    if (BaseHtmlLexer.this.isHtmlTagState(state)) {
                        BaseHtmlLexer.this.seenTag = false;
                    }
                    return;
                }
                if (BaseHtmlLexer.this.seenAttribute) {
                    BaseHtmlLexer.this.popScriptStyle();
                }
                BaseHtmlLexer.this.pushScriptStyle(script, style);
                if (!BaseHtmlLexer.this.isHtmlTagState(state)) {
                    BaseHtmlLexer.this.seenAttribute = true;
                }
            }
        }
    }

    public static interface TokenHandler {
        public void handleElement(Lexer var1);
    }
}

