/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.grazie;

import com.intellij.grazie.speller.GrazieSpeller;
import com.intellij.grazie.speller.GrazieSplittingSpeller;
import com.intellij.grazie.speller.Speller;
import com.intellij.grazie.speller.dictionary.Dictionary;
import com.intellij.grazie.speller.dictionary.transformation.TransformedDictionary;
import com.intellij.grazie.speller.dictionary.transformation.TransformingDictionary;
import com.intellij.grazie.speller.dictionary.transformation.WordTransformation;
import com.intellij.grazie.speller.language.English;
import com.intellij.grazie.speller.lists.TraversableWordList;
import com.intellij.grazie.speller.lists.WordList;
import com.intellij.grazie.speller.suggestion.filter.ChainSuggestionFilter;
import com.intellij.grazie.speller.suggestion.filter.SuggestionFilter;
import com.intellij.grazie.speller.suggestion.filter.feature.CasingSuggestionFilter;
import com.intellij.grazie.speller.suggestion.filter.feature.ListSuggestionFilter;
import com.intellij.grazie.speller.utils.DictionaryResources;
import com.intellij.grazie.speller.utils.spitter.CamelCaseSplitter;
import com.intellij.grazie.speller.utils.spitter.Splitter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.Transformation;
import com.intellij.spellchecker.grazie.async.GrazieAsyncSpeller;
import com.intellij.spellchecker.grazie.async.WordListLoader;
import com.intellij.spellchecker.grazie.dictionary.WordListAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0015H\u0016J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u0015H\u0016J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0015H\u0016J\b\u0010'\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/spellchecker/grazie/GrazieSpellCheckerEngine;", "Lcom/intellij/spellchecker/engine/SpellCheckerEngine;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "adapter", "Lcom/intellij/spellchecker/grazie/dictionary/WordListAdapter;", "loader", "Lcom/intellij/spellchecker/grazie/async/WordListLoader;", "mySpeller", "Lcom/intellij/grazie/speller/Speller;", "transformation", "Lcom/intellij/grazie/speller/dictionary/transformation/WordTransformation$LowerCase;", "addDictionary", "", "dictionary", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "addModifiableDictionary", "Lcom/intellij/spellchecker/dictionary/EditableDictionary;", "getSuggestions", "", "", "word", "maxSuggestions", "", "maxMetrics", "getTransformation", "Lcom/intellij/spellchecker/engine/Transformation;", "getVariants", "prefix", "isCorrect", "", "isDictionaryLoad", "name", "loadDictionary", "Lcom/intellij/spellchecker/dictionary/Loader;", "removeDictionariesRecursively", "directory", "removeDictionary", "reset", "intellij.spellchecker"})
public final class GrazieSpellCheckerEngine
implements SpellCheckerEngine {
    private final WordListLoader loader;
    private final WordListAdapter adapter;
    private final WordTransformation.LowerCase transformation;
    private final Speller mySpeller;

    @Override
    @NotNull
    public Transformation getTransformation() {
        return new Transformation();
    }

    @Override
    public boolean isDictionaryLoad(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.adapter.containsSource(name);
    }

    @Override
    public void loadDictionary(@NotNull Loader loader) {
        Intrinsics.checkParameterIsNotNull((Object)loader, (String)"loader");
        this.loader.loadWordList(loader, (Function2<? super String, ? super TraversableWordList, Unit>)((Function2)new Function2<String, TraversableWordList, Unit>(this){
            final /* synthetic */ GrazieSpellCheckerEngine this$0;

            public final void invoke(@NotNull String name, @NotNull TraversableWordList list) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
                GrazieSpellCheckerEngine.access$getAdapter$p(this.this$0).addList(name, list);
            }
            {
                this.this$0 = grazieSpellCheckerEngine;
                super(2);
            }
        }));
    }

    @Override
    public void addDictionary(@NotNull com.intellij.spellchecker.dictionary.Dictionary dictionary) {
        Intrinsics.checkParameterIsNotNull((Object)dictionary, (String)"dictionary");
        this.adapter.addDictionary(dictionary);
    }

    @Override
    public void addModifiableDictionary(@NotNull EditableDictionary dictionary) {
        Intrinsics.checkParameterIsNotNull((Object)dictionary, (String)"dictionary");
        this.addDictionary(dictionary);
    }

    @Override
    public boolean isCorrect(@NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        if (this.mySpeller.isAlien(word)) {
            return true;
        }
        return !this.mySpeller.isMisspelled(word);
    }

    @Override
    @NotNull
    public List<String> getSuggestions(@NotNull String word, int maxSuggestions, int maxMetrics) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        return CollectionsKt.toList((Iterable)CollectionsKt.take((Iterable)this.mySpeller.suggest(word, maxSuggestions), (int)maxSuggestions));
    }

    @Override
    public void reset() {
        this.adapter.reset();
    }

    @Override
    public void removeDictionary(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.adapter.removeSource(name);
    }

    @Override
    @NotNull
    public List<String> getVariants(@NotNull String prefix2) {
        Intrinsics.checkParameterIsNotNull((Object)prefix2, (String)"prefix");
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeDictionariesRecursively(@NotNull String directory) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Iterable $this$filter$iv = this.adapter.getNames();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String name = (String)element$iv$iv;
            boolean bl = false;
            if (!(FileUtil.isAncestor((String)directory, (String)name, (boolean)false) && this.isDictionaryLoad(name))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toRemove = (List)destination$iv$iv;
        for (String name : toRemove) {
            this.adapter.removeSource(name);
        }
    }

    public GrazieSpellCheckerEngine(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.loader = new WordListLoader(project);
        this.adapter = new WordListAdapter();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        this.transformation = new WordTransformation.LowerCase(locale);
        this.mySpeller = new GrazieAsyncSpeller(project, (Function0<? extends Speller>)((Function0)new Function0<GrazieSplittingSpeller>(this){
            final /* synthetic */ GrazieSpellCheckerEngine this$0;

            @NotNull
            public final GrazieSplittingSpeller invoke() {
                Splitter splitter = (Splitter)CamelCaseSplitter.INSTANCE;
                Dictionary dictionary = null;
                Dictionary dictionary2 = null;
                Dictionary dictionary3 = (Dictionary)new Dictionary.Aggregated(new Dictionary[]{(Dictionary)new TransformedDictionary((TraversableWordList)English.Lists.INSTANCE.getSuggested(), (WordTransformation)GrazieSpellCheckerEngine.access$getTransformation$p(this.this$0)), DictionaryResources.INSTANCE.getSplitsDictionary((TraversableWordList)English.Lists.INSTANCE.getSuggested(), (WordTransformation)GrazieSpellCheckerEngine.access$getTransformation$p(this.this$0), (Splitter)CamelCaseSplitter.INSTANCE), (Dictionary)new TransformingDictionary((WordList)GrazieSpellCheckerEngine.access$getAdapter$p(this.this$0), (WordTransformation)GrazieSpellCheckerEngine.access$getTransformation$p(this.this$0))});
                GrazieSpeller.UserConfig.Dictionaries dictionaries = new GrazieSpeller.UserConfig.Dictionaries((WordTransformation)GrazieSpellCheckerEngine.access$getTransformation$p(this.this$0), splitter, dictionary2, dictionary, dictionary3, 12, null);
                SuggestionFilter[] suggestionFilterArray = new SuggestionFilter[2];
                suggestionFilterArray[0] = (SuggestionFilter)new ListSuggestionFilter((WordList)English.Lists.INSTANCE.getExcluded());
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
                suggestionFilterArray[1] = (SuggestionFilter)new CasingSuggestionFilter(locale, 1);
                return new GrazieSplittingSpeller((Speller)new GrazieSpeller(new GrazieSpeller.UserConfig(0, null, dictionaries, new GrazieSpeller.UserConfig.Model(null, (SuggestionFilter)new ChainSuggestionFilter(suggestionFilterArray), null, null, 13, null), 3, null)), new GrazieSplittingSpeller.UserConfig((Splitter)CamelCaseSplitter.INSTANCE, 0, null, 6, null));
            }
            {
                this.this$0 = grazieSpellCheckerEngine;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ WordListAdapter access$getAdapter$p(GrazieSpellCheckerEngine $this) {
        return $this.adapter;
    }

    public static final /* synthetic */ WordTransformation.LowerCase access$getTransformation$p(GrazieSpellCheckerEngine $this) {
        return $this.transformation;
    }
}

