/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.Activatable;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class UiNotifyConnector
implements Disposable,
HierarchyListener {
    @NotNull
    private final WeakReference<Component> myComponent;
    private Activatable myTarget;

    public UiNotifyConnector(@NotNull Component component, @NotNull Activatable target) {
        if (component == null) {
            UiNotifyConnector.$$$reportNull$$$0(0);
        }
        if (target == null) {
            UiNotifyConnector.$$$reportNull$$$0(1);
        }
        this.myComponent = new WeakReference<Component>(component);
        this.myTarget = target;
        if (component.isShowing()) {
            this.showNotify();
        } else {
            this.hideNotify();
        }
        if (this.isDisposed()) {
            return;
        }
        component.addHierarchyListener(this);
    }

    @Override
    public void hierarchyChanged(@NotNull HierarchyEvent e) {
        if (e == null) {
            UiNotifyConnector.$$$reportNull$$$0(2);
        }
        if (this.isDisposed() || (e.getChangeFlags() & 4L) <= 0L) {
            return;
        }
        Runnable runnable = () -> {
            Component c = (Component)this.myComponent.get();
            if (this.isDisposed() || c == null) {
                return;
            }
            if (c.isShowing()) {
                this.showNotify();
            } else {
                this.hideNotify();
            }
        };
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isDispatchThread()) {
            app.invokeLater(runnable, ModalityState.current());
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected void hideNotify() {
        this.myTarget.hideNotify();
    }

    protected void showNotify() {
        this.myTarget.showNotify();
    }

    protected void hideOnDispose() {
        this.myTarget.hideNotify();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.hideOnDispose();
        Component c = (Component)this.myComponent.get();
        if (c != null) {
            c.removeHierarchyListener(this);
        }
        this.myTarget = null;
        this.myComponent.clear();
    }

    private boolean isDisposed() {
        return this.myTarget == null;
    }

    public static void doWhenFirstShown(@NotNull JComponent c, @NotNull Runnable runnable) {
        if (c == null) {
            UiNotifyConnector.$$$reportNull$$$0(3);
        }
        if (runnable == null) {
            UiNotifyConnector.$$$reportNull$$$0(4);
        }
        UiNotifyConnector.doWhenFirstShown((Component)c, runnable);
    }

    public static void doWhenFirstShown(@NotNull Component c, final @NotNull Runnable runnable) {
        if (c == null) {
            UiNotifyConnector.$$$reportNull$$$0(5);
        }
        if (runnable == null) {
            UiNotifyConnector.$$$reportNull$$$0(6);
        }
        UiNotifyConnector.doWhenFirstShown(c, new Activatable(){

            @Override
            public void showNotify() {
                runnable.run();
            }
        });
    }

    public static void doWhenFirstShown(@NotNull Component c, @NotNull Activatable activatable) {
        if (c == null) {
            UiNotifyConnector.$$$reportNull$$$0(7);
        }
        if (activatable == null) {
            UiNotifyConnector.$$$reportNull$$$0(8);
        }
        new UiNotifyConnector(c, activatable){

            @Override
            protected void showNotify() {
                super.showNotify();
                Disposer.dispose((Disposable)this);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activatable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/update/UiNotifyConnector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hierarchyChanged";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doWhenFirstShown";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Once
    extends UiNotifyConnector {
        private boolean myShown;
        private boolean myHidden;

        public Once(Component component, Activatable target) {
            super(component, target);
        }

        @Override
        protected final void hideNotify() {
            super.hideNotify();
            this.myHidden = true;
            this.disposeIfNeeded();
        }

        @Override
        protected final void showNotify() {
            super.showNotify();
            this.myShown = true;
            this.disposeIfNeeded();
        }

        @Override
        protected void hideOnDispose() {
        }

        private void disposeIfNeeded() {
            if (this.myShown && this.myHidden) {
                Disposer.dispose((Disposable)this);
            }
        }
    }
}

