/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyMoveExceptQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PyExceptClausesOrderInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyExceptClausesOrderInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyExceptClausesOrderInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyExceptClausesOrderInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
        }

        @Override
        public void visitPyTryExceptStatement(PyTryExceptStatement node) {
            PyExceptPart[] exceptParts = node.getExceptParts();
            if (exceptParts.length > 1) {
                HashSet<PyClass> exceptClasses = new HashSet<PyClass>();
                for (PyExceptPart exceptPart : exceptParts) {
                    PsiElement element;
                    PyExpression exceptClass = exceptPart.getExceptClass();
                    if (!(exceptClass instanceof PyReferenceExpression) || !((element = ((PyReferenceExpression)exceptClass).followAssignmentsChain(this.getResolveContext()).getElement()) instanceof PyClass)) continue;
                    PyClass pyClass = (PyClass)element;
                    if (exceptClasses.contains(pyClass)) {
                        this.registerProblem((PsiElement)exceptClass, PyPsiBundle.message("INSP.class.$0.already.caught", pyClass.getName()));
                    } else {
                        for (PyClass superClass : pyClass.getSuperClasses(null)) {
                            if (!exceptClasses.contains(superClass)) continue;
                            this.registerProblem((PsiElement)exceptClass, PyPsiBundle.message("INSP.class.$0.superclass.$1.already.caught", superClass.getName(), pyClass.getName()), new PyMoveExceptQuickFix());
                        }
                    }
                    exceptClasses.add(pyClass);
                }
            }
        }
    }
}

