/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.ui.PyClassCellRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class SuperClassesManager
extends MembersManager<PyClass> {
    SuperClassesManager() {
        super(PyClass.class);
    }

    @Override
    @NotNull
    protected Collection<PyElement> getDependencies(@NotNull MultiMap<PyClass, PyElement> usedElements) {
        if (usedElements == null) {
            SuperClassesManager.$$$reportNull$$$0(0);
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)usedElements.keySet());
        if (arrayList == null) {
            SuperClassesManager.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected MultiMap<PyClass, PyElement> getDependencies(@NotNull PyElement member) {
        if (member == null) {
            SuperClassesManager.$$$reportNull$$$0(2);
        }
        MultiMap multiMap = MultiMap.empty();
        if (multiMap == null) {
            SuperClassesManager.$$$reportNull$$$0(3);
        }
        return multiMap;
    }

    @Override
    public boolean hasConflict(@NotNull PyClass member, @NotNull PyClass aClass) {
        List<PyExpression> expressionList;
        if (member == null) {
            SuperClassesManager.$$$reportNull$$$0(4);
        }
        if (aClass == null) {
            SuperClassesManager.$$$reportNull$$$0(5);
        }
        return !(expressionList = SuperClassesManager.getExpressionsBySuperClass(aClass, Collections.singleton(member))).isEmpty();
    }

    @Override
    @NotNull
    protected List<PyElement> getMembersCouldBeMoved(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            SuperClassesManager.$$$reportNull$$$0(6);
        }
        ArrayList arrayList = Lists.newArrayList(Arrays.asList(pyClass.getSuperClasses(null)));
        if (arrayList == null) {
            SuperClassesManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    protected Collection<PyElement> moveMembers(@NotNull PyClass from, @NotNull Collection<PyMemberInfo<PyClass>> members2, PyClass ... to) {
        if (from == null) {
            SuperClassesManager.$$$reportNull$$$0(8);
        }
        if (members2 == null) {
            SuperClassesManager.$$$reportNull$$$0(9);
        }
        if (to == null) {
            SuperClassesManager.$$$reportNull$$$0(10);
        }
        Collection<PyClass> elements = SuperClassesManager.fetchElements(members2);
        for (PyClass destClass : to) {
            PyPsiRefactoringUtil.addSuperclasses(from.getProject(), destClass, elements.toArray(new PyClass[members2.size()]));
        }
        List<PyExpression> expressionsToDelete = SuperClassesManager.getExpressionsBySuperClass(from, elements);
        for (PyExpression expressionToDelete : expressionsToDelete) {
            expressionToDelete.delete();
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<PyExpression> getExpressionsBySuperClass(@NotNull PyClass from, @NotNull Collection<PyClass> classes) {
        if (from == null) {
            SuperClassesManager.$$$reportNull$$$0(11);
        }
        if (classes == null) {
            SuperClassesManager.$$$reportNull$$$0(12);
        }
        ArrayList<PyExpression> expressionsToDelete = new ArrayList<PyExpression>(classes.size());
        for (PyExpression expression : from.getSuperClassExpressions()) {
            if (!(expression instanceof PyQualifiedExpression)) continue;
            PyReferenceExpression reference = (PyReferenceExpression)expression;
            for (PyClass element : classes) {
                if (!reference.getReference().isReferenceTo((PsiElement)element)) continue;
                expressionsToDelete.add(expression);
            }
        }
        ArrayList<PyExpression> arrayList = expressionsToDelete;
        if (arrayList == null) {
            SuperClassesManager.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public PyMemberInfo<PyClass> apply(@NotNull PyClass input) {
        if (input == null) {
            SuperClassesManager.$$$reportNull$$$0(14);
        }
        String name = RefactoringBundle.message((String)"member.info.extends.0", (Object[])new Object[]{PyClassCellRenderer.getClassText(input)});
        return new PyMemberInfo<PyClass>(input, false, name, false, this, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedElements";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersCouldBeMoved";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionsBySuperClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 13: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasConflict";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMembersCouldBeMoved";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveMembers";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionsBySuperClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

