/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.messages.Topic;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.ActiveSdkListener;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import com.jetbrains.python.ui.PyUiUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u001aH\u00104\u001a\u0004\u0018\u00010\f2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u000207062\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f092\b\u0010:\u001a\u0004\u0018\u00010\f2\b\u0010;\u001a\u0004\u0018\u00010\u00162\b\u0010<\u001a\u0004\u0018\u00010\u0016\u001a,\u0010=\u001a\b\u0012\u0004\u0012\u00020 092\b\u0010>\u001a\u0004\u0018\u00010\u000b2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f092\u0006\u0010?\u001a\u00020@\u001a0\u0010A\u001a\b\u0012\u0004\u0012\u00020 092\b\u0010>\u001a\u0004\u0018\u00010\u000b2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f092\b\b\u0002\u0010?\u001a\u00020@H\u0007\u001a,\u0010B\u001a\b\u0012\u0004\u0012\u00020 092\b\u0010>\u001a\u0004\u0018\u00010\u000b2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f092\u0006\u0010?\u001a\u00020@\u001a4\u0010C\u001a\b\u0012\u0004\u0012\u00020 092\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00160E2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f092\b\u0010>\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u001a\u0010F\u001a\b\u0012\u0004\u0012\u00020\f092\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f09\u001a\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020\f092\b\u0010H\u001a\u0004\u0018\u00010\u0007\u001a,\u0010I\u001a\b\u0012\u0004\u0012\u00020\f092\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f092\b\u0010>\u001a\u0004\u0018\u00010\u000b2\u0006\u0010?\u001a\u00020@\u001a&\u0010J\u001a\u0004\u0018\u00010 2\u0006\u0010>\u001a\u00020\u000b2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f092\u0006\u0010?\u001a\u00020@\u001a\u001e\u0010K\u001a\u0004\u0018\u00010\f2\u0006\u0010>\u001a\u00020\u000b2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f09\u001a\u0006\u0010L\u001a\u00020M\u001a\u001c\u0010N\u001a\u0004\u0018\u00010\u00162\u0006\u0010O\u001a\u00020\u00162\b\u0010P\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\n\u0010Q\u001a\u00020$*\u00020\f\u001a\u001e\u0010R\u001a\u00020M*\u00020\f2\b\u0010>\u001a\u0004\u0018\u00010\u000b2\b\u0010S\u001a\u0004\u0018\u00010\u0016\u001a\u0016\u0010T\u001a\u00020$*\u00020\f2\b\u0010>\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0012\u0010U\u001a\u00020M*\u00020\u000b2\u0006\u0010V\u001a\u00020\f\u001a\u0014\u0010W\u001a\u00020M*\u00020\u000b2\b\u0010)\u001a\u0004\u0018\u00010\f\u001a\n\u0010X\u001a\u00020Y*\u00020\f\u001a\u0014\u0010Z\u001a\u00020$*\u00020\f2\b\u0010>\u001a\u0004\u0018\u00010\u000b\u001a\u0014\u0010[\u001a\u00020$*\u00020\f2\b\u0010>\u001a\u0004\u0018\u00010\u000b\u001a\u0016\u0010\\\u001a\u00020$*\u00020\f2\b\u0010>\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u001a\u0010]\u001a\u0004\u0018\u00010\f*\u00020 2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f09\u001a$\u0010^\u001a\u0004\u0018\u00010\f*\u00020 2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f092\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\" \u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u0016*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\" \u0010\u001b\u001a\u0004\u0018\u00010\u0016*\u00020\f8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u000e\u001a\u0004\b\u001d\u0010\u0018\"\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\"\u0015\u0010#\u001a\u00020$*\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010&\"\u0018\u0010'\u001a\u00020$*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\",\u0010*\u001a\u0004\u0018\u00010\f*\u00020\u000b2\b\u0010)\u001a\u0004\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\",\u0010*\u001a\u0004\u0018\u00010\f*\u00020/2\b\u0010)\u001a\u0004\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u00100\"\u0004\b-\u00101\"\u001a\u00102\u001a\u0004\u0018\u00010\u0012*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0014\u00a8\u0006_"}, d2={"ACTIVE_PYTHON_SDK_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/jetbrains/python/sdk/ActiveSdkListener;", "getACTIVE_PYTHON_SDK_TOPIC", "()Lcom/intellij/util/messages/Topic;", "BASE_DIR", "Lcom/intellij/openapi/util/Key;", "Ljava/nio/file/Path;", "getBASE_DIR", "()Lcom/intellij/openapi/util/Key;", "associatedModule", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/openapi/projectRoots/Sdk;", "associatedModule$annotations", "(Lcom/intellij/openapi/projectRoots/Sdk;)V", "getAssociatedModule", "(Lcom/intellij/openapi/projectRoots/Sdk;)Lcom/intellij/openapi/module/Module;", "associatedModuleDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAssociatedModuleDir", "(Lcom/intellij/openapi/projectRoots/Sdk;)Lcom/intellij/openapi/vfs/VirtualFile;", "associatedModulePath", "", "getAssociatedModulePath", "(Lcom/intellij/openapi/projectRoots/Sdk;)Ljava/lang/String;", "associatedPathFromAdditionalData", "getAssociatedPathFromAdditionalData", "associatedPathFromDotProject", "associatedPathFromDotProject$annotations", "getAssociatedPathFromDotProject", "guessedLanguageLevel", "Lcom/jetbrains/python/psi/LanguageLevel;", "Lcom/jetbrains/python/sdk/PyDetectedSdk;", "getGuessedLanguageLevel", "(Lcom/jetbrains/python/sdk/PyDetectedSdk;)Lcom/jetbrains/python/psi/LanguageLevel;", "isNotEmptyDirectory", "", "Ljava/io/File;", "(Ljava/io/File;)Z", "isSystemWide", "(Lcom/intellij/openapi/projectRoots/Sdk;)Z", "value", "pythonSdk", "getPythonSdk", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/projectRoots/Sdk;", "setPythonSdk", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/projectRoots/Sdk;)V", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;)V", "sitePackagesDirectory", "getSitePackagesDirectory", "createSdkByGenerateTask", "generateSdkHomePath", "Lcom/intellij/openapi/progress/Task$WithResult;", "Lcom/intellij/execution/ExecutionException;", "existingSdks", "", "baseSdk", "associatedProjectPath", "suggestedSdkName", "detectCondaEnvs", "module", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "detectSystemWideSdks", "detectVirtualEnvs", "filterSuggestedPaths", "suggestedPaths", "", "filterSystemWideSdks", "findAllPythonSdks", "baseDir", "findBaseSdks", "findDetectedAssociatedEnvironment", "findExistingAssociatedSdk", "resetSystemWideSdksDetectors", "", "suggestAssociatedSdkName", "sdkHome", "associatedPath", "adminPermissionsNeeded", "associateWithModule", "newProjectPath", "containsModuleName", "excludeInnerVirtualEnv", "sdk", "fireActivePythonSdkChanged", "getOrCreateAdditionalData", "Lcom/jetbrains/python/sdk/PythonSdkAdditionalData;", "isAssociatedWithAnotherModule", "isAssociatedWithModule", "isLocatedInsideModule", "setup", "setupAssociated", "intellij.python.community.impl"})
public final class PySdkExtKt {
    @NotNull
    private static final Key<Path> BASE_DIR;
    @NotNull
    private static final Topic<ActiveSdkListener> ACTIVE_PYTHON_SDK_TOPIC;

    @NotNull
    public static final Key<Path> getBASE_DIR() {
        return BASE_DIR;
    }

    @NotNull
    public static final List<Sdk> findAllPythonSdks(@Nullable Path baseDir) {
        List<Sdk> existing;
        UserDataHolder context = (UserDataHolder)new UserDataHolderBase();
        if (baseDir != null) {
            context.putUserData(BASE_DIR, (Object)baseDir);
        }
        List<Sdk> list = existing = PythonSdkUtil.getAllSdks();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"existing");
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)PySdkExtKt.detectCondaEnvs(null, list, context), (Iterable)PySdkExtKt.detectVirtualEnvs(null, existing, context)), (Iterable)PySdkExtKt.findBaseSdks(existing, null, context));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Sdk> findBaseSdks(@NotNull List<? extends Sdk> existingSdks, @Nullable Module module, @NotNull UserDataHolder context) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNotTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Iterable $this$filterNot$iv = PySdkExtKt.filterSystemWideSdks(existingSdks);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
            Sdk it = (Sdk)element$iv$iv;
            boolean bl = false;
            if (PythonSdkUtil.isBaseConda(it.getHomePath())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existing = (List)destination$iv$iv;
        Iterable $this$filterNot$iv2 = PySdkExtKt.detectSystemWideSdks(module, existingSdks, context);
        boolean $i$f$filterNot2 = false;
        destination$iv$iv = $this$filterNot$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo2 = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PyDetectedSdk it = (PyDetectedSdk)((Object)element$iv$iv);
            boolean bl = false;
            if (PythonSdkUtil.isBaseConda(it.getHomePath())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List detected = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)existing, (Iterable)detected);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Sdk> filterSystemWideSdks(@NotNull List<? extends Sdk> existingSdks) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Iterable $this$filter$iv = existingSdks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Sdk it = (Sdk)element$iv$iv;
            boolean bl = false;
            if (!(it.getSdkType() instanceof PythonSdkType && PySdkExtKt.isSystemWide(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public static final List<PyDetectedSdk> detectSystemWideSdks(@Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @NotNull UserDataHolder context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (module != null && module.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = existingSdks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Sdk sdk = (Sdk)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getHomePath();
            collection.add(string);
        }
        Set existingPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List<PythonSdkFlavor> list = PythonSdkFlavor.getApplicableFlavors(false);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"PythonSdkFlavor.getApplicableFlavors(false)");
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<PythonSdkFlavor, Sequence<? extends String>>(module, context){
            final /* synthetic */ Module $module;
            final /* synthetic */ UserDataHolder $context;

            @NotNull
            public final Sequence<String> invoke(PythonSdkFlavor it) {
                Collection<String> collection = it.suggestHomePaths(this.$module, this.$context);
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"it.suggestHomePaths(module, context)");
                return CollectionsKt.asSequence((Iterable)collection);
            }
            {
                this.$module = module;
                this.$context = userDataHolder;
                super(1);
            }
        })), (Function1)((Function1)new Function1<String, Boolean>(existingPaths){
            final /* synthetic */ Set $existingPaths;

            public final boolean invoke(String it) {
                return !this.$existingPaths.contains(it);
            }
            {
                this.$existingPaths = set;
                super(1);
            }
        })), (Function1)detectSystemWideSdks.3.INSTANCE);
        Comparator comparator = ComparisonsKt.compareBy((Function1[])new Function1[]{detectSystemWideSdks.4.INSTANCE, detectSystemWideSdks.5.INSTANCE}).reversed();
        Intrinsics.checkExpressionValueIsNotNull(comparator, (String)"compareBy<PyDetectedSdk>\u2026it.homePath }).reversed()");
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)sequence, comparator));
    }

    public static /* synthetic */ List detectSystemWideSdks$default(Module module, List list, UserDataHolder userDataHolder, int n, Object object) {
        if ((n & 4) != 0) {
            userDataHolder = (UserDataHolder)new UserDataHolderBase();
        }
        return PySdkExtKt.detectSystemWideSdks(module, list, userDataHolder);
    }

    @JvmOverloads
    @NotNull
    public static final List<PyDetectedSdk> detectSystemWideSdks(@Nullable Module module, @NotNull List<? extends Sdk> existingSdks) {
        return PySdkExtKt.detectSystemWideSdks$default(module, existingSdks, null, 4, null);
    }

    public static final void resetSystemWideSdksDetectors() {
        List<PythonSdkFlavor> list = PythonSdkFlavor.getApplicableFlavors(false);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"PythonSdkFlavor.getApplicableFlavors(false)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PythonSdkFlavor p1 = (PythonSdkFlavor)element$iv;
            boolean bl = false;
            p1.dropCaches();
        }
    }

    @NotNull
    public static final List<PyDetectedSdk> detectVirtualEnvs(@Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @NotNull UserDataHolder context) {
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Collection<String> collection = VirtualEnvSdkFlavor.getInstance().suggestHomePaths(module, context);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"VirtualEnvSdkFlavor.getI\u2026omePaths(module, context)");
        return PySdkExtKt.filterSuggestedPaths(collection, existingSdks, module);
    }

    @NotNull
    public static final List<PyDetectedSdk> detectCondaEnvs(@Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @NotNull UserDataHolder context) {
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Collection<String> collection = CondaEnvSdkFlavor.getInstance().suggestHomePaths(module, context);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"CondaEnvSdkFlavor.getIns\u2026omePaths(module, context)");
        return PySdkExtKt.filterSuggestedPaths(collection, existingSdks, module);
    }

    @Nullable
    public static final Sdk findExistingAssociatedSdk(@NotNull Module module, @NotNull List<? extends Sdk> existingSdks) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Sequence $this$sortedByDescending$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)existingSdks), (Function1)((Function1)new Function1<Sdk, Boolean>(module){
            final /* synthetic */ Module $module;

            public final boolean invoke(@NotNull Sdk it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.getSdkType() instanceof PythonSdkType && PySdkExtKt.isAssociatedWithModule(it, this.$module);
            }
            {
                this.$module = module;
                super(1);
            }
        }));
        boolean $i$f$sortedByDescending = false;
        Sequence sequence = $this$sortedByDescending$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Sdk it = (Sdk)b;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getHomePath());
                it = (Sdk)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getHomePath();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        return (Sdk)SequencesKt.firstOrNull((Sequence)SequencesKt.sortedWith((Sequence)sequence, (Comparator)comparator));
    }

    @Nullable
    public static final PyDetectedSdk findDetectedAssociatedEnvironment(@NotNull Module module, @NotNull List<? extends Sdk> existingSdks, @NotNull UserDataHolder context) {
        Object v2;
        Object it;
        block5: {
            Object v0;
            PyDetectedSdk it2;
            Object element$iv;
            Iterator iterator;
            boolean $i$f$firstOrNull;
            Object $this$firstOrNull$iv;
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                $this$firstOrNull$iv = PySdkExtKt.detectVirtualEnvs(module, existingSdks, context);
                $i$f$firstOrNull = false;
                iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    it2 = (PyDetectedSdk)((Object)element$iv);
                    boolean bl = false;
                    if (!PySdkExtKt.isAssociatedWithModule((Sdk)it2, module)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            PyDetectedSdk pyDetectedSdk = v0;
            if (pyDetectedSdk != null) {
                $this$firstOrNull$iv = pyDetectedSdk;
                $i$f$firstOrNull = false;
                boolean bl = false;
                it = $this$firstOrNull$iv;
                boolean bl2 = false;
                return it;
            }
            $this$firstOrNull$iv = PySdkExtKt.detectCondaEnvs(module, existingSdks, context);
            $i$f$firstOrNull = false;
            iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it2 = (PyDetectedSdk)((Object)element$iv);
                boolean bl = false;
                if (!PySdkExtKt.isAssociatedWithModule((Sdk)it2, module)) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        PyDetectedSdk pyDetectedSdk = v2;
        if (pyDetectedSdk != null) {
            PyDetectedSdk pyDetectedSdk2 = pyDetectedSdk;
            boolean bl = false;
            boolean bl3 = false;
            it = pyDetectedSdk2;
            boolean bl4 = false;
            return it;
        }
        return null;
    }

    @Nullable
    public static final Sdk createSdkByGenerateTask(@NotNull Task.WithResult<String, ExecutionException> generateSdkHomePath, @NotNull List<? extends Sdk> existingSdks, @Nullable Sdk baseSdk, @Nullable String associatedProjectPath, @Nullable String suggestedSdkName) {
        String homePath;
        Intrinsics.checkParameterIsNotNull(generateSdkHomePath, (String)"generateSdkHomePath");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        try {
            homePath = (String)ProgressManager.getInstance().run(generateSdkHomePath);
            VirtualFile virtualFile = StandardFileSystems.local().refreshAndFindFileByPath(homePath);
            if (virtualFile == null) {
                throw (Throwable)new ExecutionException("Directory " + homePath + " not found");
            }
            homePath = virtualFile;
        }
        catch (ExecutionException e) {
            PackageManagementService.ErrorDescription errorDescription = PyPackageManagementService.toErrorDescription(CollectionsKt.listOf((Object)((Object)e)), baseSdk);
            if (errorDescription == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)errorDescription, (String)"PyPackageManagementServi\u2026, baseSdk) ?: return null");
            PackageManagementService.ErrorDescription description = errorDescription;
            PackagesNotificationPanel.showError((String)PyBundle.message("python.sdk.failed.to.create.interpreter.title", new Object[0]), (PackageManagementService.ErrorDescription)description);
            return null;
        }
        String string = homePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"try {\n    val homePath =\u2026tion)\n    return null\n  }");
        String homeFile = string;
        String string2 = suggestedSdkName;
        if (string2 == null) {
            String string3 = homeFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"homeFile.path");
            string2 = PySdkExtKt.suggestAssociatedSdkName(string3, associatedProjectPath);
        }
        String suggestedName = string2;
        Collection $this$toTypedArray$iv = existingSdks;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Sdk[] sdkArray = thisCollection$iv.toArray(new Sdk[0]);
        if (sdkArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Sdk sdk = SdkConfigurationUtil.setupSdk((Sdk[])sdkArray, (VirtualFile)homeFile, (SdkType)PythonSdkType.getInstance(), (boolean)false, null, (String)suggestedName);
        if (sdk == null) {
            return null;
        }
        return sdk;
    }

    public static final void associateWithModule(@NotNull Sdk $this$associateWithModule, @Nullable Module module, @Nullable String newProjectPath) {
        Intrinsics.checkParameterIsNotNull((Object)$this$associateWithModule, (String)"$this$associateWithModule");
        PythonSdkAdditionalData pythonSdkAdditionalData = PySdkExtKt.getOrCreateAdditionalData($this$associateWithModule);
        boolean bl = false;
        boolean bl2 = false;
        PythonSdkAdditionalData $this$apply = pythonSdkAdditionalData;
        boolean bl3 = false;
        if (newProjectPath != null) {
            $this$apply.associateWithModulePath(newProjectPath);
        } else if (module != null) {
            $this$apply.associateWithModule(module);
        }
    }

    public static final boolean isAssociatedWithModule(@NotNull Sdk $this$isAssociatedWithModule, @Nullable Module module) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAssociatedWithModule, (String)"$this$isAssociatedWithModule");
        Module module2 = module;
        String basePath = module2 != null ? BasePySdkExtKt.getBasePath(module2) : null;
        String associatedPath = PySdkExtKt.getAssociatedModulePath($this$isAssociatedWithModule);
        if (basePath != null && Intrinsics.areEqual((Object)associatedPath, (Object)basePath)) {
            return true;
        }
        if (PySdkExtKt.isAssociatedWithAnotherModule($this$isAssociatedWithModule, module)) {
            return false;
        }
        return PySdkExtKt.isLocatedInsideModule($this$isAssociatedWithModule, module) || PySdkExtKt.containsModuleName($this$isAssociatedWithModule, module);
    }

    public static final boolean isAssociatedWithAnotherModule(@NotNull Sdk $this$isAssociatedWithAnotherModule, @Nullable Module module) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAssociatedWithAnotherModule, (String)"$this$isAssociatedWithAnotherModule");
        Object object = module;
        if (object == null || (object = BasePySdkExtKt.getBasePath(object)) == null) {
            return false;
        }
        Object basePath = object;
        String string = PySdkExtKt.getAssociatedModulePath($this$isAssociatedWithAnotherModule);
        if (string == null) {
            return false;
        }
        String associatedPath = string;
        return Intrinsics.areEqual((Object)basePath, (Object)associatedPath) ^ true;
    }

    @Nullable
    public static final String getAssociatedModulePath(@NotNull Sdk $this$associatedModulePath) {
        Intrinsics.checkParameterIsNotNull((Object)$this$associatedModulePath, (String)"$this$associatedModulePath");
        return PySdkExtKt.getAssociatedPathFromAdditionalData($this$associatedModulePath);
    }

    @Deprecated(message="Use Sdk.associatedModuleDir instead. There may be several Module objects opened in different projects for a single *.iml module file. To be removed in 2021.2")
    public static /* synthetic */ void associatedModule$annotations(Sdk sdk) {
    }

    @Nullable
    public static final Module getAssociatedModule(@NotNull Sdk $this$associatedModule) {
        Object v3;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$this$associatedModule, (String)"$this$associatedModule");
            String associatedPath = PySdkExtKt.getAssociatedModulePath($this$associatedModule);
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
            Object[] objectArray = projectManager.getOpenProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ProjectManager.getInstance().openProjects");
            Sequence $this$firstOrNull$iv = SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)associatedModule.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Module it = (Module)element$iv;
                boolean bl = false;
                Module module = it;
                if (!Intrinsics.areEqual((Object)(module != null ? BasePySdkExtKt.getBasePath(module) : null), (Object)associatedPath)) continue;
                v3 = element$iv;
                break block1;
            }
            v3 = null;
        }
        return v3;
    }

    @Nullable
    public static final VirtualFile getAssociatedModuleDir(@NotNull Sdk $this$associatedModuleDir) {
        VirtualFile virtualFile;
        Intrinsics.checkParameterIsNotNull((Object)$this$associatedModuleDir, (String)"$this$associatedModuleDir");
        String string = PySdkExtKt.getAssociatedModulePath($this$associatedModuleDir);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            virtualFile = StandardFileSystems.local().findFileByPath(it);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    public static final boolean adminPermissionsNeeded(@NotNull Sdk $this$adminPermissionsNeeded) {
        Intrinsics.checkParameterIsNotNull((Object)$this$adminPermissionsNeeded, (String)"$this$adminPermissionsNeeded");
        Object object = PySdkExtKt.getSitePackagesDirectory($this$adminPermissionsNeeded);
        if (object == null || (object = object.getPath()) == null) {
            object = $this$adminPermissionsNeeded.getHomePath();
        }
        if (object == null) {
            return false;
        }
        Object pathToCheck = object;
        return !Files.isWritable(Paths.get((String)pathToCheck, new String[0]));
    }

    @Nullable
    public static final Sdk setup(@NotNull PyDetectedSdk $this$setup, @NotNull List<? extends Sdk> existingSdks) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$setup), (String)"$this$setup");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        VirtualFile virtualFile = $this$setup.getHomeDirectory();
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"homeDirectory ?: return null");
        VirtualFile homeDir = virtualFile;
        Collection $this$toTypedArray$iv = existingSdks;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Sdk[] sdkArray = thisCollection$iv.toArray(new Sdk[0]);
        if (sdkArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return SdkConfigurationUtil.setupSdk((Sdk[])sdkArray, (VirtualFile)homeDir, (SdkType)PythonSdkType.getInstance(), (boolean)false, null, null);
    }

    @Nullable
    public static final Sdk setupAssociated(@NotNull PyDetectedSdk $this$setupAssociated, @NotNull List<? extends Sdk> existingSdks, @Nullable String associatedModulePath) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$setupAssociated), (String)"$this$setupAssociated");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        VirtualFile virtualFile = $this$setupAssociated.getHomeDirectory();
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"homeDirectory ?: return null");
        VirtualFile homeDir = virtualFile;
        String string2 = $this$setupAssociated.getHomePath();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            String string4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it");
            string = PySdkExtKt.suggestAssociatedSdkName(string4, associatedModulePath);
        } else {
            string = null;
        }
        String suggestedName = string;
        Collection $this$toTypedArray$iv = existingSdks;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Sdk[] sdkArray = thisCollection$iv.toArray(new Sdk[0]);
        if (sdkArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return SdkConfigurationUtil.setupSdk((Sdk[])sdkArray, (VirtualFile)homeDir, (SdkType)PythonSdkType.getInstance(), (boolean)false, null, (String)suggestedName);
    }

    @Nullable
    public static final Sdk getPythonSdk(@NotNull Module $this$pythonSdk) {
        Intrinsics.checkParameterIsNotNull((Object)$this$pythonSdk, (String)"$this$pythonSdk");
        return PythonSdkUtil.findPythonSdk($this$pythonSdk);
    }

    public static final void setPythonSdk(@NotNull Module $this$pythonSdk, @Nullable Sdk value) {
        Intrinsics.checkParameterIsNotNull((Object)$this$pythonSdk, (String)"$this$pythonSdk");
        ModuleRootModificationUtil.setModuleSdk((Module)$this$pythonSdk, (Sdk)value);
        PyUiUtil.clearFileLevelInspectionResults($this$pythonSdk.getProject());
        PySdkExtKt.fireActivePythonSdkChanged($this$pythonSdk, value);
    }

    public static final void fireActivePythonSdkChanged(@NotNull Module $this$fireActivePythonSdkChanged, @Nullable Sdk value) {
        Intrinsics.checkParameterIsNotNull((Object)$this$fireActivePythonSdkChanged, (String)"$this$fireActivePythonSdkChanged");
        Project project = $this$fireActivePythonSdkChanged.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        ((ActiveSdkListener)project.getMessageBus().syncPublisher(ACTIVE_PYTHON_SDK_TOPIC)).activeSdkChanged($this$fireActivePythonSdkChanged, value);
    }

    @Nullable
    public static final Sdk getPythonSdk(@NotNull Project $this$pythonSdk) {
        Sdk sdk;
        Intrinsics.checkParameterIsNotNull((Object)$this$pythonSdk, (String)"$this$pythonSdk");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)$this$pythonSdk);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(this)");
        Sdk sdk2 = sdk = projectRootManager.getProjectSdk();
        SdkTypeId sdkTypeId = sdk2 != null ? sdk2.getSdkType() : null;
        return sdkTypeId instanceof PythonSdkType ? sdk : null;
    }

    public static final void setPythonSdk(@NotNull Project $this$pythonSdk, @Nullable Sdk value) {
        Intrinsics.checkParameterIsNotNull((Object)$this$pythonSdk, (String)"$this$pythonSdk");
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(new Runnable($this$pythonSdk, application, value){
            final /* synthetic */ Project $this_pythonSdk;
            final /* synthetic */ Application $application;
            final /* synthetic */ Sdk $value;

            public final void run() {
                this.$application.runWriteAction(new Runnable(this){
                    final /* synthetic */ pythonSdk.1 this$0;

                    public final void run() {
                        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.this$0.$this_pythonSdk);
                        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(this)");
                        projectRootManager.setProjectSdk(this.this$0.$value);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$this_pythonSdk = project;
                this.$application = application;
                this.$value = sdk;
            }
        });
    }

    public static final void excludeInnerVirtualEnv(@NotNull Module $this$excludeInnerVirtualEnv, @NotNull Sdk sdk) {
        ContentEntry contentEntry;
        ModifiableRootModel model;
        Object root;
        block5: {
            Object object;
            block7: {
                block6: {
                    Intrinsics.checkParameterIsNotNull((Object)$this$excludeInnerVirtualEnv, (String)"$this$excludeInnerVirtualEnv");
                    Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
                    object = sdk.getHomePath();
                    if (object == null) break block6;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    object = PythonSdkUtil.getVirtualEnvRoot((String)it);
                    if (object == null) break block6;
                    object2 = object;
                    bl = false;
                    bl2 = false;
                    it = object2;
                    boolean bl4 = false;
                    object = LocalFileSystem.getInstance().findFileByIoFile((File)it);
                    if (object != null) break block7;
                }
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"sdk.homePath?.let { Pyth\u2026eByIoFile(it) } ?: return");
            root = object;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)$this$excludeInnerVirtualEnv);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(this)");
            ModifiableRootModel modifiableRootModel = moduleRootManager.getModifiableModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)modifiableRootModel, (String)"ModuleRootManager.getIns\u2026nce(this).modifiableModel");
            model = modifiableRootModel;
            ContentEntry[] contentEntryArray = model.getContentEntries();
            Intrinsics.checkExpressionValueIsNotNull((Object)contentEntryArray, (String)"model.contentEntries");
            ContentEntry[] $this$firstOrNull$iv = contentEntryArray;
            boolean $i$f$firstOrNull = false;
            ContentEntry[] contentEntryArray2 = $this$firstOrNull$iv;
            int n = contentEntryArray2.length;
            for (int i = 0; i < n; ++i) {
                ContentEntry element$iv;
                ContentEntry it = element$iv = contentEntryArray2[i];
                boolean bl = false;
                ContentEntry contentEntry2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)contentEntry2, (String)"it");
                VirtualFile contentFile = contentEntry2.getFile();
                boolean bl5 = contentFile != null && VfsUtil.isAncestor((VirtualFile)contentFile, (VirtualFile)root, (boolean)true);
                if (!bl5) continue;
                contentEntry = element$iv;
                break block5;
            }
            contentEntry = null;
        }
        if (contentEntry == null) {
            return;
        }
        ContentEntry contentEntry3 = contentEntry;
        contentEntry3.addExcludeFolder((VirtualFile)root);
        WriteAction.run((ThrowableRunnable)new ThrowableRunnable<E>(model){
            final /* synthetic */ ModifiableRootModel $model;

            public final void run() {
                this.$model.commit();
            }
            {
                this.$model = modifiableRootModel;
            }
        });
    }

    private static final String suggestAssociatedSdkName(String sdkHome, String associatedPath) {
        String string;
        String baseSdkName;
        block5: {
            block8: {
                block7: {
                    block6: {
                        String condaRoot;
                        block4: {
                            String string2 = PythonSdkType.suggestBaseSdkName(sdkHome);
                            if (string2 == null) {
                                return null;
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PythonSdkType.suggestBas\u2026e(sdkHome) ?: return null");
                            baseSdkName = string2;
                            File file = PythonSdkUtil.getVirtualEnvRoot(sdkHome);
                            String venvRoot = file != null ? file.getPath() : null;
                            File file2 = CondaEnvSdkFlavor.getCondaEnvRoot(sdkHome);
                            condaRoot = file2 != null ? file2.getPath() : null;
                            if (venvRoot == null || associatedPath != null && FileUtil.isAncestor((String)associatedPath, (String)venvRoot, (boolean)true)) break block4;
                            string = PathUtil.getFileName((String)venvRoot);
                            break block5;
                        }
                        if (condaRoot == null || associatedPath != null && FileUtil.isAncestor((String)associatedPath, (String)condaRoot, (boolean)true)) break block6;
                        string = PathUtil.getFileName((String)condaRoot);
                        break block5;
                    }
                    if (!PythonSdkUtil.isBaseConda(sdkHome)) break block7;
                    string = "base";
                    break block5;
                }
                string = associatedPath;
                if (string == null) break block8;
                String string3 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                string = PathUtil.getFileName((String)associatedPath);
                if (string != null) break block5;
            }
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"when {\n    venvRoot != n\u2026ath) } ?: return null\n  }");
        String associatedName = string;
        return baseSdkName + " (" + associatedName + ')';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNotEmptyDirectory(@NotNull File $this$isNotEmptyDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNotEmptyDirectory, (String)"$this$isNotEmptyDirectory");
        if (!$this$isNotEmptyDirectory.exists()) return false;
        if (!$this$isNotEmptyDirectory.isDirectory()) return false;
        String[] stringArray = $this$isNotEmptyDirectory.list();
        if (stringArray == null) return false;
        String[] stringArray2 = stringArray;
        boolean bl = false;
        if (stringArray2.length != 0) return true;
        return false;
    }

    private static final boolean isSystemWide(@NotNull Sdk $this$isSystemWide) {
        return !PythonSdkUtil.isRemote($this$isSystemWide) && !PythonSdkUtil.isVirtualEnv($this$isSystemWide) && !PythonSdkUtil.isCondaVirtualEnv($this$isSystemWide);
    }

    private static /* synthetic */ void associatedPathFromDotProject$annotations(Sdk sdk) {
    }

    private static final String getAssociatedPathFromDotProject(@NotNull Sdk $this$associatedPathFromDotProject) {
        String string;
        String string2 = $this$associatedPathFromDotProject.getHomePath();
        if (string2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"homePath ?: return null");
        String binaryPath = string2;
        File file = PythonSdkUtil.getVirtualEnvRoot(binaryPath);
        if (file == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"PythonSdkUtil.getVirtual\u2026inaryPath) ?: return null");
        File virtualEnvRoot = file;
        File projectFile = new File(virtualEnvRoot, ".project");
        try {
            string = FilesKt.readText$default((File)projectFile, null, (int)1, null);
            boolean bl = false;
            String string3 = string;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        }
        catch (IOException e) {
            string = null;
        }
        return string;
    }

    private static final String getAssociatedPathFromAdditionalData(@NotNull Sdk $this$associatedPathFromAdditionalData) {
        SdkAdditionalData sdkAdditionalData = $this$associatedPathFromAdditionalData.getSdkAdditionalData();
        if (!(sdkAdditionalData instanceof PythonSdkAdditionalData)) {
            sdkAdditionalData = null;
        }
        PythonSdkAdditionalData pythonSdkAdditionalData = (PythonSdkAdditionalData)sdkAdditionalData;
        return pythonSdkAdditionalData != null ? pythonSdkAdditionalData.getAssociatedModulePath() : null;
    }

    private static final VirtualFile getSitePackagesDirectory(@NotNull Sdk $this$sitePackagesDirectory) {
        return PythonSdkUtil.getSitePackagesDirectory($this$sitePackagesDirectory);
    }

    private static final boolean isLocatedInsideModule(@NotNull Sdk $this$isLocatedInsideModule, Module module) {
        String string = $this$isLocatedInsideModule.getHomePath();
        if (string == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"homePath ?: return false");
        String homePath = string;
        Object object = module;
        if (object == null || (object = BasePySdkExtKt.getBasePath(object)) == null) {
            return false;
        }
        Object basePath = object;
        return FileUtil.isAncestor((String)basePath, (String)homePath, (boolean)true);
    }

    @Nullable
    public static final LanguageLevel getGuessedLanguageLevel(@NotNull PyDetectedSdk $this$guessedLanguageLevel) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$guessedLanguageLevel), (String)"$this$guessedLanguageLevel");
        String string = $this$guessedLanguageLevel.getHomePath();
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"homePath ?: return null");
        String path = string;
        MatchResult matchResult = Regex.find$default((Regex)new Regex(".*python(\\d\\.\\d)"), (CharSequence)path, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult result = matchResult;
        String string2 = (String)CollectionsKt.getOrNull((List)result.getGroupValues(), (int)1);
        if (string2 == null) {
            return null;
        }
        String versionString = string2;
        return LanguageLevel.fromPythonVersion(versionString);
    }

    private static final boolean containsModuleName(@NotNull Sdk $this$containsModuleName, Module module) {
        String string = $this$containsModuleName.getHomePath();
        if (string == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"homePath ?: return false");
        String path = string;
        Object object = module;
        if (object == null || (object = object.getName()) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"module?.name ?: return false");
        Object name = object;
        return StringsKt.contains((CharSequence)path, (CharSequence)((CharSequence)name), (boolean)true);
    }

    @NotNull
    public static final PythonSdkAdditionalData getOrCreateAdditionalData(@NotNull Sdk $this$getOrCreateAdditionalData) {
        PythonSdkAdditionalData existingData;
        Intrinsics.checkParameterIsNotNull((Object)$this$getOrCreateAdditionalData, (String)"$this$getOrCreateAdditionalData");
        SdkAdditionalData sdkAdditionalData = $this$getOrCreateAdditionalData.getSdkAdditionalData();
        if (!(sdkAdditionalData instanceof PythonSdkAdditionalData)) {
            sdkAdditionalData = null;
        }
        if ((existingData = (PythonSdkAdditionalData)sdkAdditionalData) != null) {
            return existingData;
        }
        PythonSdkAdditionalData newData = new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor($this$getOrCreateAdditionalData.getHomePath()));
        SdkModificator sdkModificator = $this$getOrCreateAdditionalData.getSdkModificator();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkModificator, (String)"sdkModificator");
        SdkModificator modificator = sdkModificator;
        modificator.setSdkAdditionalData((SdkAdditionalData)newData);
        ApplicationManager.getApplication().runWriteAction(new Runnable(modificator){
            final /* synthetic */ SdkModificator $modificator;

            public final void run() {
                this.$modificator.commitChanges();
            }
            {
                this.$modificator = sdkModificator;
            }
        });
        return newData;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PyDetectedSdk> filterSuggestedPaths(Collection<String> suggestedPaths, List<? extends Sdk> existingSdks, Module module) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = existingSdks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Sdk sdk = (Sdk)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getHomePath();
            collection.add(string);
        }
        Set existingPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)suggestedPaths), (Function1)((Function1)new Function1<String, Boolean>(existingPaths){
            final /* synthetic */ Set $existingPaths;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$existingPaths.contains(it);
            }
            {
                this.$existingPaths = set;
                super(1);
            }
        }))), (Function1)filterSuggestedPaths.2.INSTANCE), (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{(Function1)new Function1<PyDetectedSdk, Boolean>(module){
            final /* synthetic */ Module $module;

            public final boolean invoke(@NotNull PyDetectedSdk it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return !PySdkExtKt.isAssociatedWithModule((Sdk)it, this.$module);
            }
            {
                this.$module = module;
                super(1);
            }
        }, filterSuggestedPaths.4.INSTANCE})));
    }

    @NotNull
    public static final Topic<ActiveSdkListener> getACTIVE_PYTHON_SDK_TOPIC() {
        return ACTIVE_PYTHON_SDK_TOPIC;
    }

    static {
        Key key = Key.create((String)"PYTHON_BASE_PATH");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"PYTHON_BASE_PATH\")");
        BASE_DIR = key;
        ACTIVE_PYTHON_SDK_TOPIC = new Topic("Active SDK changed", ActiveSdkListener.class);
    }
}

