(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/sasl#scram-context::t
    (make-struct-type
     'std/net/sasl#scram-context::t
     '#f
     '12
     'scram-context
     '((final: . #t))
     ':init!
     '(h hmac user pass nonce cfm sfm r s i p v)))
  (define std/net/sasl#scram-context?
    (make-struct-predicate std/net/sasl#scram-context::t))
  (define std/net/sasl#make-scram-context
    (lambda _$args156373_
      (apply make-struct-instance
             std/net/sasl#scram-context::t
             _$args156373_)))
  (define std/net/sasl#scram-context-h
    (make-struct-field-accessor std/net/sasl#scram-context::t '0))
  (define std/net/sasl#scram-context-hmac
    (make-struct-field-accessor std/net/sasl#scram-context::t '1))
  (define std/net/sasl#scram-context-user
    (make-struct-field-accessor std/net/sasl#scram-context::t '2))
  (define std/net/sasl#scram-context-pass
    (make-struct-field-accessor std/net/sasl#scram-context::t '3))
  (define std/net/sasl#scram-context-nonce
    (make-struct-field-accessor std/net/sasl#scram-context::t '4))
  (define std/net/sasl#scram-context-cfm
    (make-struct-field-accessor std/net/sasl#scram-context::t '5))
  (define std/net/sasl#scram-context-sfm
    (make-struct-field-accessor std/net/sasl#scram-context::t '6))
  (define std/net/sasl#scram-context-r
    (make-struct-field-accessor std/net/sasl#scram-context::t '7))
  (define std/net/sasl#scram-context-s
    (make-struct-field-accessor std/net/sasl#scram-context::t '8))
  (define std/net/sasl#scram-context-i
    (make-struct-field-accessor std/net/sasl#scram-context::t '9))
  (define std/net/sasl#scram-context-p
    (make-struct-field-accessor std/net/sasl#scram-context::t '10))
  (define std/net/sasl#scram-context-v
    (make-struct-field-accessor std/net/sasl#scram-context::t '11))
  (define std/net/sasl#scram-context-h-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '0))
  (define std/net/sasl#scram-context-hmac-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '1))
  (define std/net/sasl#scram-context-user-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '2))
  (define std/net/sasl#scram-context-pass-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '3))
  (define std/net/sasl#scram-context-nonce-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '4))
  (define std/net/sasl#scram-context-cfm-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '5))
  (define std/net/sasl#scram-context-sfm-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '6))
  (define std/net/sasl#scram-context-r-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '7))
  (define std/net/sasl#scram-context-s-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '8))
  (define std/net/sasl#scram-context-i-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '9))
  (define std/net/sasl#scram-context-p-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '10))
  (define std/net/sasl#scram-context-v-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '11))
  (define std/net/sasl#scram-context:::init!
    (lambda (_self156367_ _h156368_ _hmac156369_ _user156370_ _pass156371_)
      (if (##fx< '4 (##vector-length _self156367_))
          (begin
            (##vector-set! _self156367_ '1 _h156368_)
            (##vector-set! _self156367_ '2 _hmac156369_)
            (##vector-set! _self156367_ '3 _user156370_)
            (##vector-set! _self156367_ '4 _pass156371_))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self156367_))))
  (bind-method!
   std/net/sasl#scram-context::t
   ':init!
   std/net/sasl#scram-context:::init!
   '#f)
  (define std/net/sasl#scram-sha-1-begin
    (lambda (_user156241_ _pass156242_)
      (let ((__obj156375 (make-object std/net/sasl#scram-context::t '12)))
        (if (##fx< '4 (##vector-length __obj156375))
            (begin
              (##vector-set! __obj156375 '1 std/crypto/digest#sha1)
              (##vector-set! __obj156375 '2 std/crypto/hmac#hmac-sha1)
              (##vector-set! __obj156375 '3 _user156241_)
              (##vector-set! __obj156375 '4 _pass156242_))
            (error '"struct-instance-init!: too many arguments for struct"
                   __obj156375))
        __obj156375)))
  (define std/net/sasl#scram-sha-256-begin
    (lambda (_user156238_ _pass156239_)
      (let ((__obj156376 (make-object std/net/sasl#scram-context::t '12)))
        (if (##fx< '4 (##vector-length __obj156376))
            (begin
              (##vector-set! __obj156376 '1 std/crypto/digest#sha256)
              (##vector-set! __obj156376 '2 std/crypto/hmac#hmac-sha256)
              (##vector-set! __obj156376 '3 _user156238_)
              (##vector-set! __obj156376 '4 _pass156239_))
            (error '"struct-instance-init!: too many arguments for struct"
                   __obj156376))
        __obj156376)))
  (define std/net/sasl#scram-client-first-message__%
    (lambda (_ctx156213_ _nonce156214_)
      (letrec ((_first-message156216_
                (lambda (_cfm156226_) (string-append '"n,," _cfm156226_))))
        (let* ((_nonce156221_
                (let ((_$e156218_ _nonce156214_))
                  (if _$e156218_
                      _$e156218_
                      (std/text/base64#u8vector->base64-string
                       (std/crypto/etc#random-bytes '16)))))
               (_cfm156223_
                (string-append
                 '"n="
                 (##direct-structure-ref
                  _ctx156213_
                  '3
                  std/net/sasl#scram-context::t
                  '#f)
                 '",r="
                 _nonce156221_)))
          (##direct-structure-set!
           _ctx156213_
           _cfm156223_
           '6
           std/net/sasl#scram-context::t
           '#f)
          (##direct-structure-set!
           _ctx156213_
           _nonce156221_
           '5
           std/net/sasl#scram-context::t
           '#f)
          (_first-message156216_ _cfm156223_)))))
  (define std/net/sasl#scram-client-first-message__0
    (lambda (_ctx156231_)
      (let ((_nonce156233_ '#f))
        (std/net/sasl#scram-client-first-message__%
         _ctx156231_
         _nonce156233_))))
  (define std/net/sasl#scram-client-first-message
    (lambda _g156378_
      (let ((_g156377_ (length _g156378_)))
        (cond ((##fx= _g156377_ 1)
               (apply std/net/sasl#scram-client-first-message__0 _g156378_))
              ((##fx= _g156377_ 2)
               (apply std/net/sasl#scram-client-first-message__% _g156378_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/sasl#scram-client-first-message
                _g156378_))))))
  (define std/net/sasl#scram-client-first-server-message!
    (lambda (_ctx156189_ _sfm156190_)
      (let* ((_msg156192_ (std/net/sasl#scram-parse-message _sfm156190_))
             (_r156197_
              (let ((_$e156194_ (assget '"r" _msg156192_)))
                (if _$e156194_
                    _$e156194_
                    (std/net/sasl#fail
                     '"Invalid server message; missing nonce"
                     _msg156192_))))
             (_s156202_
              (std/text/base64#base64-string->u8vector
               (let ((_$e156199_ (assget '"s" _msg156192_)))
                 (if _$e156199_
                     _$e156199_
                     (std/net/sasl#fail
                      '"Invalid server message; missing salt"
                      _msg156192_)))))
             (_i156207_
              (string->number
               (let ((_$e156204_ (assget '"i" _msg156192_)))
                 (if _$e156204_
                     _$e156204_
                     (std/net/sasl#fail
                      '"Invalid server message; missing iteration count"
                      _msg156192_)))))
             (_nonce156209_
              (##direct-structure-ref
               _ctx156189_
               '5
               std/net/sasl#scram-context::t
               '#f)))
        (if (and (fx> (string-length _r156197_) (string-length _nonce156209_))
                 (string-prefix? _nonce156209_ _r156197_))
            '#!void
            (std/net/sasl#fail
             '"Invalid server nonce"
             _r156197_
             _nonce156209_))
        (##direct-structure-set!
         _ctx156189_
         _sfm156190_
         '7
         std/net/sasl#scram-context::t
         '#f)
        (##direct-structure-set!
         _ctx156189_
         _r156197_
         '8
         std/net/sasl#scram-context::t
         '#f)
        (##direct-structure-set!
         _ctx156189_
         _s156202_
         '9
         std/net/sasl#scram-context::t
         '#f)
        (##direct-structure-set!
         _ctx156189_
         _i156207_
         '10
         std/net/sasl#scram-context::t
         '#f)
        '#!void)))
  (define std/net/sasl#scram-client-final-message
    (lambda (_ctx156077_)
      (letrec ((_final-message156079_
                (lambda (_csm156186_ _p156187_)
                  (string-append _csm156186_ '",p=" _p156187_))))
        (let* ((_ctx156080156095_ _ctx156077_)
               (_E156082156099_
                (lambda () (error '"No clause matching" _ctx156080156095_)))
               (_K156083156135_
                (lambda (_i156102_
                         _s156103_
                         _r156104_
                         _sfm156105_
                         _cfm156106_
                         _passwd156107_
                         _user156108_
                         _hmac156109_
                         _h156110_)
                  (let* ((_csm156112_ (string-append '"c=biws,r=" _r156104_))
                         (_salted-passwd156114_
                          (std/net/sasl#scram-Hi
                           _hmac156109_
                           _passwd156107_
                           _s156103_
                           _i156102_))
                         (_client-key156116_
                          (_hmac156109_
                           _salted-passwd156114_
                           (std/text/utf8#string->utf8__0 '"Client Key")))
                         (_stored-key156118_ (_h156110_ _client-key156116_))
                         (_auth-message156120_
                          (std/text/utf8#string->utf8__0
                           (string-append
                            _cfm156106_
                            '","
                            _sfm156105_
                            '","
                            _csm156112_)))
                         (_client-sign156122_
                          (_hmac156109_
                           _stored-key156118_
                           _auth-message156120_))
                         (_client-proof156124_
                          (std/net/sasl#bytes-xor
                           _client-key156116_
                           _client-sign156122_))
                         (_p156126_
                          (std/text/base64#u8vector->base64-string
                           _client-proof156124_))
                         (_server-key156128_
                          (_hmac156109_
                           _salted-passwd156114_
                           (std/text/utf8#string->utf8__0 '"Server Key")))
                         (_server-sign156130_
                          (_hmac156109_
                           _server-key156128_
                           _auth-message156120_))
                         (_v156132_
                          (std/text/base64#u8vector->base64-string
                           _server-sign156130_)))
                    (##direct-structure-set!
                     _ctx156077_
                     _p156126_
                     '11
                     std/net/sasl#scram-context::t
                     '#f)
                    (##direct-structure-set!
                     _ctx156077_
                     _v156132_
                     '12
                     std/net/sasl#scram-context::t
                     '#f)
                    (_final-message156079_ _csm156112_ _p156126_)))))
          (if (##structure-direct-instance-of?
               _ctx156080156095_
               'std/net/sasl#scram-context::t)
              (let* ((_e156084156138_ (##vector-ref _ctx156080156095_ '1))
                     (_h156141_ _e156084156138_)
                     (_e156085156143_ (##vector-ref _ctx156080156095_ '2))
                     (_hmac156146_ _e156085156143_)
                     (_e156086156148_ (##vector-ref _ctx156080156095_ '3))
                     (_user156151_ _e156086156148_)
                     (_e156087156153_ (##vector-ref _ctx156080156095_ '4))
                     (_passwd156156_ _e156087156153_)
                     (_e156088156158_ (##vector-ref _ctx156080156095_ '5))
                     (_e156089156161_ (##vector-ref _ctx156080156095_ '6))
                     (_cfm156164_ _e156089156161_)
                     (_e156090156166_ (##vector-ref _ctx156080156095_ '7))
                     (_sfm156169_ _e156090156166_)
                     (_e156091156171_ (##vector-ref _ctx156080156095_ '8))
                     (_r156174_ _e156091156171_)
                     (_e156092156176_ (##vector-ref _ctx156080156095_ '9))
                     (_s156179_ _e156092156176_)
                     (_e156093156181_ (##vector-ref _ctx156080156095_ '10))
                     (_i156184_ _e156093156181_))
                (_K156083156135_
                 _i156184_
                 _s156179_
                 _r156174_
                 _sfm156169_
                 _cfm156164_
                 _passwd156156_
                 _user156151_
                 _hmac156146_
                 _h156141_))
              (_E156082156099_))))))
  (define std/net/sasl#scram-client-final-server-message!
    (lambda (_ctx156059_ _smsg156060_)
      (let ((_msg156062_ (std/net/sasl#scram-parse-message _smsg156060_)))
        (let ((_$e156065_ (assget '"e" _msg156062_)))
          (if _$e156065_
              ((lambda (_what156068_)
                 (std/net/sasl#fail '"Authentication failed" _what156068_))
               _$e156065_)
              (let ((_$e156070_ (assget '"v" _msg156062_)))
                (if _$e156070_
                    ((lambda (_v156073_)
                       (let ((_verifier156075_
                              (##direct-structure-ref
                               _ctx156059_
                               '12
                               std/net/sasl#scram-context::t
                               '#f)))
                         (if (equal? _v156073_ _verifier156075_)
                             '#!void
                             (std/net/sasl#fail
                              '"Authentication failed; invalid server signature"
                              _v156073_
                              _verifier156075_))))
                     _$e156070_)
                    (std/net/sasl#fail
                     '"Malformed server message; missing verifier or error"
                     _msg156062_))))))))
  (define std/net/sasl#scram-Hi
    (lambda (_hmac156038_ _passwd156039_ _salt156040_ _count156041_)
      (let* ((_key156043_ (std/text/utf8#string->utf8__0 _passwd156039_))
             (_u1156045_
              (_hmac156038_
               _key156043_
               (u8vector-append _salt156040_ '#u8(0 0 0 1)))))
        (let _lp156048_ ((_i156050_ '1)
                         (_ui156051_ _u1156045_)
                         (_hi156052_ _u1156045_))
          (if (fx< _i156050_ _count156041_)
              (let* ((_ui+1156054_ (_hmac156038_ _key156043_ _ui156051_))
                     (_hi+1156056_
                      (std/net/sasl#bytes-xor _ui+1156054_ _hi156052_)))
                (_lp156048_ (fx+ _i156050_ '1) _ui+1156054_ _hi+1156056_))
              _hi156052_)))))
  (define std/net/sasl#bytes-xor
    (lambda (_a156026_ _b156027_)
      (let ((_len156029_ (u8vector-length _a156026_))
            (_len-b156030_ (u8vector-length _b156027_)))
        (if (fx= _len156029_ _len-b156030_)
            (let ((_res156032_ (make-u8vector _len156029_)))
              (let _lp156034_ ((_i156036_ '0))
                (if (fx< _i156036_ _len156029_)
                    (begin
                      (##u8vector-set!
                       _res156032_
                       _i156036_
                       (##fxxor (##u8vector-ref _a156026_ _i156036_)
                                (##u8vector-ref _b156027_ _i156036_)))
                      (_lp156034_ (fx+ _i156036_ '1)))
                    _res156032_)))
            (error '"Cannot xor bytes; length mismatch"
                   _a156026_
                   _b156027_)))))
  (define std/net/sasl#scram-parse-message
    (lambda (_msg156010_)
      (with-exception-catcher
       (lambda (_g156011156013_)
         (if '#t
             (let ((_e156016_ _g156011156013_))
               (std/net/sasl#fail '"Malformed message" _msg156010_ _e156016_))
             (raise _g156011156013_)))
       (lambda ()
         (map (lambda (_str156019_)
                (let ((_$e156021_ (string-index _str156019_ '#\=)))
                  (if _$e156021_
                      ((lambda (_ix156024_)
                         (cons (substring _str156019_ '0 _ix156024_)
                               (substring
                                _str156019_
                                (fx+ _ix156024_ '1)
                                (string-length _str156019_))))
                       _$e156021_)
                      (cons '"str" '#f))))
              (string-split _msg156010_ '#\,))))))
  (define std/net/sasl#fail
    (lambda (_what156007_ . _irritants156008_)
      (apply std/error#raise-io-error
             'sasl-authenticate
             _what156007_
             _irritants156008_))))
