(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/78#check:write write)
  (define std/srfi/78#check:mode '#f)
  (define std/srfi/78#check-set-mode!
    (lambda (_mode82870_)
      (set! std/srfi/78#check:mode
            (let ((_$e82872_ _mode82870_))
              (if (eq? 'off _$e82872_)
                  '0
                  (if (eq? 'summary _$e82872_)
                      '1
                      (if (eq? 'report-failed _$e82872_)
                          '10
                          (if (eq? 'report _$e82872_)
                              '100
                              (error '"unrecognized mode" _mode82870_)))))))))
  (std/srfi/78#check-set-mode! 'report)
  (define std/srfi/78#check:correct '#f)
  (define std/srfi/78#check:failed '#f)
  (define std/srfi/78#check-reset!
    (lambda ()
      (set! std/srfi/78#check:correct '0)
      (set! std/srfi/78#check:failed '())))
  (define std/srfi/78#check:add-correct!
    (lambda ()
      (set! std/srfi/78#check:correct (+ std/srfi/78#check:correct '1))))
  (define std/srfi/78#check:add-failed!
    (lambda (_expression82864_ _actual-result82865_ _expected-result82866_)
      (set! std/srfi/78#check:failed
            (cons (list _expression82864_
                        _actual-result82865_
                        _expected-result82866_)
                  std/srfi/78#check:failed))))
  (std/srfi/78#check-reset!)
  (define std/srfi/78#check:report-expression
    (lambda (_expression82862_)
      (newline)
      (std/srfi/78#check:write _expression82862_)
      (display '" => ")))
  (define std/srfi/78#check:report-actual-result
    (lambda (_actual-result82860_)
      (std/srfi/78#check:write _actual-result82860_)
      (display '" ; ")))
  (define std/srfi/78#check:report-correct
    (lambda (_cases82858_)
      (display '"correct")
      (if (not (= _cases82858_ '1))
          (begin
            (display '" (")
            (display _cases82858_)
            (display '" cases checked)"))
          '#!void)
      (newline)))
  (define std/srfi/78#check:report-failed
    (lambda (_expected-result82856_)
      (display '"*** failed ***")
      (newline)
      (display '" ; expected result: ")
      (std/srfi/78#check:write _expected-result82856_)
      (newline)))
  (define std/srfi/78#check-report
    (lambda ()
      (if (>= std/srfi/78#check:mode '1)
          (begin
            (newline)
            (display '"; *** checks *** : ")
            (display std/srfi/78#check:correct)
            (display '" correct, ")
            (display (length std/srfi/78#check:failed))
            (display '" failed.")
            (if (or (null? std/srfi/78#check:failed)
                    (<= std/srfi/78#check:mode '1))
                (newline)
                (let* ((_w82847_ (car (reverse std/srfi/78#check:failed)))
                       (_expression82849_ (car _w82847_))
                       (_actual-result82851_ (cadr _w82847_))
                       (_expected-result82853_ (caddr _w82847_)))
                  (display '" First failed example:")
                  (newline)
                  (std/srfi/78#check:report-expression _expression82849_)
                  (std/srfi/78#check:report-actual-result _actual-result82851_)
                  (std/srfi/78#check:report-failed _expected-result82853_))))
          '#!void)))
  (define std/srfi/78#check-passed?
    (lambda (_expected-total-count82841_)
      (if (= (length std/srfi/78#check:failed) '0)
          (= std/srfi/78#check:correct _expected-total-count82841_)
          '#f)))
  (define std/srfi/78#check:proc
    (lambda (_expression82827_
             _thunk82828_
             _equal82829_
             _expected-result82830_)
      (let ((_$e82832_ std/srfi/78#check:mode))
        (if (eq? '0 _$e82832_)
            '#f
            (if (eq? '1 _$e82832_)
                (let ((_actual-result82835_ (_thunk82828_)))
                  (if (_equal82829_
                       _actual-result82835_
                       _expected-result82830_)
                      (std/srfi/78#check:add-correct!)
                      (std/srfi/78#check:add-failed!
                       _expression82827_
                       _actual-result82835_
                       _expected-result82830_)))
                (if (eq? '10 _$e82832_)
                    (let ((_actual-result82837_ (_thunk82828_)))
                      (if (_equal82829_
                           _actual-result82837_
                           _expected-result82830_)
                          (std/srfi/78#check:add-correct!)
                          (begin
                            (std/srfi/78#check:report-expression
                             _expression82827_)
                            (std/srfi/78#check:report-actual-result
                             _actual-result82837_)
                            (std/srfi/78#check:report-failed
                             _expected-result82830_)
                            (std/srfi/78#check:add-failed!
                             _expression82827_
                             _actual-result82837_
                             _expected-result82830_))))
                    (if (eq? '100 _$e82832_)
                        (begin
                          (std/srfi/78#check:report-expression
                           _expression82827_)
                          (let ((_actual-result82839_ (_thunk82828_)))
                            (std/srfi/78#check:report-actual-result
                             _actual-result82839_)
                            (if (_equal82829_
                                 _actual-result82839_
                                 _expected-result82830_)
                                (begin
                                  (std/srfi/78#check:report-correct '1)
                                  (std/srfi/78#check:add-correct!))
                                (begin
                                  (std/srfi/78#check:report-failed
                                   _expected-result82830_)
                                  (std/srfi/78#check:add-failed!
                                   _expression82827_
                                   _actual-result82839_
                                   _expected-result82830_)))))
                        (error '"unrecognized check:mode"
                               std/srfi/78#check:mode))))))
      (if '#f '#f '#!void)))
  (define std/srfi/78#check:proc-ec
    (lambda (_w82819_)
      (let ((_correct?82821_ (car _w82819_))
            (_expression82822_ (cadr _w82819_))
            (_actual-result82823_ (caddr _w82819_))
            (_expected-result82824_ (cadddr _w82819_))
            (_cases82825_ (car (cddddr _w82819_))))
        (if _correct?82821_
            (begin
              (if (>= std/srfi/78#check:mode '100)
                  (begin
                    (std/srfi/78#check:report-expression _expression82822_)
                    (std/srfi/78#check:report-actual-result
                     _actual-result82823_)
                    (std/srfi/78#check:report-correct _cases82825_))
                  '#!void)
              (std/srfi/78#check:add-correct!))
            (begin
              (if (>= std/srfi/78#check:mode '10)
                  (begin
                    (std/srfi/78#check:report-expression _expression82822_)
                    (std/srfi/78#check:report-actual-result
                     _actual-result82823_)
                    (std/srfi/78#check:report-failed _expected-result82824_))
                  '#!void)
              (std/srfi/78#check:add-failed!
               _expression82822_
               _actual-result82823_
               _expected-result82824_)))))))
