'\"
'\" Generated from file 'tool\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2015 Sean Woods <yoda@etoyoc\&.com>
'\"
.TH "tool" n 0\&.4\&.2 tcllib "Standardized OO Framework for development"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
tool \- TclOO Library (TOOL) Framework
.SH SYNOPSIS
package require \fBTcl  8\&.6\fR
.sp
package require \fBsha1 \fR
.sp
package require \fBdicttool \fR
.sp
package require \fBoo::meta \fR
.sp
package require \fBoo::dialect \fR
.sp
tool::define \fBclass_method\fR \fIarglist\fR \fIbody\fR
.sp
tool::define \fBarray\fR \fIname\fR \fIcontents\fR
.sp
tool::define \fBarray_ensemble\fR \fImethodname\fR \fIvarname\fR ?cases?
.sp
tool::define \fBdict_ensemble\fR \fImethodname\fR \fIvarname\fR ?cases?
.sp
tool::define \fBmethod\fR \fImethodname\fR \fIarglist\fR \fIbody\fR
.sp
tool::define \fBoption\fR \fIname\fR \fIdictopts\fR
.sp
tool::define \fBproperty\fR ?branch? \fIfield\fR \fIvalue\fR
.sp
tool::define \fBvariable\fR \fIname\fR \fIvalue\fR
.sp
\fIobject\fR \fBcget\fR \fIoption\fR
.sp
\fIobject\fR \fBconfigure\fR ?keyvaluelist?
.sp
\fIobject\fR \fBconfigure\fR \fIfield\fR \fIvalue\fR ?field? ?value? ?\&.\&.\&.?
.sp
\fIobject\fR \fBconfigurelist\fR ?keyvaluelist?
.sp
\fIobject\fR \fBforward\fR \fIstub\fR \fIforward\fR
.sp
\fIobject\fR \fBgraft\fR \fIstub\fR \fIforward\fR
.sp
\fIobject\fR \fBInitializePublic\fR
.sp
\fIobject\fR \fBEval_Script\fR ?script?
.sp
\fIobject\fR \fBOption_Default\fR \fIfield\fR
.sp
.BE
.SH DESCRIPTION
.PP
This module implements the Tcl Object Oriented Library framework, or \fITOOL\fR\&. It is
intended to be a general purpose framework that is useable in its own right, and
easily extensible\&.
.PP
TOOL defines a metaclass with provides several additional keywords to the TclOO
description langauge, default behaviors for its consituent objects, and
top-down integration with the capabilities provided by the \fBoo::meta\fR package\&.
.PP
The TOOL metaclass was build with the \fBoo::dialect\fR package, and thus can
be used as the basis for additional metaclasses\&. As a metaclass, TOOL has it's own
"class" class, "object" class, and define namespace\&.
.CS


package require tool

# tool::class workds just like oo::class
tool::class create myclass {
}

# tool::define works just like oo::define
tool::define myclass method noop {} {}

# tool::define and tool::class understand additional keywords
tool::define myclass array_ensemble mysettings mysettings {}

# And tool interoperates with oo::define
oo::define myclass method do_something {} { return something }

# TOOL and TclOO objects are interchangeable
oo::class create myooclass {
  superclass myclass
}

.CE
.PP
Several manual pages go into more detail about specific keywords and methods\&.
.TP
\fBtool::array_ensemble\fR
.TP
\fBtool::dict_ensemble\fR
.TP
\fBtool::method_ensemble\fR
.TP
\fBtool::object\fR
.TP
\fBtool::option_handling\fR
.PP
.SH KEYWORDS
TOOL adds new (or modifies) keywords used in the definitions of classes\&. However,
the new keywords are only available via calls to \fItool::class create\fR or \fItool::define\fR
.TP
tool::define \fBclass_method\fR \fIarglist\fR \fIbody\fR
Defines a method for the class object itself\&. This method will be passed on to descendents of the class,
unlike \fBself method\fR\&.
.TP
tool::define \fBarray\fR \fIname\fR \fIcontents\fR
Declares a variable \fIname\fR which will be initialized as an array, populated with \fIcontents\fR for objects of this class, as well as any
objects for classes which are descendents of this class\&.
.TP
tool::define \fBarray_ensemble\fR \fImethodname\fR \fIvarname\fR ?cases?
Declares a method ensemble \fImethodname\fR which will control access to variable
\fIvarname\fR\&. Cases are a key/value list of method names and bodies which will be
overlaid on top of the standard template\&. See \fBtool::array_ensemble\fR\&.
.sp
One method name is reserved: \fBinitialize\fR\&. \fBinitialize\fR Declares the initial values to be populated in the array, as a key/value list,
and will not be expressed as a method for the ensemble\&.
.TP
tool::define \fBdict_ensemble\fR \fImethodname\fR \fIvarname\fR ?cases?
Declares a method ensemble \fImethodname\fR which will control access to variable
\fIvarname\fR\&. Cases are a key/value list of method names and bodies which will be
overlaid on top of the standard template\&. See \fBtool::dict_ensemble\fR\&.
.sp
One method name is reserved: \fBinitialize\fR\&. \fBinitialize\fR Declares the initial values to be populated in the array, as a key/value list,
and will not be expressed as a method for the ensemble\&.
.TP
tool::define \fBmethod\fR \fImethodname\fR \fIarglist\fR \fIbody\fR
If \fImethodname\fR contains ::, the method is considered to be
part of a method ensemble\&. See \fBtool::method_ensembles\fR\&. Otherwise
this command behaves exactly like the standard \fBoo::define\fR \fBmethod\fR
command\&.
.TP
tool::define \fBoption\fR \fIname\fR \fIdictopts\fR
Declares an option\&. \fIdictopts\fR is a key/value list defining parameters for the option\&. See \fBtool::option_handling\fR\&.
.CS


tool::class create myclass {
  option color {
    post-command: {puts [list %self%'s %field% is now %value%]}
    default: green
  }
}
myclass create foo
foo configure color purple
> foo's color is now purple

.CE
.TP
tool::define \fBproperty\fR ?branch? \fIfield\fR \fIvalue\fR
Defines a new leaf in the class metadata tree\&. With no branch, the
leaf will appear in the \fIconst\fR section, accessible by either the
object's \fBproperty\fR method, or via \fBoo::meta::info\fR \fIclass\fR \fBget const\fR \fIfield\fR:
.TP
tool::define \fBvariable\fR \fIname\fR \fIvalue\fR
Declares a variable \fIname\fR which will be initialized with the value \fIvalue\fR for objects of this class, as well as any
objects for classes which are descendents of this class\&.
.PP
.SH "PUBLIC OBJECT METHODS"
The TOOL object mother of all classes defines several methods to enforces consistent
behavior throughout the framework\&.
.TP
\fIobject\fR \fBcget\fR \fIoption\fR
Return the value of this object's option \fIoption\fR\&. If the \fBproperty options_strict\fR is true
for this class, calling an option which was not declared by the \fBoption\fR keyword will throw
an error\&. In all other cases if the value is present in the object's \fIoptions\fR array that
value is returned\&. If it does not exist, the object will attempt to retrieve a property of the same
name\&.
.TP
\fIobject\fR \fBconfigure\fR ?keyvaluelist?
.TP
\fIobject\fR \fBconfigure\fR \fIfield\fR \fIvalue\fR ?field? ?value? ?\&.\&.\&.?
This command will inject new values into the objects \fIoptions\fR array, according to the rules
as set forth by the option descriptions\&. See \fBtool::option_handling\fR for details\&.
\fBconfigure\fR will strip leading -'s off of field names, allowing it to behave in a quasi-backward
compatible manner to tk options\&.
.TP
\fIobject\fR \fBconfigurelist\fR ?keyvaluelist?
This command will inject new values into the objects \fIoptions\fR array, according to the rules
as set forth by the option descriptions\&. This command will perform validation and alternate storage
rules\&. It will not invoke trigger rules\&. See \fBtool::option_handling\fR for details\&.
.TP
\fIobject\fR \fBforward\fR \fIstub\fR \fIforward\fR
A passthrough to \fBoo:objdefine [self] forward\fR
.TP
\fIobject\fR \fBgraft\fR \fIstub\fR \fIforward\fR
Delegates the \fI<stub>\fR method to the object or command designated by \fIforward\fR
.CS


tool::object create A
tool::object create B
A graft buddy B
A configure color red
B configure color blue
A cget color
> red
A <buddy> cget color
> blue

.CE
.PP
.SH "PRIVATE OBJECT METHODS"
.TP
\fIobject\fR \fBInitializePublic\fR
Consults the metadata for the class to ensure every array, option, and variable
which has been declared but not initialized is initialized with the default value\&.
This method is called by the constructor and the morph method\&. It is safe to
invoke multiple times\&.
.TP
\fIobject\fR \fBEval_Script\fR ?script?
Executes a block of text within the namespace of the object\&. Lines that
begin with a # are ignored as comments\&. Commands
that begin with :: are interpreted as calling a global command\&. All other
Tcl commands that lack a "my" prefix are given one, to allow the script
to exercise internal methods\&. This method is intended for configuration scripts,
where the object's methods are intepreting a domain specific language\&.
.CS


tool::class myclass {
  constructor script {
    my Eval_Script $script
  }
  method node {nodename info} {
    my variable node
    dict set node $nodename $info
  }
  method get {args} {
    my variable node
    return [dict get $node $args]
  }
}
myclass create movies {
  # This block of code is executed by the object
  node {The Day the Earth Stood Still} {
    date: 1952
    characters: {GORT Klatoo}
  }
}
movies get {The Day the Earth Stood Still} date:
> 1952

.CE
.TP
\fIobject\fR \fBOption_Default\fR \fIfield\fR
Computes the default value for an option\&. See \fBtool::option_handling\fR\&.
.PP
.SH AUTHORS
Sean Woods
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fItcloo\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
TOOL, TclOO, framework
.SH CATEGORY
TclOO
.SH COPYRIGHT
.nf
Copyright (c) 2015 Sean Woods <yoda@etoyoc\&.com>

.fi