"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var specs_1 = require("../../../../specs");
var constants_1 = require("../../../../specs/constants");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var is_external_tooltip_visible_1 = require("../../../../state/selectors/is_external_tooltip_visible");
var get_projected_pointer_position_1 = require("./get_projected_pointer_position");
var get_tooltip_values_highlighted_geoms_1 = require("./get_tooltip_values_highlighted_geoms");
var is_annotation_tooltip_visible_1 = require("./is_annotation_tooltip_visible");
var getTooltipTypeSelector = function (state) { return specs_1.getTooltipType(get_settings_specs_1.getSettingsSpecSelector(state)); };
var getPointerSelector = function (state) { return state.interactions.pointer; };
exports.isTooltipVisibleSelector = re_reselect_1.default([
    getTooltipTypeSelector,
    getPointerSelector,
    get_projected_pointer_position_1.getProjectedPointerPositionSelector,
    get_tooltip_values_highlighted_geoms_1.getTooltipInfoSelector,
    is_annotation_tooltip_visible_1.isAnnotationTooltipVisibleSelector,
    is_external_tooltip_visible_1.isExternalTooltipVisibleSelector,
], isTooltipVisible)(get_chart_id_1.getChartIdSelector);
function isTooltipVisible(tooltipType, pointer, projectedPointerPosition, tooltip, isAnnotationTooltipVisible, externalTooltipVisible) {
    var isLocalTooltop = (tooltipType !== constants_1.TooltipType.None
        && pointer.down === null
        && projectedPointerPosition.x > -1
        && projectedPointerPosition.y > -1
        && tooltip.values.length > 0
        && !isAnnotationTooltipVisible);
    var isExternalTooltip = externalTooltipVisible && tooltip.values.length > 0;
    return {
        visible: isLocalTooltop || isExternalTooltip,
        isExternal: externalTooltipVisible,
    };
}
//# sourceMappingURL=is_tooltip_visible.js.map