function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment } from 'react';
import ReactDOM from 'react-dom';
import ReactMarkdown from 'react-markdown';
import { filter } from 'rxjs/operators';
import { FormattedMessage } from '@kbn/i18n/react';
import { EuiCallOut, EuiButton } from '@elastic/eui';

/**
 * Sets up the custom banner that can be specified in advanced settings.
 * @internal
 */
export var UserBannerService = /*#__PURE__*/function () {
  function UserBannerService() {
    _classCallCheck(this, UserBannerService);

    _defineProperty(this, "settingsSubscription", void 0);
  }

  _createClass(UserBannerService, [{
    key: "start",
    value: function start(_ref) {
      var banners = _ref.banners,
          i18n = _ref.i18n,
          uiSettings = _ref.uiSettings;
      var id;
      var timeout;

      var dismiss = function dismiss() {
        banners.remove(id);
        clearTimeout(timeout);
      };

      var updateBanner = function updateBanner() {
        var content = uiSettings.get('notifications:banner');
        var lifetime = uiSettings.get('notifications:lifetime:banner');

        if (typeof content !== 'string' || content.length === 0 || typeof lifetime !== 'number') {
          dismiss();
          return;
        }

        id = banners.replace(id, function (el) {
          ReactDOM.render( /*#__PURE__*/React.createElement(i18n.Context, null, /*#__PURE__*/React.createElement(EuiCallOut, {
            title: /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "core.ui.overlays.banner.attentionTitle",
              defaultMessage: "Attention"
            }),
            iconType: "help"
          }, /*#__PURE__*/React.createElement(ReactMarkdown, {
            renderers: {
              root: Fragment
            }
          }, content.trim()), /*#__PURE__*/React.createElement(EuiButton, {
            type: "primary",
            size: "s",
            onClick: function onClick() {
              return banners.remove(id);
            }
          }, /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "core.ui.overlays.banner.closeButtonLabel",
            defaultMessage: "Close"
          })))), el);
          timeout = setTimeout(dismiss, lifetime);
          return function () {
            return ReactDOM.unmountComponentAtNode(el);
          };
        }, 100);
      };

      updateBanner();
      this.settingsSubscription = uiSettings.getUpdate$().pipe(filter(function (_ref2) {
        var key = _ref2.key;
        return key === 'notifications:banner' || key === 'notifications:lifetime:banner';
      })).subscribe(function () {
        return updateBanner();
      });
    }
  }, {
    key: "stop",
    value: function stop() {
      if (this.settingsSubscription) {
        this.settingsSubscription.unsubscribe();
        this.settingsSubscription = undefined;
      }
    }
  }]);

  return UserBannerService;
}();