"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderingService = void 0;

var _react = _interopRequireDefault(require("react"));

var _server = require("react-dom/server");

var _operators = require("rxjs/operators");

var _i18n = require("@kbn/i18n");

var _views = require("./views");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/** @internal */
class RenderingService {
  constructor(coreContext) {
    this.coreContext = coreContext;

    _defineProperty(this, "legacyInternals", void 0);
  }

  async setup({
    http,
    legacyPlugins,
    uiPlugins
  }) {
    return {
      render: async (request, uiSettings, {
        app = {
          getId: () => 'core'
        },
        includeUserSettings = true,
        vars
      } = {}) => {
        var _settings$user, _settings$user$theme;

        if (!this.legacyInternals) {
          throw new Error('Cannot render before "start"');
        }

        const env = {
          mode: this.coreContext.env.mode,
          packageInfo: this.coreContext.env.packageInfo
        };
        const basePath = http.basePath.get(request);
        const serverBasePath = http.basePath.serverBasePath;
        const settings = {
          defaults: uiSettings.getRegistered(),
          user: includeUserSettings ? await uiSettings.getUserProvided() : {}
        };
        const appId = app.getId();
        const metadata = {
          strictCsp: http.csp.strict,
          uiPublicUrl: `${basePath}/ui`,
          bootstrapScriptUrl: `${basePath}/bundles/app/${appId}/bootstrap.js`,
          i18n: _i18n.i18n.translate,
          locale: _i18n.i18n.getLocale(),
          darkMode: ((_settings$user = settings.user) === null || _settings$user === void 0 ? void 0 : (_settings$user$theme = _settings$user['theme:darkMode']) === null || _settings$user$theme === void 0 ? void 0 : _settings$user$theme.userValue) ? Boolean(settings.user['theme:darkMode'].userValue) : false,
          injectedMetadata: {
            version: env.packageInfo.version,
            buildNumber: env.packageInfo.buildNum,
            branch: env.packageInfo.branch,
            basePath,
            serverBasePath,
            env,
            legacyMode: appId !== 'core',
            i18n: {
              translationsUrl: `${basePath}/translations/${_i18n.i18n.getLocale()}.json`
            },
            csp: {
              warnLegacyBrowsers: http.csp.warnLegacyBrowsers
            },
            vars: vars !== null && vars !== void 0 ? vars : await this.legacyInternals.getVars('core', request),
            uiPlugins: await Promise.all([...uiPlugins.public].map(async ([id, plugin]) => ({
              id,
              plugin,
              config: await this.getUiConfig(uiPlugins, id)
            }))),
            legacyMetadata: {
              app,
              bundleId: `app:${appId}`,
              nav: legacyPlugins.navLinks,
              version: env.packageInfo.version,
              branch: env.packageInfo.branch,
              buildNum: env.packageInfo.buildNum,
              buildSha: env.packageInfo.buildSha,
              serverName: http.server.name,
              devMode: env.mode.dev,
              basePath,
              uiSettings: settings
            }
          }
        };
        return `<!DOCTYPE html>${(0, _server.renderToStaticMarkup)( /*#__PURE__*/_react.default.createElement(_views.Template, {
          metadata: metadata
        }))}`;
      }
    };
  }

  async start({
    legacy
  }) {
    this.legacyInternals = legacy.legacyInternals;
  }

  async stop() {}

  async getUiConfig(uiPlugins, pluginId) {
    var _await$browserConfig$;

    const browserConfig = uiPlugins.browserConfigs.get(pluginId);
    return (_await$browserConfig$ = await (browserConfig === null || browserConfig === void 0 ? void 0 : browserConfig.pipe((0, _operators.take)(1)).toPromise())) !== null && _await$browserConfig$ !== void 0 ? _await$browserConfig$ : {};
  }

}

exports.RenderingService = RenderingService;