function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect, useState, useCallback } from 'react';
import { EuiButtonEmpty, EuiOverlayMask, EuiModal, EuiButton, EuiModalHeader, EuiModalHeaderTitle, EuiModalBody, EuiModalFooter, EuiForm, EuiFormRow, EuiFieldText, EuiSwitch, EuiText } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { sortBy, isEqual } from 'lodash';
export function SaveQueryForm(_ref) {
  var savedQuery = _ref.savedQuery,
      savedQueryService = _ref.savedQueryService,
      onSave = _ref.onSave,
      onClose = _ref.onClose,
      _ref$showFilterOption = _ref.showFilterOption,
      showFilterOption = _ref$showFilterOption === void 0 ? true : _ref$showFilterOption,
      _ref$showTimeFilterOp = _ref.showTimeFilterOption,
      showTimeFilterOption = _ref$showTimeFilterOp === void 0 ? true : _ref$showTimeFilterOp;

  var _useState = useState(savedQuery ? savedQuery.title : ''),
      _useState2 = _slicedToArray(_useState, 2),
      title = _useState2[0],
      setTitle = _useState2[1];

  var _useState3 = useState(Boolean(savedQuery)),
      _useState4 = _slicedToArray(_useState3, 2),
      enabledSaveButton = _useState4[0],
      setEnabledSaveButton = _useState4[1];

  var _useState5 = useState(savedQuery ? savedQuery.description : ''),
      _useState6 = _slicedToArray(_useState5, 2),
      description = _useState6[0],
      setDescription = _useState6[1];

  var _useState7 = useState([]),
      _useState8 = _slicedToArray(_useState7, 2),
      savedQueries = _useState8[0],
      setSavedQueries = _useState8[1];

  var _useState9 = useState(savedQuery ? !!savedQuery.filters : true),
      _useState10 = _slicedToArray(_useState9, 2),
      shouldIncludeFilters = _useState10[0],
      setShouldIncludeFilters = _useState10[1]; // Defaults to false because saved queries are meant to be as portable as possible and loading
  // a saved query with a time filter will override whatever the current value of the global timepicker
  // is. We expect this option to be used rarely and only when the user knows they want this behavior.


  var _useState11 = useState(savedQuery ? !!savedQuery.timefilter : false),
      _useState12 = _slicedToArray(_useState11, 2),
      shouldIncludeTimefilter = _useState12[0],
      setIncludeTimefilter = _useState12[1];

  var _useState13 = useState([]),
      _useState14 = _slicedToArray(_useState13, 2),
      formErrors = _useState14[0],
      setFormErrors = _useState14[1];

  var titleConflictErrorText = i18n.translate('data.search.searchBar.savedQueryForm.titleConflictText', {
    defaultMessage: 'Name conflicts with an existing saved query'
  });
  var savedQueryDescriptionText = i18n.translate('data.search.searchBar.savedQueryDescriptionText', {
    defaultMessage: 'Save query text and filters that you want to use again.'
  });
  useEffect(function () {
    var fetchQueries = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var allSavedQueries, sortedAllSavedQueries;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return savedQueryService.getAllSavedQueries();

              case 2:
                allSavedQueries = _context.sent;
                sortedAllSavedQueries = sortBy(allSavedQueries, 'attributes.title');
                setSavedQueries(sortedAllSavedQueries);

              case 5:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function fetchQueries() {
        return _ref2.apply(this, arguments);
      };
    }();

    fetchQueries();
  }, [savedQueryService]);
  var validate = useCallback(function () {
    var errors = [];

    if (!!savedQueries.find(function (existingSavedQuery) {
      return !savedQuery && existingSavedQuery.attributes.title === title;
    })) {
      errors.push(titleConflictErrorText);
    }

    if (!isEqual(errors, formErrors)) {
      setFormErrors(errors);
      return false;
    }

    return !formErrors.length;
  }, [savedQueries, savedQuery, title, titleConflictErrorText, formErrors]);
  var onClickSave = useCallback(function () {
    if (validate()) {
      onSave({
        title: title,
        description: description,
        shouldIncludeFilters: shouldIncludeFilters,
        shouldIncludeTimefilter: shouldIncludeTimefilter
      });
    }
  }, [validate, onSave, title, description, shouldIncludeFilters, shouldIncludeTimefilter]);
  var onInputChange = useCallback(function (event) {
    setEnabledSaveButton(Boolean(event.target.value));
    setFormErrors([]);
    setTitle(event.target.value);
  }, []);
  var autoTrim = useCallback(function () {
    var trimmedTitle = title.trim();

    if (title.length > trimmedTitle.length) {
      setTitle(trimmedTitle);
    }
  }, [title]);
  var hasErrors = formErrors.length > 0;
  var saveQueryForm = /*#__PURE__*/React.createElement(EuiForm, {
    isInvalid: hasErrors,
    error: formErrors,
    "data-test-subj": "saveQueryForm"
  }, /*#__PURE__*/React.createElement(EuiFormRow, null, /*#__PURE__*/React.createElement(EuiText, {
    color: "subdued"
  }, savedQueryDescriptionText)), /*#__PURE__*/React.createElement(EuiFormRow, {
    label: i18n.translate('data.search.searchBar.savedQueryNameLabelText', {
      defaultMessage: 'Name'
    }),
    helpText: i18n.translate('data.search.searchBar.savedQueryNameHelpText', {
      defaultMessage: 'Name is required. Name cannot contain leading or trailing whitespace. Name must be unique.'
    }),
    isInvalid: hasErrors
  }, /*#__PURE__*/React.createElement(EuiFieldText, {
    disabled: !!savedQuery,
    value: title,
    name: "title",
    onChange: onInputChange,
    "data-test-subj": "saveQueryFormTitle",
    isInvalid: hasErrors,
    onBlur: autoTrim
  })), /*#__PURE__*/React.createElement(EuiFormRow, {
    label: i18n.translate('data.search.searchBar.savedQueryDescriptionLabelText', {
      defaultMessage: 'Description'
    })
  }, /*#__PURE__*/React.createElement(EuiFieldText, {
    value: description,
    name: "description",
    onChange: function onChange(event) {
      setDescription(event.target.value);
    },
    "data-test-subj": "saveQueryFormDescription"
  })), showFilterOption && /*#__PURE__*/React.createElement(EuiFormRow, null, /*#__PURE__*/React.createElement(EuiSwitch, {
    name: "shouldIncludeFilters",
    label: i18n.translate('data.search.searchBar.savedQueryIncludeFiltersLabelText', {
      defaultMessage: 'Include filters'
    }),
    checked: shouldIncludeFilters,
    onChange: function onChange() {
      setShouldIncludeFilters(!shouldIncludeFilters);
    },
    "data-test-subj": "saveQueryFormIncludeFiltersOption"
  })), showTimeFilterOption && /*#__PURE__*/React.createElement(EuiFormRow, null, /*#__PURE__*/React.createElement(EuiSwitch, {
    name: "shouldIncludeTimefilter",
    label: i18n.translate('data.search.searchBar.savedQueryIncludeTimeFilterLabelText', {
      defaultMessage: 'Include time filter'
    }),
    checked: shouldIncludeTimefilter,
    onChange: function onChange() {
      setIncludeTimefilter(!shouldIncludeTimefilter);
    },
    "data-test-subj": "saveQueryFormIncludeTimeFilterOption"
  })));
  return /*#__PURE__*/React.createElement(EuiOverlayMask, null, /*#__PURE__*/React.createElement(EuiModal, {
    onClose: onClose,
    initialFocus: "[name=title]"
  }, /*#__PURE__*/React.createElement(EuiModalHeader, null, /*#__PURE__*/React.createElement(EuiModalHeaderTitle, null, i18n.translate('data.search.searchBar.savedQueryFormTitle', {
    defaultMessage: 'Save query'
  }))), /*#__PURE__*/React.createElement(EuiModalBody, null, saveQueryForm), /*#__PURE__*/React.createElement(EuiModalFooter, null, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    onClick: onClose,
    "data-test-subj": "savedQueryFormCancelButton"
  }, i18n.translate('data.search.searchBar.savedQueryFormCancelButtonText', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/React.createElement(EuiButton, {
    onClick: onClickSave,
    fill: true,
    "data-test-subj": "savedQueryFormSaveButton",
    disabled: hasErrors || !enabledSaveButton
  }, i18n.translate('data.search.searchBar.savedQueryFormSaveButtonText', {
    defaultMessage: 'Save'
  })))));
}