/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiButton, EuiText } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { DiscoverFieldDetails } from './discover_field_details';
import { FieldIcon } from '../../../../../kibana_react/public';
import { shortenDottedString } from '../../helpers';
import { getFieldTypeName } from './lib/get_field_type_name';
export function DiscoverField(_ref) {
  var field = _ref.field,
      indexPattern = _ref.indexPattern,
      onAddField = _ref.onAddField,
      onRemoveField = _ref.onRemoveField,
      onAddFilter = _ref.onAddFilter,
      onShowDetails = _ref.onShowDetails,
      showDetails = _ref.showDetails,
      getDetails = _ref.getDetails,
      selected = _ref.selected,
      useShortDots = _ref.useShortDots;
  var addLabel = i18n.translate('discover.fieldChooser.discoverField.addButtonLabel', {
    defaultMessage: 'Add'
  });
  var addLabelAria = i18n.translate('discover.fieldChooser.discoverField.addButtonAriaLabel', {
    defaultMessage: 'Add {field} to table',
    values: {
      field: field.name
    }
  });
  var removeLabel = i18n.translate('discover.fieldChooser.discoverField.removeButtonLabel', {
    defaultMessage: 'Remove'
  });
  var removeLabelAria = i18n.translate('discover.fieldChooser.discoverField.removeButtonAriaLabel', {
    defaultMessage: 'Remove {field} from table',
    values: {
      field: field.name
    }
  });

  var toggleDisplay = function toggleDisplay(f) {
    if (selected) {
      onRemoveField(f.name);
    } else {
      onAddField(f.name);
    }
  };

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", {
    className: "dscSidebarField dscSidebarItem ".concat(showDetails ? 'dscSidebarItem--active' : ''),
    tabIndex: 0,
    onClick: function onClick() {
      return onShowDetails(!showDetails, field);
    },
    onKeyPress: function onKeyPress() {
      return onShowDetails(!showDetails, field);
    },
    "data-test-subj": "field-".concat(field.name, "-showDetails")
  }, /*#__PURE__*/React.createElement("span", {
    className: "dscSidebarField__fieldIcon"
  }, /*#__PURE__*/React.createElement(FieldIcon, {
    type: field.type,
    label: getFieldTypeName(field.type),
    scripted: field.scripted
  })), /*#__PURE__*/React.createElement("span", {
    className: "dscSidebarField__name eui-textTruncate"
  }, /*#__PURE__*/React.createElement(EuiText, {
    size: "xs",
    "data-test-subj": "field-".concat(field.name),
    className: "eui-textTruncate",
    title: field.name
  }, useShortDots ? shortenDottedString(field.name) : field.displayName)), /*#__PURE__*/React.createElement("span", null, field.name !== '_source' && !selected && /*#__PURE__*/React.createElement(EuiButton, {
    fill: true,
    size: "s",
    className: "dscSidebarItem__action",
    onClick: function onClick(ev) {
      ev.preventDefault();
      ev.stopPropagation();
      toggleDisplay(field);
    },
    "data-test-subj": "fieldToggle-".concat(field.name),
    "arial-label": addLabelAria
  }, addLabel), field.name !== '_source' && selected && /*#__PURE__*/React.createElement(EuiButton, {
    color: "danger",
    className: "dscSidebarItem__action",
    onClick: function onClick(ev) {
      ev.preventDefault();
      ev.stopPropagation();
      toggleDisplay(field);
    },
    "data-test-subj": "fieldToggle-".concat(field.name),
    "arial-label": removeLabelAria
  }, removeLabel))), showDetails && /*#__PURE__*/React.createElement(DiscoverFieldDetails, {
    indexPattern: indexPattern,
    field: field,
    details: getDetails(field),
    onAddFilter: onAddFilter
  }));
}