function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState } from 'react';
import { i18n } from '@kbn/i18n';
import { EuiFacetButton, EuiFieldSearch, EuiFlexGroup, EuiFlexItem, EuiIcon, EuiPopover, EuiPopoverFooter, EuiPopoverTitle, EuiSelect, EuiSwitch, EuiForm, EuiFormRow, EuiButtonGroup, EuiOutsideClickDetector } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';

/**
 * Component is Discover's side bar to  search of available fields
 * Additionally there's a button displayed that allows the user to show/hide more filter fields
 */
export function DiscoverFieldSearch(_ref) {
  var _onChange = _ref.onChange,
      value = _ref.value,
      types = _ref.types;
  var searchPlaceholder = i18n.translate('discover.fieldChooser.searchPlaceHolder', {
    defaultMessage: 'Search field names'
  });
  var aggregatableLabel = i18n.translate('discover.fieldChooser.filter.aggregatableLabel', {
    defaultMessage: 'Aggregatable'
  });
  var searchableLabel = i18n.translate('discover.fieldChooser.filter.searchableLabel', {
    defaultMessage: 'Searchable'
  });
  var typeLabel = i18n.translate('discover.fieldChooser.filter.typeLabel', {
    defaultMessage: 'Type'
  });
  var typeOptions = types ? types.map(function (type) {
    return {
      value: type,
      text: type
    };
  }) : [{
    value: 'any',
    text: 'any'
  }];

  var _useState = useState(0),
      _useState2 = _slicedToArray(_useState, 2),
      activeFiltersCount = _useState2[0],
      setActiveFiltersCount = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      isPopoverOpen = _useState4[0],
      setPopoverOpen = _useState4[1];

  var _useState5 = useState({
    searchable: 'any',
    aggregatable: 'any',
    type: 'any',
    missing: true
  }),
      _useState6 = _slicedToArray(_useState5, 2),
      values = _useState6[0],
      setValues = _useState6[1];

  if (typeof value !== 'string') {
    // at initial rendering value is undefined (angular related), this catches the warning
    // should be removed once all is react
    return null;
  }

  var filterBtnAriaLabel = isPopoverOpen ? i18n.translate('discover.fieldChooser.toggleFieldFilterButtonHideAriaLabel', {
    defaultMessage: 'Hide field filter settings'
  }) : i18n.translate('discover.fieldChooser.toggleFieldFilterButtonShowAriaLabel', {
    defaultMessage: 'Show field filter settings'
  });

  var handleFacetButtonClicked = function handleFacetButtonClicked() {
    setPopoverOpen(!isPopoverOpen);
  };

  var applyFilterValue = function applyFilterValue(id, filterValue) {
    switch (filterValue) {
      case 'any':
        if (id !== 'type') {
          _onChange(id, undefined);
        } else {
          _onChange(id, filterValue);
        }

        break;

      case 'true':
        _onChange(id, true);

        break;

      case 'false':
        _onChange(id, false);

        break;

      default:
        _onChange(id, filterValue);

    }
  };

  var isFilterActive = function isFilterActive(name, filterValue) {
    return name !== 'missing' && filterValue !== 'any';
  };

  var handleValueChange = function handleValueChange(name, filterValue) {
    var previousValue = values[name];
    updateFilterCount(name, previousValue, filterValue);

    var updatedValues = _objectSpread({}, values);

    updatedValues[name] = filterValue;
    setValues(updatedValues);
    applyFilterValue(name, filterValue);
  };

  var updateFilterCount = function updateFilterCount(name, previousValue, currentValue) {
    var previouslyFilterActive = isFilterActive(name, previousValue);
    var filterActive = isFilterActive(name, currentValue);
    var diff = Number(filterActive) - Number(previouslyFilterActive);
    setActiveFiltersCount(activeFiltersCount + diff);
  };

  var handleMissingChange = function handleMissingChange(e) {
    var missingValue = e.target.checked;
    handleValueChange('missing', missingValue);
  };

  var buttonContent = /*#__PURE__*/React.createElement(EuiFacetButton, {
    "aria-label": filterBtnAriaLabel,
    "data-test-subj": "toggleFieldFilterButton",
    className: "dscFieldSearch__toggleButton",
    icon: /*#__PURE__*/React.createElement(EuiIcon, {
      type: "filter"
    }),
    isSelected: activeFiltersCount > 0,
    quantity: activeFiltersCount,
    onClick: handleFacetButtonClicked
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.fieldChooser.fieldFilterFacetButtonLabel",
    defaultMessage: "Filter by type"
  }));

  var select = function select(id, selectOptions, selectValue) {
    return /*#__PURE__*/React.createElement(EuiSelect, {
      id: "".concat(id, "-select"),
      options: selectOptions,
      value: selectValue,
      onChange: function onChange(e) {
        return handleValueChange(id, e.target.value);
      },
      "aria-label": i18n.translate('discover.fieldChooser.filter.fieldSelectorLabel', {
        defaultMessage: 'Selection of {id} filter options',
        values: {
          id: id
        }
      }),
      "data-test-subj": "".concat(id, "Select"),
      compressed: true
    });
  };

  var toggleButtons = function toggleButtons(id) {
    return [{
      id: "".concat(id, "-any"),
      label: 'any'
    }, {
      id: "".concat(id, "-true"),
      label: 'yes'
    }, {
      id: "".concat(id, "-false"),
      label: 'no'
    }];
  };

  var buttonGroup = function buttonGroup(id, legend) {
    return /*#__PURE__*/React.createElement(EuiButtonGroup, {
      legend: legend,
      options: toggleButtons(id),
      idSelected: "".concat(id, "-").concat(values[id]),
      onChange: function onChange(optionId) {
        return handleValueChange(id, optionId.replace("".concat(id, "-"), ''));
      },
      buttonSize: "compressed",
      isFullWidth: true,
      "data-test-subj": "".concat(id, "ButtonGroup")
    });
  };

  var selectionPanel = /*#__PURE__*/React.createElement("div", {
    className: "dscFieldSearch__formWrapper"
  }, /*#__PURE__*/React.createElement(EuiForm, {
    "data-test-subj": "filterSelectionPanel"
  }, /*#__PURE__*/React.createElement(EuiFormRow, {
    fullWidth: true,
    label: aggregatableLabel,
    display: "columnCompressed"
  }, buttonGroup('aggregatable', aggregatableLabel)), /*#__PURE__*/React.createElement(EuiFormRow, {
    fullWidth: true,
    label: searchableLabel,
    display: "columnCompressed"
  }, buttonGroup('searchable', searchableLabel)), /*#__PURE__*/React.createElement(EuiFormRow, {
    fullWidth: true,
    label: typeLabel,
    display: "columnCompressed"
  }, select('type', typeOptions, values.type))));
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    responsive: false,
    gutterSize: 's'
  }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFieldSearch, {
    "aria-label": searchPlaceholder,
    "data-test-subj": "fieldFilterSearchInput",
    compressed: true,
    fullWidth: true,
    onChange: function onChange(event) {
      return _onChange('name', event.currentTarget.value);
    },
    placeholder: searchPlaceholder,
    value: value
  }))), /*#__PURE__*/React.createElement("div", {
    className: "dscFieldSearch__filterWrapper"
  }, /*#__PURE__*/React.createElement(EuiOutsideClickDetector, {
    onOutsideClick: function onOutsideClick() {},
    isDisabled: !isPopoverOpen
  }, /*#__PURE__*/React.createElement(EuiPopover, {
    id: "dataPanelTypeFilter",
    panelClassName: "euiFilterGroup__popoverPanel",
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    display: "block",
    isOpen: isPopoverOpen,
    closePopover: function closePopover() {
      setPopoverOpen(false);
    },
    button: buttonContent
  }, /*#__PURE__*/React.createElement(EuiPopoverTitle, null, i18n.translate('discover.fieldChooser.filter.filterByTypeLabel', {
    defaultMessage: 'Filter by type'
  })), selectionPanel, /*#__PURE__*/React.createElement(EuiPopoverFooter, null, /*#__PURE__*/React.createElement(EuiSwitch, {
    label: i18n.translate('discover.fieldChooser.filter.hideMissingFieldsLabel', {
      defaultMessage: 'Hide missing fields'
    }),
    checked: values.missing,
    onChange: handleMissingChange,
    "data-test-subj": "missingSwitch"
  }))))));
}