function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { createHashHistory } from 'history';
import { createStateContainer, syncState, createKbnUrlStateStorage } from '../../../../../plugins/kibana_utils/public';

/**
 * Create state container with sync config for tab navigation specific for edit_index_pattern page
 */
export function createEditIndexPatternPageStateContainer(_ref) {
  var defaultTab = _ref.defaultTab,
      useHashedUrl = _ref.useHashedUrl;
  var history = createHashHistory(); // query param to store app state at

  var stateStorageKey = '_a'; // default app state, when there is no initial state in the url

  var defaultState = {
    tab: defaultTab
  };
  var kbnUrlStateStorage = createKbnUrlStateStorage({
    useHash: useHashedUrl,
    history: history
  }); // extract starting app state from URL and use it as starting app state in state container

  var initialStateFromUrl = kbnUrlStateStorage.get(stateStorageKey);
  var stateContainer = createStateContainer(_objectSpread(_objectSpread({}, defaultState), initialStateFromUrl), {
    setTab: function setTab(state) {
      return function (tab) {
        return _objectSpread(_objectSpread({}, state), {}, {
          tab: tab
        });
      };
    }
  }, {
    tab: function tab(state) {
      return function () {
        return state.tab;
      };
    }
  });

  var _syncState = syncState({
    storageKey: stateStorageKey,
    stateContainer: _objectSpread(_objectSpread({}, stateContainer), {}, {
      // state syncing utility requires state containers to handle "null"
      set: function set(state) {
        return state && stateContainer.set(state);
      }
    }),
    stateStorage: kbnUrlStateStorage
  }),
      start = _syncState.start,
      stop = _syncState.stop; // makes sure initial url is the same as initial state (this is not really required)


  kbnUrlStateStorage.set(stateStorageKey, stateContainer.getState(), {
    replace: true
  });
  return {
    startSyncingState: start,
    stopSyncingState: stop,
    setCurrentTab: function setCurrentTab(newTab) {
      return stateContainer.transitions.setTab(newTab);
    },
    getCurrentTab: function getCurrentTab() {
      return stateContainer.selectors.tab();
    }
  };
}