function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { upperFirst, isFunction } from 'lodash';
import React from 'react';
import { EuiButtonEmpty, EuiToolTip } from '@elastic/eui';
import { EuiButton } from '@elastic/eui';
export function TopNavMenuItem(props) {
  function isDisabled() {
    var val = isFunction(props.disableButton) ? props.disableButton() : props.disableButton;
    return val;
  }

  function getTooltip() {
    var val = isFunction(props.tooltip) ? props.tooltip() : props.tooltip;
    return val;
  }

  function handleClick(e) {
    if (isDisabled()) return;
    props.run(e.currentTarget);
  }

  var commonButtonProps = {
    isDisabled: isDisabled(),
    onClick: handleClick,
    iconType: props.iconType,
    iconSide: props.iconSide,
    'data-test-subj': props.testId
  };
  var btn = props.emphasize ? /*#__PURE__*/React.createElement(EuiButton, _extends({}, commonButtonProps, {
    size: "s",
    fill: true
  }), upperFirst(props.label || props.id)) : /*#__PURE__*/React.createElement(EuiButtonEmpty, _extends({}, commonButtonProps, {
    size: "xs"
  }), upperFirst(props.label || props.id));
  var tooltip = getTooltip();

  if (tooltip) {
    return /*#__PURE__*/React.createElement(EuiToolTip, {
      content: tooltip
    }, btn);
  }

  return btn;
}
TopNavMenuItem.defaultProps = {
  disableButton: false,
  tooltip: ''
};