function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import './index.scss';
import { ShareMenuManager } from './services';
import { ShareMenuRegistry } from './services';
import { createShortUrlRedirectApp } from './services/short_url_redirect_app';
import { UrlGeneratorsService } from './url_generators/url_generator_service';
export var SharePlugin = /*#__PURE__*/function () {
  function SharePlugin() {
    _classCallCheck(this, SharePlugin);

    _defineProperty(this, "shareMenuRegistry", new ShareMenuRegistry());

    _defineProperty(this, "shareContextMenu", new ShareMenuManager());

    _defineProperty(this, "urlGeneratorsService", new UrlGeneratorsService());
  }

  _createClass(SharePlugin, [{
    key: "setup",
    value: function setup(core) {
      core.application.register(createShortUrlRedirectApp(core, window.location));
      return _objectSpread(_objectSpread({}, this.shareMenuRegistry.setup()), {}, {
        urlGenerators: this.urlGeneratorsService.setup(core)
      });
    }
  }, {
    key: "start",
    value: function start(core) {
      return _objectSpread(_objectSpread({}, this.shareContextMenu.start(core, this.shareMenuRegistry.start())), {}, {
        urlGenerators: this.urlGeneratorsService.start(core)
      });
    }
  }]);

  return SharePlugin;
}();
/** @public */