function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/* eslint-disable jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions */
// The color picker is not yet accessible.
import React, { useState } from 'react';
import { EuiIconTip, EuiColorPicker, EuiColorPickerSwatch } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
var COMMAS_NUMS_ONLY_RE = /[^0-9,]/g;
export function ColorPicker(_ref) {
  var name = _ref.name,
      value = _ref.value,
      _ref$disableTrash = _ref.disableTrash,
      disableTrash = _ref$disableTrash === void 0 ? false : _ref$disableTrash,
      onChange = _ref.onChange;
  var initialColorValue = (value === null || value === void 0 ? void 0 : value.includes('rgba')) ? value.replace(COMMAS_NUMS_ONLY_RE, '') : value;

  var _useState = useState(initialColorValue || ''),
      _useState2 = _slicedToArray(_useState, 2),
      color = _useState2[0],
      setColor = _useState2[1];

  var handleColorChange = function handleColorChange(text, _ref2) {
    var rgba = _ref2.rgba,
        hex = _ref2.hex;
    setColor(text);
    var part = {};
    part[name] = hex ? "rgba(".concat(rgba.join(','), ")") : '';
    onChange(part);
  };

  var handleClear = function handleClear() {
    setColor('');
    var part = {};
    part[name] = null;
    onChange(part);
  };

  var label = value ? i18n.translate('visTypeTimeseries.colorPicker.notAccessibleWithValueAriaLabel', {
    defaultMessage: 'Color picker ({value}), not accessible',
    values: {
      value: value
    }
  }) : i18n.translate('visTypeTimeseries.colorPicker.notAccessibleAriaLabel', {
    defaultMessage: 'Color picker, not accessible'
  });
  return /*#__PURE__*/React.createElement("div", {
    className: "tvbColorPicker",
    "data-test-subj": "tvbColorPicker"
  }, /*#__PURE__*/React.createElement(EuiColorPicker, {
    onChange: handleColorChange,
    color: color,
    secondaryInputDisplay: "top",
    showAlpha: true,
    button: /*#__PURE__*/React.createElement(EuiColorPickerSwatch, {
      color: color,
      "aria-label": label
    })
  }), !disableTrash && /*#__PURE__*/React.createElement("div", {
    className: "tvbColorPicker__clear",
    onClick: handleClear
  }, /*#__PURE__*/React.createElement(EuiIconTip, {
    size: "s",
    type: "cross",
    color: "danger",
    content: i18n.translate('visTypeTimeseries.colorPicker.clearIconLabel', {
      defaultMessage: 'Clear'
    })
  })));
}