function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * @name SavedVis
 *
 * @extends SavedObject.
 *
 * NOTE: It's a type of SavedObject, but specific to visualizations.
 */
import { createSavedObjectClass } from '../../../../plugins/saved_objects/public'; // @ts-ignore

import { updateOldState } from '../legacy/vis_update_state';
import { extractReferences, injectReferences } from './saved_visualization_references';
import { createSavedSearchesLoader } from '../../../discover/public';
export var convertToSerializedVis = function convertToSerializedVis(savedVis) {
  var id = savedVis.id,
      title = savedVis.title,
      description = savedVis.description,
      visState = savedVis.visState,
      uiStateJSON = savedVis.uiStateJSON,
      searchSourceFields = savedVis.searchSourceFields;
  var aggs = searchSourceFields && searchSourceFields.index ? visState.aggs || [] : visState.aggs;
  return {
    id: id,
    title: title,
    type: visState.type,
    description: description,
    params: visState.params,
    uiState: JSON.parse(uiStateJSON || '{}'),
    data: {
      aggs: aggs,
      searchSource: searchSourceFields,
      savedSearchId: savedVis.savedSearchId
    }
  };
};
export var convertFromSerializedVis = function convertFromSerializedVis(vis) {
  return {
    id: vis.id,
    title: vis.title,
    description: vis.description,
    visState: {
      title: vis.title,
      type: vis.type,
      aggs: vis.data.aggs,
      params: vis.params
    },
    uiStateJSON: JSON.stringify(vis.uiState),
    searchSourceFields: vis.data.searchSource,
    savedSearchId: vis.data.savedSearchId
  };
};
export function createSavedVisClass(services) {
  var SavedObjectClass = createSavedObjectClass(services);
  var savedSearch = createSavedSearchesLoader(services);

  var SavedVis = /*#__PURE__*/function (_SavedObjectClass) {
    _inherits(SavedVis, _SavedObjectClass);

    var _super = _createSuper(SavedVis);

    // Order these fields to the top, the rest are alphabetical
    function SavedVis() {
      var _this;

      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      _classCallCheck(this, SavedVis);

      if (_typeof(opts) !== 'object') {
        opts = {
          id: opts
        };
      }

      var visState = !opts.type ? null : {
        type: opts.type
      }; // Gives our SavedWorkspace the properties of a SavedObject

      _this = _super.call(this, {
        type: SavedVis.type,
        mapping: SavedVis.mapping,
        extractReferences: extractReferences,
        injectReferences: injectReferences,
        id: opts.id || '',
        indexPattern: opts.indexPattern,
        defaults: {
          title: '',
          visState: visState,
          uiStateJSON: '{}',
          description: '',
          savedSearchId: opts.savedSearchId,
          version: 1
        },
        afterESResp: function () {
          var _afterESResp = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(savedObject) {
            var _savedVis$searchSourc;

            var savedVis;
            return regeneratorRuntime.wrap(function _callee$(_context) {
              while (1) {
                switch (_context.prev = _context.next) {
                  case 0:
                    savedVis = savedObject;
                    _context.next = 3;
                    return updateOldState(savedVis.visState);

                  case 3:
                    savedVis.visState = _context.sent;

                    if (!((_savedVis$searchSourc = savedVis.searchSourceFields) === null || _savedVis$searchSourc === void 0 ? void 0 : _savedVis$searchSourc.index)) {
                      _context.next = 7;
                      break;
                    }

                    _context.next = 7;
                    return services.indexPatterns.get(savedVis.searchSourceFields.index);

                  case 7:
                    if (!savedVis.savedSearchId) {
                      _context.next = 10;
                      break;
                    }

                    _context.next = 10;
                    return savedSearch.get(savedVis.savedSearchId);

                  case 10:
                    return _context.abrupt("return", savedVis);

                  case 11:
                  case "end":
                    return _context.stop();
                }
              }
            }, _callee);
          }));

          function afterESResp(_x) {
            return _afterESResp.apply(this, arguments);
          }

          return afterESResp;
        }()
      });
      _this.showInRecentlyAccessed = true;

      _this.getFullPath = function () {
        return "/app/visualize#/edit/".concat(_this.id);
      };

      return _this;
    }

    return SavedVis;
  }(SavedObjectClass);

  _defineProperty(SavedVis, "type", 'visualization');

  _defineProperty(SavedVis, "mapping", {
    title: 'text',
    visState: 'json',
    uiStateJSON: 'text',
    description: 'text',
    savedSearchId: 'keyword',
    version: 'integer'
  });

  _defineProperty(SavedVis, "fieldOrder", ['title', 'description']);

  return SavedVis;
}