## How to contribute to Mailpile

First of all: Thank you! :heart:


#### Further Reading

Second of all, please adhere to our Code of Conduct when you participate
in our community. Be kind, be respectful. [The full Code of Conduct can
be found here](CODE_OF_CONDUCT.md).

Please also be sure you are comfortable with [our license](COPYING.md)
before contributing any code to Mailpile.

Note that Mailpile is a slightly unsual app; the design is both political
and opinionated. If you are confused or unsure whether something is a bug or a
feature, [our developer FAQ might have answers](DEV_FAQ.md)! Please read it
before filing issues about design choices or attempting to reorganize the code
in any major way. The FAQ also contains a quick introduction Mailpile internals
and debugging techniques.

Also, have you seen [the main Mailpile website](https://www.mailpile.is/) and
[the community Discourse](https://community.mailpile.is/categories)?


#### Are you new to Mailpile and/or FOSS?

* Welcome! The first step is probably to get Mailpile up and running, play with it, get familiar.

* Read the links above, and [check out our website](https://www.mailpile.is/) if you haven't already.

* Not sure what to work on? Find inspiration in one of our [Low Hanging Fruit](https://github.com/mailpile/Mailpile/issues?q=is%3Aissue+is%3Aopen+label%3A%22Low+Hanging+Fruit%22) issues!

* Otherwise, read on...


#### Did you find a bug?

* **Ensure the bug was not already reported** by searching on GitHub
  under [Issues](https://github.com/mailpile/Mailpile/issues).

* If you're unable to find an open issue addressing the problem,
  [open a new one](https://github.com/mailpile/Mailpile/issues/new). Be
  sure to include a **title and clear description**, as much relevant
  information as possible.

* Remember, we cannot read your mind or see your screen, so you'll
  probably need to answer all of these:

   1. What were you doing?
   2. What did you expect would happen?
   3. What actually happened?
   4. Operating system? GnuPG version? Mailpile version?

* Reproducability is key. If you cannot reliably trigger the bug or
  cannot describe how to do so, then unfortunately it's less likely that
  the Mailpile team will be able to do anything about it. It may still
  be useful to file a report in case others are having the same issue, but
  bugs that can be reproduced will in general get fixed much faster!

* The [Developer FAQ](DEV_FAQ.md) has a section on debugging techniques.

* If it's not bug, but you still need help: [visit our Discourse support
  forum](https://community.mailpile.is/c/support).


#### Did you write a patch that fixes a bug?

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution.
  Include the relevant issue number if applicable.


#### Do you plan write a patch that adds a feature?

* Please be sure you have read the [Developer FAQ](DEV_FAQ.md) to ensure
  your feature is compatible with our high-level goals and design decisions.

* If you are unsure or would like some guidance, join the #mailpile
  channel on IRC (Freenode) and discuss your plans there.

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes what your feature does.
  Include the relevant issue number if applicable.


#### Did you fix whitespace, format code, or make a purely cosmetic patch?

Changes that are cosmetic in nature and do not add anything substantial to the
stability, functionality, or testability of Mailpile will generally not be
accepted.

All patches to Mailpile are reviewed by a human and our resources (time,
people) are very limited. Cosmetic patches are no easier to review than other
patches and we would rather focus our efforts on functional improvements to the
software.


#### Do you want help other users?

Our [community Discourse](https://community.mailpile.is/categories) has a
support forum and needs friendly people to help out and steer conversations
in friendly and productive directions. Please join the conversation!


#### Do you want to translate Mailpile to your language?

Please feel free to join our translation community
[on Transifex](https://www.transifex.com/otf/mailpile/).


#### Do you plan to write documentation?

* Please feel free to contribute documentation to
  [our wiki](https://github.com/mailpile/Mailpile/wiki).

* If you would like some guidance, join the #mailpile channel on IRC
  (Freenode) or file an issue with your questions.

* If you added a new page or made major major changes to an existing page,
  please file [a new issue requesting a review](https://github.com/mailpile/Mailpile/issues/new)
  when you are done. Be sure to include a link to the wiki page!


#### Credits

This document borrows some language and structure from the [Ruby on Rails
contributor guidelines](https://raw.githubusercontent.com/rails/rails/master/CONTRIBUTING.md).

