/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.JavaException;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.ProcessingTerminated;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SpecialOperator;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public final class Extensions {
    public static final Symbol _ED_FUNCTIONS_ = Lisp.exportSpecial("*ED-FUNCTIONS*", Lisp.PACKAGE_EXT, Lisp.list(Lisp.intern("DEFAULT-ED-FUNCTION", Lisp.PACKAGE_SYS), new LispObject[0]));
    private static final SpecialOperator TRULY_THE = new truly_the();
    private static final Primitive NEQ = new neq();
    private static final Primitive MEMQ = new memq();
    private static final Primitive MEMQL = new memql();
    private static final Primitive ADJOIN_EQL = new adjoin_eql();
    private static final Primitive SPECIAL_VARIABLE_P = new special_variable_p();
    private static final Primitive SOURCE = new source();
    private static final Primitive SOURCE_FILE_POSITION = new source_file_position();
    public static final Primitive SOURCE_PATHNAME = new pf_source_pathname();
    private static final Primitive EXIT = new exit();
    private static final Primitive QUIT = new quit();
    private static final Primitive DUMP_JAVA_STACK = new dump_java_stack();
    public static final Primitive MAKE_TEMP_FILE = new make_temp_file();
    public static final Primitive MAKE_TEMP_DIRECTORY = new make_temp_directory();
    private static final Primitive INTERRUPT_LISP = new interrupt_lisp();
    private static final Primitive GETENV = new getenv();
    private static final Primitive GETENV_ALL = new getenv_all();

    private static class getenv_all
    extends Primitive {
        getenv_all() {
            super("getenv-all", Lisp.PACKAGE_EXT, true, "variable", "Returns all environment variables as an alist containing (name . value)");
        }

        @Override
        public LispObject execute() {
            Cons result = new Cons(Lisp.NIL);
            Map<String, String> env = System.getenv();
            for (Map.Entry<String, String> entry : env.entrySet()) {
                Cons entryPair = new Cons(new SimpleString(entry.getKey()), (LispObject)new SimpleString(entry.getValue()));
                result = new Cons(entryPair, (LispObject)result);
            }
            return result;
        }
    }

    private static class getenv
    extends Primitive {
        getenv() {
            super("getenv", Lisp.PACKAGE_EXT, true, "variable", "Return the value of the environment VARIABLE if it exists, otherwise return NIL.");
        }

        @Override
        public LispObject execute(LispObject arg) {
            if (!(arg instanceof AbstractString)) {
                return Lisp.type_error(arg, Symbol.STRING);
            }
            AbstractString string = (AbstractString)arg;
            String result = System.getenv(string.getStringValue());
            if (result != null) {
                return new SimpleString(result);
            }
            return Lisp.NIL;
        }
    }

    private static class interrupt_lisp
    extends Primitive {
        interrupt_lisp() {
            super("interrupt-lisp", Lisp.PACKAGE_EXT, true, "");
        }

        @Override
        public LispObject execute() {
            Lisp.setInterrupted(true);
            return Lisp.T;
        }
    }

    @DocString(name="make-temp-directory", doc="Create and return the pathname of a previously non-existent directory.")
    private static class make_temp_directory
    extends Primitive {
        make_temp_directory() {
            super("make-temp-directory", Lisp.PACKAGE_EXT, true, "");
        }

        @Override
        public LispObject execute() {
            try {
                File dir = File.createTempFile("abcl", null);
                dir.delete();
                if (dir.mkdirs()) {
                    return Pathname.create(dir + "/");
                }
            }
            catch (Throwable t) {
                Debug.trace(t);
            }
            return Lisp.NIL;
        }
    }

    @DocString(name="make-temp-file", doc="Create and return the pathname of a previously non-existent file.", args="&key prefix suffix")
    private static class make_temp_file
    extends Primitive {
        make_temp_file() {
            super("make-temp-file", Lisp.PACKAGE_EXT, true, "&key prefix suffix");
        }

        @Override
        public LispObject execute(LispObject ... args) {
            String prefix = "abcl";
            String suffix = null;
            if (args.length % 2 != 0) {
                Lisp.error(new WrongNumberOfArgumentsException("Expecting an even number of arguments including keywords."));
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].SYMBOLP() != Lisp.NIL) {
                    String specifiedSuffix;
                    if (args[i].equals(Keyword.PREFIX)) {
                        String specifiedPrefix = args[i + 1].getStringValue();
                        if (specifiedPrefix == null) continue;
                        if (specifiedPrefix.equals(Lisp.NIL.getStringValue())) {
                            Lisp.error(new TypeError("Cannot create temporary file with NIL prefix."));
                        }
                        prefix = specifiedPrefix;
                        ++i;
                        continue;
                    }
                    if (!args[i].equals(Keyword.SUFFIX) || (specifiedSuffix = args[i + 1].getStringValue()) == null) continue;
                    suffix = specifiedSuffix.equals(Lisp.NIL.getStringValue()) ? null : specifiedSuffix;
                    ++i;
                    continue;
                }
                Lisp.error(new TypeError("Expected matching keyword argument.", args[i], Keyword.PREFIX.classOf()));
            }
            return this.createTempFile(prefix, suffix);
        }

        @Override
        public LispObject execute() {
            return this.createTempFile("abcl", null);
        }

        private LispObject createTempFile(String prefix, String suffix) {
            try {
                File file = File.createTempFile(prefix, suffix, null);
                if (file != null) {
                    return Pathname.create(file.getPath());
                }
            }
            catch (IllegalArgumentException e) {
                Lisp.error(new JavaException(e));
            }
            catch (SecurityException e) {
                Lisp.error(new JavaException(e));
            }
            catch (IOException e) {
                Lisp.error(new JavaException(e));
            }
            return Lisp.NIL;
        }
    }

    private static class dump_java_stack
    extends Primitive {
        dump_java_stack() {
            super("dump-java-stack", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute() {
            Thread.dumpStack();
            return LispThread.currentThread().nothing();
        }
    }

    private static class quit
    extends Primitive {
        quit() {
            super("quit", Lisp.PACKAGE_EXT, true, "&key status");
        }

        @Override
        public LispObject execute() {
            ((Stream)Symbol.STANDARD_OUTPUT.getSymbolValue())._finishOutput();
            ((Stream)Symbol.ERROR_OUTPUT.getSymbolValue())._finishOutput();
            throw new ProcessingTerminated();
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            int status = 0;
            if (first == Keyword.STATUS && second instanceof Fixnum) {
                status = ((Fixnum)second).value;
            }
            throw new ProcessingTerminated(status);
        }
    }

    private static class exit
    extends Primitive {
        exit() {
            super("exit", Lisp.PACKAGE_EXT, true, "&key status");
        }

        @Override
        public LispObject execute() {
            throw new ProcessingTerminated();
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            int status = 0;
            if (first == Keyword.STATUS && second instanceof Fixnum) {
                status = ((Fixnum)second).value;
            }
            throw new ProcessingTerminated(status);
        }
    }

    @DocString(name="source-pathname", args="symbol", doc="Returns either the pathname corresponding to the file from which this symbol was compiled,or the keyword :TOP-LEVEL.")
    private static class pf_source_pathname
    extends Primitive {
        pf_source_pathname() {
            super("source-pathname", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            LispObject obj = Lisp.get(arg, Symbol._SOURCE, Lisp.NIL);
            if (obj instanceof Cons) {
                return obj.car();
            }
            return obj;
        }
    }

    private static class source_file_position
    extends Primitive {
        source_file_position() {
            super("source-file-position", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            LispObject obj = Lisp.get(arg, Symbol._SOURCE, Lisp.NIL);
            if (obj instanceof Cons) {
                return obj.cdr();
            }
            return Lisp.NIL;
        }
    }

    private static class source
    extends Primitive {
        source() {
            super("source", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            return Lisp.get(arg, Symbol._SOURCE, Lisp.NIL);
        }
    }

    private static class special_variable_p
    extends Primitive {
        special_variable_p() {
            super("special-variable-p", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            return arg.isSpecialVariable() ? Lisp.T : Lisp.NIL;
        }
    }

    private static class adjoin_eql
    extends Primitive {
        adjoin_eql() {
            super(Symbol.ADJOIN_EQL, "item list");
        }

        @Override
        public LispObject execute(LispObject item, LispObject list) {
            return Lisp.memql(item, list) ? list : new Cons(item, list);
        }
    }

    private static class memql
    extends Primitive {
        memql() {
            super(Symbol.MEMQL, "item list");
        }

        @Override
        public LispObject execute(LispObject item, LispObject list) {
            while (list instanceof Cons) {
                if (item.eql(((Cons)list).car)) {
                    return list;
                }
                list = ((Cons)list).cdr;
            }
            if (list != Lisp.NIL) {
                Lisp.type_error(list, Symbol.LIST);
            }
            return Lisp.NIL;
        }
    }

    private static class memq
    extends Primitive {
        memq() {
            super(Symbol.MEMQ, "item list");
        }

        @Override
        public LispObject execute(LispObject item, LispObject list) {
            while (list instanceof Cons) {
                if (item == ((Cons)list).car) {
                    return list;
                }
                list = ((Cons)list).cdr;
            }
            if (list != Lisp.NIL) {
                Lisp.type_error(list, Symbol.LIST);
            }
            return Lisp.NIL;
        }
    }

    private static class neq
    extends Primitive {
        neq() {
            super(Symbol.NEQ, "obj1 obj2");
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            return first != second ? Lisp.T : Lisp.NIL;
        }
    }

    private static class truly_the
    extends SpecialOperator {
        truly_the() {
            super("truly-the", Lisp.PACKAGE_EXT, true, "type value");
        }

        @Override
        public LispObject execute(LispObject args, Environment env) {
            if (args.length() != 2) {
                return Lisp.error(new WrongNumberOfArgumentsException(this, 2));
            }
            return Lisp.eval(args.cadr(), env, LispThread.currentThread());
        }
    }
}

