/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.table;

import ca.sqlpower.swingui.table.ExportFormatter;
import java.io.PrintWriter;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;

public class TableModelHTMLFormatter
implements ExportFormatter {
    private static final String NULL_STRING = "";
    private final Map<Integer, Format> columnFormatters = new HashMap<Integer, Format>();

    public void setFormatter(int column, Format formatter) {
        this.columnFormatters.put(column, formatter);
    }

    @Override
    public void formatToStream(TableModel model, PrintWriter writer) {
        int[] allRows = new int[model.getRowCount()];
        for (int i = 0; i < model.getRowCount(); ++i) {
            allRows[i] = i;
        }
        this.formatToStream(model, writer, allRows);
    }

    @Override
    public void formatToStream(TableModel model, PrintWriter writer, int[] selectedRows) {
        int i;
        writer.println("<table>");
        writer.println(" <tr>");
        for (i = 0; i < model.getColumnCount(); ++i) {
            writer.print("  <th>");
            writer.print(model.getColumnName(i));
            writer.println("</th>");
        }
        writer.println(" </tr>");
        for (i = 0; i < selectedRows.length; ++i) {
            writer.println(" <tr>");
            for (int j = 0; j < model.getColumnCount(); ++j) {
                writer.print("  <td>");
                Object value = model.getValueAt(selectedRows[i], j);
                if (value != null) {
                    if (this.columnFormatters.get(j) != null) {
                        writer.print(this.columnFormatters.get(j).format(value));
                    } else {
                        writer.print(value.toString());
                    }
                } else {
                    writer.print(NULL_STRING);
                }
                writer.println("</td>");
            }
            writer.println(" </tr>");
        }
        writer.println("</table>");
        writer.close();
    }
}

