<?php
/**
 * fabos.inc.php
 *
 * LibreNMS fanspeed discovery module for fabos
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * @link       https://www.librenms.org
 * @copyright  2017 Neil Lathwood
 * @author     Neil Lathwood <neil@lathwood.co.uk>
 */
foreach ($pre_cache['fabos_sensors'] as $data) {
    if ($data['swSensorType'] === 'fan') {
        if (is_numeric($data['swSensorValue']) && $data['swSensorValue'] !== '-2147483648') {
            $index = $data['swSensorIndex'];
            $oid = '.1.3.6.1.4.1.1588.2.1.1.1.1.22.1.4.' . $index;
            $descr = $data['swSensorInfo'];
            $value = $data['swSensorValue'];
            discover_sensor($valid['sensor'], 'fan', $device, $oid, $index, 'fabos', $descr, '1', '1', null, null, null, null, $value);
        }
    }
}
