/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.traccar.Context;
import org.traccar.api.BaseResource;
import org.traccar.model.Position;

@Path(value="positions")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class PositionResource
extends BaseResource {
    @GET
    public Collection<Position> getJson(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="id") List<Long> positionIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws SQLException {
        if (!positionIds.isEmpty()) {
            ArrayList<Position> positions = new ArrayList<Position>();
            for (Long positionId : positionIds) {
                Position position = Context.getDataManager().getObject(Position.class, positionId);
                Context.getPermissionsManager().checkDevice(this.getUserId(), position.getDeviceId());
                positions.add(position);
            }
            return positions;
        }
        if (deviceId == 0L) {
            return Context.getDeviceManager().getInitialState(this.getUserId());
        }
        Context.getPermissionsManager().checkDevice(this.getUserId(), deviceId);
        if (from != null && to != null) {
            return Context.getDataManager().getPositions(deviceId, from, to);
        }
        return Collections.singleton(Context.getDeviceManager().getLastPosition(deviceId));
    }
}

