/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class AutoTrackProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN_REQUEST = 51;
    public static final int MSG_LOGIN_CONFIRM = 101;
    public static final int MSG_TELEMETRY_1 = 52;
    public static final int MSG_TELEMETRY_2 = 66;
    public static final int MSG_TELEMETRY_3 = 67;
    public static final int MSG_KEEP_ALIVE = 114;
    public static final int MSG_TELEMETRY_CONFIRM = 123;

    public AutoTrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Position decodeTelemetry(Channel channel, SocketAddress remoteAddress, DeviceSession deviceSession, ByteBuf buf) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(new Date(1009843200000L + buf.readUnsignedIntLE() * 1000L));
        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
        position.set("odometer", buf.readUnsignedIntLE());
        position.set("fuelUsed", buf.readUnsignedIntLE());
        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShortLE()));
        buf.readUnsignedShortLE();
        position.set("input", buf.readUnsignedShortLE());
        buf.readUnsignedIntLE();
        buf.readUnsignedIntLE();
        for (int i = 0; i < 5; ++i) {
            position.set("adc" + (i + 1), buf.readUnsignedShortLE());
        }
        position.setCourse(buf.readUnsignedShortLE());
        position.set("status", buf.readUnsignedShortLE());
        position.set("event", buf.readUnsignedShortLE());
        position.set("driverUniqueId", buf.readLongLE());
        int index = buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeInt(-235802127);
            response.writeByte(123);
            response.writeShortLE(2);
            response.writeShortLE(index);
            response.writeShort(Checksum.crc16(Checksum.CRC16_XMODEM, response.nioBuffer()));
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(4);
        short type = buf.readUnsignedByte();
        buf.readUnsignedShortLE();
        switch (type) {
            case 51: {
                String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8));
                DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
                if (deviceSession == null) {
                    return null;
                }
                int fuelConst = buf.readUnsignedShortLE();
                int tripConst = buf.readUnsignedShortLE();
                if (channel != null) {
                    ByteBuf response = Unpooled.buffer();
                    response.writeInt(-235802127);
                    response.writeByte(101);
                    response.writeShortLE(12);
                    response.writeBytes(ByteBufUtil.decodeHexDump((CharSequence)imei));
                    response.writeShortLE(fuelConst);
                    response.writeShortLE(tripConst);
                    response.writeShort(Checksum.crc16(Checksum.CRC16_XMODEM, response.nioBuffer()));
                    channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
                }
                return null;
            }
            case 52: 
            case 66: 
            case 67: {
                DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
                if (deviceSession == null) {
                    return null;
                }
                return this.decodeTelemetry(channel, remoteAddress, deviceSession, buf);
            }
        }
        return null;
    }
}

