/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.simpleeval;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.entries.simpleeval.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntrySimpleEval
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    public static final String[] valueTypeDesc = new String[]{Messages.getString("JobSimpleEval.EvalPreviousField.Label"), Messages.getString("JobSimpleEval.EvalVariable.Label")};
    public static final String[] valueTypeCode = new String[]{"field", "variable"};
    public static final int VALUE_TYPE_FIELD = 0;
    public static final int VALUE_TYPE_VARIABLE = 1;
    public int valuetype;
    public static final String[] successConditionDesc = new String[]{Messages.getString("JobSimpleEval.SuccessWhenEqual.Label"), Messages.getString("JobSimpleEval.SuccessWhenDifferent.Label")};
    public static final String[] successConditionCode = new String[]{"equal", "different"};
    public static final int SUCCESS_CONDITION_EQUAL = 0;
    public static final int SUCCESS_CONDITION_DIFFERENT = 1;
    public int successcondition;
    public static final String[] fieldTypeDesc = new String[]{Messages.getString("JobSimpleEval.FieldTypeString.Label"), Messages.getString("JobSimpleEval.FieldTypeNumber.Label"), Messages.getString("JobSimpleEval.FieldTypeDateTime.Label")};
    public static final String[] fieldTypeCode = new String[]{"string", "number", "datetime"};
    public static final int FIELD_TYPE_STRING = 0;
    public static final int FIELD_TYPE_NUMBER = 1;
    public static final int FIELD_TYPE_DATE_TIME = 2;
    public int fieldtype;
    public static final String[] successNumberConditionDesc = new String[]{Messages.getString("JobSimpleEval.SuccessWhenEqual.Label"), Messages.getString("JobSimpleEval.SuccessWhenDifferent.Label"), Messages.getString("JobSimpleEval.SuccessWhenSmallThan.Label"), Messages.getString("JobSimpleEval.SuccessWhenSmallOrEqualThan.Label"), Messages.getString("JobSimpleEval.SuccessWhenGreaterThan.Label"), Messages.getString("JobSimpleEval.SuccessWhenGreaterOrEqualThan.Label"), Messages.getString("JobSimpleEval.SuccessBetween.Label")};
    public static final String[] successNumberConditionCode = new String[]{"equal", "different", "smaller", "smallequal", "greater", "greaterequal", "between"};
    public static final int SUCCESS_NUMBER_CONDITION_EQUAL = 0;
    public static final int SUCCESS_NUMBER_CONDITIONDIFFERENT = 1;
    public static final int SUCCESS_NUMBER_CONDITION_SMALLER = 2;
    public static final int SUCCESS_NUMBER_CONDITION_SMALLEREQUAL = 3;
    public static final int SUCCESS_NUMBER_CONDITION_GREATER = 4;
    public static final int SUCCESS_NUMBER_CONDITION_GREATEREQUAL = 5;
    public static final int SUCCESS_NUMBER_CONDITION_BETWEEN = 6;
    public int successnumbercondition;
    private String fieldname;
    private String variablename;
    private String mask;
    private String comparevalue;
    private String minvalue;
    private String maxvalue;

    public JobEntrySimpleEval(String n) {
        super(n, "");
        this.valuetype = 0;
        this.successcondition = 0;
        this.successnumbercondition = 0;
        this.minvalue = null;
        this.maxvalue = null;
        this.comparevalue = null;
        this.fieldname = null;
        this.variablename = null;
        this.fieldtype = 0;
        this.mask = null;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.SIMPLE_EVAL);
    }

    public JobEntrySimpleEval() {
        this("");
    }

    public JobEntrySimpleEval(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntrySimpleEval je = (JobEntrySimpleEval)super.clone();
        return je;
    }

    private static String getValueTypeCode(int i) {
        if (i < 0 || i >= valueTypeCode.length) {
            return valueTypeCode[0];
        }
        return valueTypeCode[i];
    }

    private static String getFieldTypeCode(int i) {
        if (i < 0 || i >= fieldTypeCode.length) {
            return fieldTypeCode[0];
        }
        return fieldTypeCode[i];
    }

    private static String getSuccessConditionCode(int i) {
        if (i < 0 || i >= successConditionCode.length) {
            return successConditionCode[0];
        }
        return successConditionCode[i];
    }

    private static String getSuccessNumberConditionCode(int i) {
        if (i < 0 || i >= successNumberConditionCode.length) {
            return successNumberConditionCode[0];
        }
        return successNumberConditionCode[i];
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"valuetype", (String)JobEntrySimpleEval.getValueTypeCode(this.valuetype)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fieldname", (String)this.fieldname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"variablename", (String)this.variablename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fieldtype", (String)JobEntrySimpleEval.getFieldTypeCode(this.fieldtype)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"mask", (String)this.mask));
        retval.append("      ").append(XMLHandler.addTagValue((String)"comparevalue", (String)this.comparevalue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"minvalue", (String)this.minvalue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"maxvalue", (String)this.maxvalue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"successcondition", (String)JobEntrySimpleEval.getSuccessConditionCode(this.successcondition)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"successnumbercondition", (String)JobEntrySimpleEval.getSuccessNumberConditionCode(this.successnumbercondition)));
        return retval.toString();
    }

    private static int getValueTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < valueTypeCode.length; ++i) {
            if (!valueTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getSuccessNumberByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successNumberConditionCode.length; ++i) {
            if (!successNumberConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getFieldTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < fieldTypeCode.length; ++i) {
            if (!fieldTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getSuccessConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionCode.length; ++i) {
            if (!successConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getSuccessNumberConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successNumberConditionCode.length; ++i) {
            if (!successNumberConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.valuetype = JobEntrySimpleEval.getValueTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"valuetype"), (String)""));
            this.fieldname = XMLHandler.getTagValue((Node)entrynode, (String)"fieldname");
            this.fieldtype = JobEntrySimpleEval.getFieldTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"fieldtype"), (String)""));
            this.variablename = XMLHandler.getTagValue((Node)entrynode, (String)"variablename");
            this.mask = XMLHandler.getTagValue((Node)entrynode, (String)"mask");
            this.comparevalue = XMLHandler.getTagValue((Node)entrynode, (String)"comparevalue");
            this.minvalue = XMLHandler.getTagValue((Node)entrynode, (String)"minvalue");
            this.maxvalue = XMLHandler.getTagValue((Node)entrynode, (String)"maxvalue");
            this.successcondition = JobEntrySimpleEval.getSuccessConditionByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"successcondition"), (String)""));
            this.successnumbercondition = JobEntrySimpleEval.getSuccessNumberConditionByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"successnumbercondition"), (String)""));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobEntrySimple.Error.Exception.UnableLoadXML"), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.valuetype = JobEntrySimpleEval.getValueTypeByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "valuetype"), (String)""));
            this.fieldname = rep.getJobEntryAttributeString(id_jobentry, "fieldname");
            this.variablename = rep.getJobEntryAttributeString(id_jobentry, "variablename");
            this.fieldtype = JobEntrySimpleEval.getFieldTypeByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "fieldtype"), (String)""));
            this.mask = rep.getJobEntryAttributeString(id_jobentry, "mask");
            this.comparevalue = rep.getJobEntryAttributeString(id_jobentry, "comparevalue");
            this.minvalue = rep.getJobEntryAttributeString(id_jobentry, "minvalue");
            this.maxvalue = rep.getJobEntryAttributeString(id_jobentry, "maxvalue");
            this.successcondition = JobEntrySimpleEval.getSuccessConditionByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "successcondition"), (String)""));
            this.successnumbercondition = JobEntrySimpleEval.getSuccessNumberConditionByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "successnumbercondition"), (String)""));
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobEntrySimple.Error.Exception.UnableLoadRep") + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "valuetype", JobEntrySimpleEval.getValueTypeCode(this.valuetype));
            rep.saveJobEntryAttribute(id_job, this.getID(), "fieldname", this.fieldname);
            rep.saveJobEntryAttribute(id_job, this.getID(), "variablename", this.variablename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "fieldtype", JobEntrySimpleEval.getFieldTypeCode(this.fieldtype));
            rep.saveJobEntryAttribute(id_job, this.getID(), "fieldtype", this.fieldtype);
            rep.saveJobEntryAttribute(id_job, this.getID(), "mask", this.mask);
            rep.saveJobEntryAttribute(id_job, this.getID(), "comparevalue", this.comparevalue);
            rep.saveJobEntryAttribute(id_job, this.getID(), "minvalue", this.minvalue);
            rep.saveJobEntryAttribute(id_job, this.getID(), "maxvalue", this.maxvalue);
            rep.saveJobEntryAttribute(id_job, this.getID(), "successcondition", JobEntrySimpleEval.getSuccessConditionCode(this.successcondition));
            rep.saveJobEntryAttribute(id_job, this.getID(), "successnumbercondition", JobEntrySimpleEval.getSuccessNumberConditionCode(this.successnumbercondition));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntrySimple.Error.Exception.UnableSaveRep") + id_job, (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) throws KettleException {
        LogWriter log = LogWriter.getInstance();
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String sourcevalue = null;
        switch (this.valuetype) {
            case 0: {
                List rows = result.getRows();
                RowMetaAndData resultRow = null;
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobEntrySimpleEval.Log.ArgFromPrevious.Found", (rows != null ? rows.size() : 0) + ""), new Object[0]);
                }
                if (rows.size() == 0) {
                    rows = null;
                    log.logError(this.toString(), Messages.getString("JobEntrySimpleEval.Error.NoRows"), new Object[0]);
                    return result;
                }
                resultRow = (RowMetaAndData)rows.get(0);
                String realfieldname = this.environmentSubstitute(this.fieldname);
                int indexOfField = -1;
                indexOfField = resultRow.getRowMeta().indexOfValue(realfieldname);
                if (indexOfField == -1) {
                    log.logError(this.toString(), Messages.getString("JobEntrySimpleEval.Error.FieldNotExist", realfieldname), new Object[0]);
                    resultRow = null;
                    rows = null;
                    return result;
                }
                sourcevalue = resultRow.getString(indexOfField, null);
                resultRow = null;
                rows = null;
                break;
            }
            case 1: {
                if (Const.isEmpty((String)this.variablename)) {
                    log.logError(this.toString(), Messages.getString("JobEntrySimpleEval.Error.VariableMissing"), new Object[0]);
                    return result;
                }
                sourcevalue = this.environmentSubstitute(this.variablename);
                break;
            }
        }
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobSimpleEval.Log.ValueToevaluate", sourcevalue), new Object[0]);
        }
        boolean success = false;
        String realCompareValue = this.environmentSubstitute(this.comparevalue);
        String realMinValue = this.environmentSubstitute(this.minvalue);
        String realMaxValue = this.environmentSubstitute(this.maxvalue);
        block22 : switch (this.fieldtype) {
            case 0: {
                switch (this.successcondition) {
                    case 0: {
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValue", sourcevalue, realCompareValue), new Object[0]);
                        }
                        success = sourcevalue.equals(realCompareValue);
                        break block22;
                    }
                    case 1: {
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValue", sourcevalue, realCompareValue), new Object[0]);
                        }
                        success = !sourcevalue.equals(realCompareValue);
                        break block22;
                    }
                }
                break;
            }
            case 1: {
                double valuenumber;
                try {
                    valuenumber = Double.parseDouble(sourcevalue);
                }
                catch (Exception e) {
                    log.logError(this.toString(), Messages.getString("JobEntrySimpleEval.Error.UnparsableNumber", sourcevalue, e.getMessage()), new Object[0]);
                    return result;
                }
                switch (this.successnumbercondition) {
                    case 0: {
                        double valuecompare;
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValue", sourcevalue, realCompareValue), new Object[0]);
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), Messages.getString("JobEntrySimpleEval.Error.UnparsableNumber", realCompareValue, e.getMessage()), new Object[0]);
                            return result;
                        }
                        success = valuenumber == valuecompare;
                        break block22;
                    }
                    case 1: {
                        double valuecompare;
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValue", sourcevalue, realCompareValue), new Object[0]);
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), Messages.getString("JobEntrySimpleEval.Error.UnparsableNumber", realCompareValue, e.getMessage()), new Object[0]);
                            return result;
                        }
                        success = valuenumber != valuecompare;
                        break block22;
                    }
                    case 2: {
                        double valuecompare;
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValue", sourcevalue, realCompareValue), new Object[0]);
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), Messages.getString("JobEntrySimpleEval.Error.UnparsableNumber", realCompareValue, e.getMessage()), new Object[0]);
                            return result;
                        }
                        success = valuenumber < valuecompare;
                        break block22;
                    }
                    case 3: {
                        double valuecompare;
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValue", sourcevalue, realCompareValue), new Object[0]);
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), Messages.getString("JobEntrySimpleEval.Error.UnparsableNumber", realCompareValue, e.getMessage()), new Object[0]);
                            return result;
                        }
                        success = valuenumber <= valuecompare;
                        break block22;
                    }
                    case 4: {
                        double valuecompare;
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), Messages.getString("JobEntrySimpleEval.Error.UnparsableNumber", realCompareValue, e.getMessage()), new Object[0]);
                            return result;
                        }
                        success = valuenumber > valuecompare;
                        break block22;
                    }
                    case 5: {
                        double valuecompare;
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValue", sourcevalue, realCompareValue), new Object[0]);
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), Messages.getString("JobEntrySimpleEval.Error.UnparsableNumber", realCompareValue, e.getMessage()), new Object[0]);
                            return result;
                        }
                        success = valuenumber >= valuecompare;
                        break block22;
                    }
                    case 6: {
                        double valuemax;
                        double valuemin;
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValues", realMinValue, realMaxValue), new Object[0]);
                        }
                        try {
                            valuemin = Double.parseDouble(realMinValue);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), Messages.getString("JobEntrySimpleEval.Error.UnparsableNumber", realMinValue, e.getMessage()), new Object[0]);
                            return result;
                        }
                        try {
                            valuemax = Double.parseDouble(realMaxValue);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), Messages.getString("JobEntrySimpleEval.Error.UnparsableNumber", realMaxValue, e.getMessage()), new Object[0]);
                            return result;
                        }
                        if (valuemin >= valuemax) {
                            log.logError(this.toString(), Messages.getString("JobEntrySimpleEval.Error.IncorrectNumbers", realMinValue, realMaxValue), new Object[0]);
                            return result;
                        }
                        success = valuenumber >= valuemin && valuenumber <= valuemax;
                        break block22;
                    }
                }
                break;
            }
            case 2: {
                String realMask = this.environmentSubstitute(this.mask);
                SimpleDateFormat df = new SimpleDateFormat();
                if (!Const.isEmpty((String)realMask)) {
                    df.applyPattern(realMask);
                }
                Date datevalue = null;
                try {
                    datevalue = this.convertToDate(sourcevalue, realMask, df);
                }
                catch (Exception e) {
                    log.logError(this.toString(), e.getMessage(), new Object[0]);
                    return result;
                }
                switch (this.successnumbercondition) {
                    case 0: {
                        Date datecompare;
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValue", sourcevalue, realCompareValue), new Object[0]);
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), e.getMessage(), new Object[0]);
                            return result;
                        }
                        success = datevalue.equals(datecompare);
                        break;
                    }
                    case 1: {
                        Date datecompare;
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValue", sourcevalue, realCompareValue), new Object[0]);
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), e.getMessage(), new Object[0]);
                            return result;
                        }
                        success = !datevalue.equals(datecompare);
                        break;
                    }
                    case 2: {
                        Date datecompare;
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValue", sourcevalue, realCompareValue), new Object[0]);
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), e.getMessage(), new Object[0]);
                            return result;
                        }
                        success = datevalue.before(datecompare);
                        break;
                    }
                    case 3: {
                        Date datecompare;
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValue", sourcevalue, realCompareValue), new Object[0]);
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), e.getMessage(), new Object[0]);
                            return result;
                        }
                        success = datevalue.before(datecompare) || datevalue.equals(datecompare);
                        break;
                    }
                    case 4: {
                        Date datecompare;
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValue", sourcevalue, realCompareValue), new Object[0]);
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), e.getMessage(), new Object[0]);
                            return result;
                        }
                        success = datevalue.after(datecompare);
                        break;
                    }
                    case 5: {
                        Date datecompare;
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValue", sourcevalue, realCompareValue), new Object[0]);
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), e.getMessage(), new Object[0]);
                            return result;
                        }
                        success = datevalue.after(datecompare) || datevalue.equals(datecompare);
                        break;
                    }
                    case 6: {
                        Date datemax;
                        Date datemin;
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobSimpleEval.Log.CompareWithValues", realMinValue, realMaxValue), new Object[0]);
                        }
                        try {
                            datemin = this.convertToDate(realMinValue, realMask, df);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), e.getMessage(), new Object[0]);
                            return result;
                        }
                        try {
                            datemax = this.convertToDate(realMaxValue, realMask, df);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), e.getMessage(), new Object[0]);
                            return result;
                        }
                        if (datemin.after(datemax) || datemin.equals(datemax)) {
                            log.logError(this.toString(), Messages.getString("JobEntrySimpleEval.Error.IncorrectDates", realMinValue, realMaxValue), new Object[0]);
                            return result;
                        }
                        success = !(!datevalue.after(datemin) && !datevalue.equals(datemin) || !datevalue.before(datemax) && !datevalue.equals(datemax));
                        break;
                    }
                }
                df = null;
            }
        }
        if (success) {
            result.setResult(true);
            result.setNrErrors(0L);
        }
        return result;
    }

    private Date convertToDate(String valueString, String mask, SimpleDateFormat df) throws KettleException {
        Date datevalue = null;
        try {
            datevalue = df.parse(valueString);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("JobEntrySimpleEval.Error.UnparsableDate", valueString));
        }
        return datevalue;
    }

    public static String getValueTypeDesc(int i) {
        if (i < 0 || i >= valueTypeDesc.length) {
            return valueTypeDesc[0];
        }
        return valueTypeDesc[i];
    }

    public static String getFieldTypeDesc(int i) {
        if (i < 0 || i >= fieldTypeDesc.length) {
            return fieldTypeDesc[0];
        }
        return fieldTypeDesc[i];
    }

    public static String getSuccessConditionDesc(int i) {
        if (i < 0 || i >= successConditionDesc.length) {
            return successConditionDesc[0];
        }
        return successConditionDesc[i];
    }

    public static String getSuccessNumberConditionDesc(int i) {
        if (i < 0 || i >= successNumberConditionDesc.length) {
            return successNumberConditionDesc[0];
        }
        return successNumberConditionDesc[i];
    }

    public static int getValueTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < valueTypeDesc.length; ++i) {
            if (!valueTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntrySimpleEval.getValueTypeByCode(tt);
    }

    public static int getFieldTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < fieldTypeDesc.length; ++i) {
            if (!fieldTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntrySimpleEval.getFieldTypeByCode(tt);
    }

    public static int getSuccessConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionDesc.length; ++i) {
            if (!successConditionDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntrySimpleEval.getSuccessConditionByCode(tt);
    }

    public static int getSuccessNumberConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successNumberConditionDesc.length; ++i) {
            if (!successNumberConditionDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntrySimpleEval.getSuccessNumberByCode(tt);
    }

    public void setMinValue(String minvalue) {
        this.minvalue = minvalue;
    }

    public String getMinValue() {
        return this.minvalue;
    }

    public void setCompareValue(String comparevalue) {
        this.comparevalue = comparevalue;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public String getFieldName() {
        return this.fieldname;
    }

    public void setFieldName(String fieldname) {
        this.fieldname = fieldname;
    }

    public String getVariableName() {
        return this.variablename;
    }

    public void setVariableName(String variablename) {
        this.variablename = variablename;
    }

    public String getCompareValue() {
        return this.comparevalue;
    }

    public void setMaxValue(String maxvalue) {
        this.maxvalue = maxvalue;
    }

    public String getMaxValue() {
        return this.maxvalue;
    }

    @Override
    public boolean evaluates() {
        return true;
    }
}

