import{ObjectWrapper as e,Revealer as t,Settings as o}from"../common/common.js";import{ArrayUtilities as s,MapUtilities as i,NumberUtilities as n,DateUtilities as r}from"../platform/platform.js";import{SDKModel as a,CPUProfilerModel as c,CSSModel as l,DebuggerModel as d,ResourceTreeModel as h}from"../sdk/sdk.js";import{Text as u,TextRange as g}from"../text_utils/text_utils.js";import{DataGrid as _,SortableDataGrid as p}from"../data_grid/data_grid.js";import{SourceFormatter as v}from"../formatter/formatter.js";import{i18n as f}from"../i18n/i18n.js";import{Widget as m,Tooltip as S,UIUtils as C,Toolbar as y,ActionRegistry as b,ViewManager as B}from"../ui/ui.js";import{Workspace as T,UISourceCode as P}from"../workspace/workspace.js";import{DebuggerWorkspaceBinding as w,CSSWorkspaceBinding as x,FileUtils as R}from"../bindings/bindings.js";import{userMetrics as I,UserMetrics as E}from"../host/host.js";import{SourcesTextEditor as k,SourceFrame as L}from"../source_frame/source_frame.js";var M;!function(e){e.CoverageUpdated="CoverageUpdated",e.CoverageReset="CoverageReset"}(M||(M={}));class F extends a.SDKModel{constructor(e){super(e),this._cpuProfilerModel=e.model(c.CPUProfilerModel),this._cssModel=e.model(l.CSSModel),this._debuggerModel=e.model(d.DebuggerModel),this._coverageByURL=new Map,this._coverageByContentProvider=new Map,this._coverageUpdateTimes=new Set,this._suspensionState="Active",this._pollTimer=null,this._currentPollPromise=null,this._shouldResumePollingOnResume=!1,this._jsBacklog=[],this._cssBacklog=[],this._performanceTraceRecording=!1}async start(e){if("Active"!==this._suspensionState)throw Error("Cannot start CoverageModel while it is not active.");const t=[];return this._cssModel&&(this._clearCSS(),this._cssModel.addEventListener(l.Events.StyleSheetAdded,this._handleStyleSheetAdded,this),t.push(this._cssModel.startCoverage())),this._cpuProfilerModel&&t.push(this._cpuProfilerModel.startPreciseCoverage(e,this.preciseCoverageDeltaUpdate.bind(this))),await Promise.all(t),Boolean(this._cssModel||this._cpuProfilerModel)}preciseCoverageDeltaUpdate(e,t,o){this._coverageUpdateTimes.add(e),this._backlogOrProcessJSCoverage(o,e)}async stop(){await this.stopPolling();const e=[];this._cpuProfilerModel&&e.push(this._cpuProfilerModel.stopPreciseCoverage()),this._cssModel&&(e.push(this._cssModel.stopCoverage()),this._cssModel.removeEventListener(l.Events.StyleSheetAdded,this._handleStyleSheetAdded,this)),await Promise.all(e)}reset(){this._coverageByURL=new Map,this._coverageByContentProvider=new Map,this._coverageUpdateTimes=new Set,this.dispatchEventToListeners(M.CoverageReset)}async startPolling(){this._currentPollPromise||"Active"!==this._suspensionState||await this._pollLoop()}async _pollLoop(){this._clearTimer(),this._currentPollPromise=this._pollAndCallback(),await this._currentPollPromise,("Active"===this._suspensionState||this._performanceTraceRecording)&&(this._pollTimer=window.setTimeout((()=>this._pollLoop()),200))}async stopPolling(){this._clearTimer(),await this._currentPollPromise,this._currentPollPromise=null,await this._pollAndCallback()}async _pollAndCallback(){if("Suspended"===this._suspensionState&&!this._performanceTraceRecording)return;const e=await this._takeAllCoverage();console.assert("Suspended"!==this._suspensionState||Boolean(this._performanceTraceRecording),"CoverageModel was suspended while polling."),e.length&&this.dispatchEventToListeners(M.CoverageUpdated,e)}_clearTimer(){this._pollTimer&&(clearTimeout(this._pollTimer),this._pollTimer=null)}async preSuspendModel(e){"Active"===this._suspensionState&&(this._suspensionState="Suspending","performance-timeline"!==e?this._currentPollPromise&&(await this.stopPolling(),this._shouldResumePollingOnResume=!0):this._performanceTraceRecording=!0)}async suspendModel(e){this._suspensionState="Suspended"}async resumeModel(){}async postResumeModel(){this._suspensionState="Active",this._performanceTraceRecording=!1,this._shouldResumePollingOnResume&&(this._shouldResumePollingOnResume=!1,await this.startPolling())}entries(){return Array.from(this._coverageByURL.values())}getCoverageForUrl(e){return this._coverageByURL.get(e)||null}usageForRange(e,t,o){const s=this._coverageByContentProvider.get(e);return s&&s.usageForRange(t,o)}_clearCSS(){for(const e of this._coverageByContentProvider.values()){if(1!==e.type())continue;const t=e.contentProvider();this._coverageByContentProvider.delete(t);const o=`${t.startLine}:${t.startColumn}`,s=this._coverageByURL.get(e.url());s&&s._coverageInfoByLocation.delete(o)&&(s._addToSizes(-e._usedSize,-e._size),s._coverageInfoByLocation.size||this._coverageByURL.delete(e.url()))}if(this._cssModel)for(const e of this._cssModel.getAllStyleSheetHeaders())this._addStyleSheetToCSSCoverage(e)}async _takeAllCoverage(){const[e,t]=await Promise.all([this._takeCSSCoverage(),this._takeJSCoverage()]);return[...e,...t]}async _takeJSCoverage(){if(!this._cpuProfilerModel)return[];const{coverage:e,timestamp:t}=await this._cpuProfilerModel.takePreciseCoverage();return this._coverageUpdateTimes.add(t),this._backlogOrProcessJSCoverage(e,t)}coverageUpdateTimes(){return this._coverageUpdateTimes}async _backlogOrProcessJSCoverage(e,t){if(e.length>0&&this._jsBacklog.push({rawCoverageData:e,stamp:t}),"Active"!==this._suspensionState)return[];const o=(e,t)=>e.stamp-t.stamp,s=[];for(const{rawCoverageData:e,stamp:t}of this._jsBacklog.sort(o))s.push(this._processJSCoverage(e,t));return this._jsBacklog=[],s.flat()}async processJSBacklog(){this._backlogOrProcessJSCoverage([],0)}_processJSCoverage(e,t){if(!this._debuggerModel)return[];const o=[];for(const s of e){const e=this._debuggerModel.scriptForId(s.scriptId);if(!e)continue;const i=[];let n=2;for(const e of s.functions){!1!==e.isBlockCoverage||1===e.ranges.length&&!e.ranges[0].count||(n|=4);for(const t of e.ranges)i.push(t)}const r=this._addCoverage(e,e.contentLength,e.lineOffset,e.columnOffset,i,n,t);r&&o.push(r)}return o}_handleStyleSheetAdded(e){const t=e.data;this._addStyleSheetToCSSCoverage(t)}async _takeCSSCoverage(){if(!this._cssModel||"Active"!==this._suspensionState)return[];const{coverage:e,timestamp:t}=await this._cssModel.takeCoverageDelta();return this._coverageUpdateTimes.add(t),this._backlogOrProcessCSSCoverage(e,t)}async _backlogOrProcessCSSCoverage(e,t){if(e.length>0&&this._cssBacklog.push({rawCoverageData:e,stamp:t}),"Active"!==this._suspensionState)return[];const o=(e,t)=>e.stamp-t.stamp,s=[];for(const{rawCoverageData:e,stamp:t}of this._cssBacklog.sort(o))s.push(this._processCSSCoverage(e,t));return this._cssBacklog=[],s.flat()}_processCSSCoverage(e,t){if(!this._cssModel)return[];const o=[],s=new Map;for(const t of e){const e=this._cssModel.styleSheetHeaderForId(t.styleSheetId);if(!e)continue;let o=s.get(e);o||(o=[],s.set(e,o)),o.push({startOffset:t.startOffset,endOffset:t.endOffset,count:Number(t.used)})}for(const e of s){const s=e[0],i=e[1],n=this._addCoverage(s,s.contentLength,s.startLine,s.startColumn,i,1,t);n&&o.push(n)}return o}static _convertToDisjointSegments(e,t){e.sort(((e,t)=>e.startOffset-t.startOffset));const o=[],s=[];for(const t of e){let e=s[s.length-1];for(;e&&e.endOffset<=t.startOffset;)i(e.endOffset,e.count),s.pop(),e=s[s.length-1];i(t.startOffset,e?e.count:0),s.push(t)}for(let e=s.pop();e;e=s.pop())i(e.endOffset,e.count);function i(e,s){const i=o[o.length-1];if(i){if(i.end===e)return;if(i.count===s)return void(i.end=e)}o.push({end:e,count:s,stamp:t})}return o}_addStyleSheetToCSSCoverage(e){this._addCoverage(e,e.contentLength,e.startLine,e.startColumn,[],1,Date.now())}_addCoverage(e,t,o,s,i,n,r){const a=e.contentURL();if(!a)return null;let c=this._coverageByURL.get(a),l=!1;c||(l=!0,c=new z(a),this._coverageByURL.set(a,c));const d=c._ensureEntry(e,t,o,s,n);this._coverageByContentProvider.set(e,d);const h=F._convertToDisjointSegments(i,r),u=h[h.length-1];u&&u.end<t&&h.push({end:t,stamp:r,count:0});const g=d._usedSize;return d.mergeCoverage(h),l||d._usedSize!==g?(c._addToSizes(d._usedSize-g,0),d):null}async exportReport(e){const t=[];function o(e,t){const[o,s]=e.split(":"),[i,n]=t.split(":");return Number.parseInt(o,10)-Number.parseInt(i,10)||Number.parseInt(s,10)-Number.parseInt(n,10)}const s=Array.from(this._coverageByURL.keys()).sort();for(const e of s){const s=this._coverageByURL.get(e);if(!s)continue;const i=s.url();if(i.startsWith("extensions::")||i.startsWith("chrome-extension://"))continue;let n=!1;for(const e of s._coverageInfoByLocation.values())if(e._lineOffset||e._columnOffset){n=Boolean(i);break}let r=null;if(n){const e=h.ResourceTreeModel.resourceForURL(i);if(e){const t=(await e.requestContent()).content;r=new u.Text(t||"")}}const a=Array.from(s._coverageInfoByLocation.keys()).sort(o);if(r){const e={url:i,ranges:[],text:r.value()};for(const t of a){const o=s._coverageInfoByLocation.get(t);if(!o)continue;const i=r?r.offsetFromPosition(o._lineOffset,o._columnOffset):0;let n=0;for(const t of o._segments)t.count?e.ranges.push({start:n+i,end:t.end+i}):n=t.end}t.push(e)}else for(const e of a){const o=s._coverageInfoByLocation.get(e);if(!o)continue;const n={url:i,ranges:[],text:(await o.contentProvider().requestContent()).content};let r=0;for(const e of o._segments)e.count?n.ranges.push({start:r,end:e.end}):r=e.end;t.push(n)}}await e.write(JSON.stringify(t,void 0,2)),e.close()}}a.SDKModel.register(F,a.Capability.None,!1);class z extends e.ObjectWrapper{constructor(e){super(),this._url=e,this._coverageInfoByLocation=new Map,this._size=0,this._usedSize=0,this._isContentScript=!1}url(){return this._url}type(){return this._type}size(){return this._size}usedSize(){return this._usedSize}unusedSize(){return this._size-this._usedSize}usedPercentage(){return 0===this._size?0:this.usedSize()/this.size()*100}unusedPercentage(){return 0===this._size?100:this.unusedSize()/this.size()*100}isContentScript(){return this._isContentScript}entries(){return this._coverageInfoByLocation.values()}_addToSizes(e,t){this._usedSize+=e,this._size+=t,0===e&&0===t||this.dispatchEventToListeners(z.Events.SizesChanged)}_ensureEntry(e,t,o,s,i){const n=`${o}:${s}`;let r=this._coverageInfoByLocation.get(n);return 2&i&&!this._coverageInfoByLocation.size&&(this._isContentScript=e.isContentScript()),this._type|=i,r?(r._coverageType|=i,r):(2&i&&!this._coverageInfoByLocation.size&&(this._isContentScript=e.isContentScript()),r=new A(e,t,o,s,i),this._coverageInfoByLocation.set(n,r),this._addToSizes(0,t),r)}}!function(e){e.Events={SizesChanged:Symbol("SizesChanged")}}(z||(z={}));const U=(e,t)=>{const o=[];let s=0,i=0;for(;s<e.length&&i<t.length;){const n=e[s],r=t[i],a=(n.count||0)+(r.count||0),c=Math.min(n.end,r.end),l=o[o.length-1],d=Math.min(n.stamp,r.stamp);l&&l.count===a&&l.stamp===d?l.end=c:o.push({end:c,count:a,stamp:d}),n.end<=r.end&&s++,n.end>=r.end&&i++}for(;s<e.length;s++)o.push(e[s]);for(;i<t.length;i++)o.push(t[i]);return o};class A{constructor(e,t,o,s,i){this._contentProvider=e,this._size=t,this._usedSize=0,this._statsByTimestamp=new Map,this._lineOffset=o,this._columnOffset=s,this._coverageType=i,this._segments=[]}contentProvider(){return this._contentProvider}url(){return this._contentProvider.contentURL()}type(){return this._coverageType}mergeCoverage(e){this._segments=U(this._segments,e),this._updateStats()}usedByTimestamp(){return this._statsByTimestamp}size(){return this._size}usageForRange(e,t){let o=s.upperBound(this._segments,e,((e,t)=>e-t.end));for(;o<this._segments.length&&this._segments[o].end<t;++o)if(this._segments[o].count)return!0;return o<this._segments.length&&Boolean(this._segments[o].count)}_updateStats(){this._statsByTimestamp=new Map,this._usedSize=0;let e=0;for(const t of this._segments){let o=this._statsByTimestamp.get(t.stamp);if(void 0===o&&(o=0),t.count){const s=t.end-e;this._usedSize+=s,this._statsByTimestamp.set(t.stamp,o+s)}e=t.end}}}var O=Object.freeze({__proto__:null,get Events(){return M},CoverageModel:F,get URLCoverageInfo(){return z},mergeSegments:U,CoverageInfo:A});const H={css:"CSS",jsPerFunction:"JS (per function)",jsPerBlock:"JS (per block)",url:"URL",type:"Type",totalBytes:"Total Bytes",unusedBytes:"Unused Bytes",usageVisualization:"Usage Visualization",codeCoverage:"Code Coverage",jsCoverageWithPerFunction:"JS coverage with per function granularity: Once a function was executed, the whole function is marked as covered.",jsCoverageWithPerBlock:"JS coverage with per block granularity: Once a block of JavaScript was executed, that block is marked as covered.",Byte:"1 byte",sBytes:"{PH1} bytes",sPercent:"{PH1} %",ByteS:"1 byte, {PH1}",sBytesS:"{PH1} bytes, {PH2}",sBytesSBelongToFunctionsThatHave:"{PH1} bytes ({PH2} %) belong to functions that have not (yet) been executed.",sBytesSBelongToBlocksOf:"{PH1} bytes ({PH2} %) belong to blocks of JavaScript that have not (yet) been executed.",sBytesSBelongToFunctionsThatHaveExecuted:"{PH1} bytes ({PH2} %) belong to functions that have executed at least once.",sBytesSBelongToBlocksOfJavascript:"{PH1} bytes ({PH2} %) belong to blocks of JavaScript that have executed at least once.",sOfFileUnusedSOfFileUsed:"{PH1} % of file unused, {PH2} % of file used"},N=f.registerUIStrings("coverage/CoverageListView.ts",H),V=f.getLocalizedString.bind(void 0,N);function D(e){const t=[];return 1&e&&t.push(V(H.css)),4&e?t.push(V(H.jsPerFunction)):2&e&&t.push(V(H.jsPerBlock)),t.join("+")}class j extends m.VBox{constructor(e){super(!0),this._nodeForCoverageInfo=new Map,this._isVisibleFilter=e,this._highlightRegExp=null,this.registerRequiredCSS("coverage/coverageListView.css",{enableLegacyPatching:!0});const t=[{id:"url",title:V(H.url),width:"250px",fixedWidth:!1,sortable:!0},{id:"type",title:V(H.type),width:"45px",fixedWidth:!0,sortable:!0},{id:"size",title:V(H.totalBytes),width:"60px",fixedWidth:!0,sortable:!0,align:_.Align.Right},{id:"unusedSize",title:V(H.unusedBytes),width:"100px",fixedWidth:!0,sortable:!0,align:_.Align.Right,sort:_.Order.Descending},{id:"bars",title:V(H.usageVisualization),width:"250px",fixedWidth:!1,sortable:!0}];this._dataGrid=new p.SortableDataGrid({displayName:V(H.codeCoverage),columns:t,editCallback:void 0,refreshCallback:void 0,deleteCallback:void 0}),this._dataGrid.setResizeMethod(_.ResizeMethod.Last),this._dataGrid.element.classList.add("flex-auto"),this._dataGrid.element.addEventListener("keydown",this._onKeyDown.bind(this),!1),this._dataGrid.addEventListener(_.Events.OpenedNode,this._onOpenedNode,this),this._dataGrid.addEventListener(_.Events.SortingChanged,this._sortingChanged,this);const o=this._dataGrid.asWidget();o.show(this.contentElement),this.setDefaultFocusedChild(o)}update(e){let t=!1;const o=e.reduce(((e,t)=>Math.max(e,t.size())),0),s=this._dataGrid.rootNode();for(const i of e){let e=this._nodeForCoverageInfo.get(i);e?this._isVisibleFilter(e._coverageInfo)&&(t=e._refreshIfNeeded(o)||t):(e=new G(i,o),this._nodeForCoverageInfo.set(i,e),this._isVisibleFilter(e._coverageInfo)&&(s.appendChild(e),t=!0))}t&&this._sortingChanged()}reset(){this._nodeForCoverageInfo.clear(),this._dataGrid.rootNode().removeChildren()}updateFilterAndHighlight(e){this._highlightRegExp=e;let t=!1;for(const e of this._nodeForCoverageInfo.values()){const o=this._isVisibleFilter(e._coverageInfo),s=Boolean(e.parent);o&&e._setHighlight(this._highlightRegExp),o!==s&&(t=!0,o?this._dataGrid.rootNode().appendChild(e):e.remove())}t&&this._sortingChanged()}selectByUrl(e){for(const[t,o]of this._nodeForCoverageInfo.entries())if(t.url()===e){o.revealAndSelect();break}}_onOpenedNode(){this._revealSourceForSelectedNode()}_onKeyDown(e){"Enter"===e.key&&(e.consume(!0),this._revealSourceForSelectedNode())}async _revealSourceForSelectedNode(){const e=this._dataGrid.selectedNode;if(!e)return;const o=e._coverageInfo;let s=T.WorkspaceImpl.instance().uiSourceCodeForURL(o.url());if(!s)return;s=(await v.SourceFormatter.instance().format(s)).formattedSourceCode,this._dataGrid.selectedNode===e&&t.reveal(s)}_sortingChanged(){const e=this._dataGrid.sortColumnId();if(!e)return;const t=G.sortFunctionForColumn(e);t&&this._dataGrid.sortNodes(t,!this._dataGrid.isSortOrderAscending())}}class G extends p.SortableDataGridNode{constructor(e,t){super(),this._coverageInfo=e,this._url=e.url(),this._maxSize=t,this._highlightRegExp=null}_setHighlight(e){this._highlightRegExp!==e&&(this._highlightRegExp=e,this.refresh())}_refreshIfNeeded(e){return(this._lastUsedSize!==this._coverageInfo.usedSize()||e!==this._maxSize)&&(this._lastUsedSize=this._coverageInfo.usedSize(),this._maxSize=e,this.refresh(),!0)}createCell(e){const t=this.createTD(e);switch(e){case"url":{S.Tooltip.install(t,this._url);const o=t.createChild("div","url-outer"),s=o.createChild("div","url-prefix"),i=o.createChild("div","url-suffix"),n=/^(.*)(\/[^/]*)$/.exec(this._url);s.textContent=n?n[1]:this._url,i.textContent=n?n[2]:"",this._highlightRegExp&&this._highlight(o,this._url),this.setCellAccessibleName(this._url,t,e);break}case"type":t.textContent=D(this._coverageInfo.type()),4&this._coverageInfo.type()?S.Tooltip.install(t,V(H.jsCoverageWithPerFunction)):2&this._coverageInfo.type()&&S.Tooltip.install(t,V(H.jsCoverageWithPerBlock));break;case"size":{t.createChild("span").textContent=Number.withThousandsSeparator(this._coverageInfo.size()||0);const o=1===this._coverageInfo.size()?V(H.Byte):V(H.sBytes,{PH1:this._coverageInfo.size()||0});this.setCellAccessibleName(o,t,e);break}case"unusedSize":{const o=this._coverageInfo.unusedSize()||0,s=t.createChild("span"),i=t.createChild("span","percent-value");s.textContent=Number.withThousandsSeparator(o);const n=V(H.sPercent,{PH1:this._percentageString(this._coverageInfo.unusedPercentage())});i.textContent=n;const r=1===o?V(H.ByteS,{PH1:n}):V(H.sBytesS,{PH1:o,PH2:n});this.setCellAccessibleName(r,t,e);break}case"bars":{const o=t.createChild("div","bar-container"),s=this._percentageString(this._coverageInfo.unusedPercentage()),i=this._percentageString(this._coverageInfo.usedPercentage());if(this._coverageInfo.unusedSize()>0){const e=o.createChild("div","bar bar-unused-size");e.style.width=(this._coverageInfo.unusedSize()/this._maxSize*100||0)+"%",4&this._coverageInfo.type()?S.Tooltip.install(e,V(H.sBytesSBelongToFunctionsThatHave,{PH1:this._coverageInfo.unusedSize(),PH2:s})):2&this._coverageInfo.type()&&S.Tooltip.install(e,V(H.sBytesSBelongToBlocksOf,{PH1:this._coverageInfo.unusedSize(),PH2:s}))}if(this._coverageInfo.usedSize()>0){const e=o.createChild("div","bar bar-used-size");e.style.width=(this._coverageInfo.usedSize()/this._maxSize*100||0)+"%",4&this._coverageInfo.type()?S.Tooltip.install(e,V(H.sBytesSBelongToFunctionsThatHaveExecuted,{PH1:this._coverageInfo.usedSize(),PH2:i})):2&this._coverageInfo.type()&&S.Tooltip.install(e,V(H.sBytesSBelongToBlocksOfJavascript,{PH1:this._coverageInfo.usedSize(),PH2:i}))}this.setCellAccessibleName(V(H.sOfFileUnusedSOfFileUsed,{PH1:s,PH2:i}),t,e)}}return t}_percentageString(e){return e.toFixed(1)}_highlight(e,t){if(!this._highlightRegExp)return;const o=this._highlightRegExp.exec(t);if(!o||!o.length)return;const s=new g.SourceRange(o.index,o[0].length);C.highlightRangesWithStyleClass(e,[s],"filter-highlight")}static sortFunctionForColumn(e){const t=(e,t)=>e._url.localeCompare(t._url);switch(e){case"url":return t;case"type":return(e,o)=>{const s=D(e._coverageInfo.type()),i=D(o._coverageInfo.type());return s.localeCompare(i)||t(e,o)};case"size":return(e,o)=>e._coverageInfo.size()-o._coverageInfo.size()||t(e,o);case"bars":case"unusedSize":return(e,o)=>e._coverageInfo.unusedSize()-o._coverageInfo.unusedSize()||t(e,o);default:return console.assert(!1,"Unknown sort field: "+e),null}}}var W=Object.freeze({__proto__:null,UIStrings:H,coverageTypeToString:D,CoverageListView:j,GridNode:G});class J{constructor(e){this._coverageModel=e,this._textByProvider=new Map,this._uiSourceCodeByContentProvider=new i.Multimap;for(const e of T.WorkspaceImpl.instance().uiSourceCodes())e.addLineDecoration(0,"coverage",this);T.WorkspaceImpl.instance().addEventListener(T.Events.UISourceCodeAdded,this._onUISourceCodeAdded,this)}reset(){for(const e of T.WorkspaceImpl.instance().uiSourceCodes())e.removeDecorationsForType("coverage")}dispose(){this.reset(),T.WorkspaceImpl.instance().removeEventListener(T.Events.UISourceCodeAdded,this._onUISourceCodeAdded,this)}update(e){for(const t of e)for(const e of this._uiSourceCodeByContentProvider.get(t.contentProvider()))e.removeDecorationsForType("coverage"),e.addLineDecoration(0,"coverage",this)}async usageByLine(e){const t=[],{content:o}=await e.requestContent();if(!o)return[];const s=new u.Text(o);await this._updateTexts(e,s);const i=s.lineEndings();for(let o=0;o<s.lineCount();++o){const s=i[o]-(o?i[o-1]:0)-1;if(!s){t.push(void 0);continue}const n=this._rawLocationsForSourceLocation(e,o,0),r=this._rawLocationsForSourceLocation(e,o,s),[a,c]=await Promise.all([n,r]);let l=void 0;for(let e=0,t=0;e<a.length;++e){const o=a[e];for(;t<c.length&&J._compareLocations(o,c[t])>=0;)++t;if(t>=c.length||c[t].id!==o.id)continue;const s=c[t++],i=this._textByProvider.get(s.contentProvider);if(!i)continue;const n=i.value();let r=Math.min(i.offsetFromPosition(o.line,o.column),n.length-1),d=Math.min(i.offsetFromPosition(s.line,s.column),n.length-1);for(;r<=d&&/\s/.test(n[r]);)++r;for(;r<=d&&/\s/.test(n[d]);)--d;if(r<=d&&(l=this._coverageModel.usageForRange(s.contentProvider,r,d)),l)break}t.push(l)}return t}async _updateTexts(e,t){const o=[];for(let s=0;s<t.lineCount();++s)for(const t of await this._rawLocationsForSourceLocation(e,s,0))this._textByProvider.has(t.contentProvider)||(this._textByProvider.set(t.contentProvider,null),this._uiSourceCodeByContentProvider.set(t.contentProvider,e),o.push(this._updateTextForProvider(t.contentProvider)));await Promise.all(o)}async _updateTextForProvider(e){const{content:t}=await e.requestContent();this._textByProvider.set(e,new u.Text(t||""))}async _rawLocationsForSourceLocation(e,t,o){const s=[],i=e.contentType();if(i.hasScripts()){let n=await w.DebuggerWorkspaceBinding.instance().uiLocationToRawLocations(e,t,o);n=n.filter((e=>Boolean(e.script())));for(const e of n){const t=e.script();t&&(t.isInlineScript()&&i.isDocument()&&(e.lineNumber-=t.lineOffset,e.lineNumber||(e.columnNumber-=t.columnOffset)),s.push({id:"js:"+e.scriptId,contentProvider:t,line:e.lineNumber,column:e.columnNumber}))}}if(i.isStyleSheet()||i.isDocument()){const n=x.CSSWorkspaceBinding.instance().uiLocationToRawLocations(new P.UILocation(e,t,o));for(const e of n){const t=e.header();t&&(t.isInline&&i.isDocument()&&(e.lineNumber-=t.startLine,e.lineNumber||(e.columnNumber-=t.startColumn)),s.push({id:"css:"+e.styleSheetId,contentProvider:t,line:e.lineNumber,column:e.columnNumber}))}}return s.sort(J._compareLocations)}static _compareLocations(e,t){return e.id.localeCompare(t.id)||e.line-t.line||e.column-t.column}_onUISourceCodeAdded(e){e.data.addLineDecoration(0,"coverage",this)}}var $=Object.freeze({__proto__:null,decoratorType:"coverage",CoverageDecorationManager:J});const q={chooseCoverageGranularityPer:"Choose coverage granularity: Per function has low overhead, per block has significant overhead.",perFunction:"Per function",perBlock:"Per block",clearAll:"Clear all",export:"Export...",urlFilter:"URL filter",filterCoverageByType:"Filter coverage by type",all:"All",css:"CSS",javascript:"JavaScript",includeExtensionContentScripts:"Include extension content scripts",contentScripts:"Content scripts",clickTheReloadButtonSToReloadAnd:"Click the reload button {PH1} to reload and start capturing coverage.",clickTheRecordButtonSToStart:"Click the record button {PH1} to start capturing coverage.",filteredSTotalS:"Filtered: {PH1}  Total: {PH2}",sOfSSUsedSoFarSUnused:"{PH1} of {PH2} ({PH3}%) used so far, {PH4} unused."},Y=f.registerUIStrings("coverage/CoverageView.ts",q),K=f.getLocalizedString.bind(void 0,Y);let X,Q,Z;class ee extends m.VBox{constructor(){super(!0),this._model=null,this._decorationManager=null,this._resourceTreeModel=null,this.registerRequiredCSS("coverage/coverageView.css",{enableLegacyPatching:!0});const e=this.contentElement.createChild("div","coverage-toolbar-container"),t=new y.Toolbar("coverage-toolbar",e);this._coverageTypeComboBox=new y.ToolbarComboBox(this._onCoverageTypeComboBoxSelectionChanged.bind(this),K(q.chooseCoverageGranularityPer));const s=[{label:K(q.perFunction),value:6},{label:K(q.perBlock),value:2}];for(const e of s)this._coverageTypeComboBox.addOption(this._coverageTypeComboBox.createOption(e.label,""+e.value));this._coverageTypeComboBoxSetting=o.Settings.instance().createSetting("coverageViewCoverageType",0),this._coverageTypeComboBox.setSelectedIndex(this._coverageTypeComboBoxSetting.get()),this._coverageTypeComboBox.setEnabled(!0),t.appendToolbarItem(this._coverageTypeComboBox),this._toggleRecordAction=b.ActionRegistry.instance().action("coverage.toggle-recording"),this._toggleRecordButton=y.Toolbar.createActionButton(this._toggleRecordAction),t.appendToolbarItem(this._toggleRecordButton);const i=a.TargetManager.instance().mainTarget(),n=i&&i.model(h.ResourceTreeModel);if(this._inlineReloadButton=null,n){const e=b.ActionRegistry.instance().action("coverage.start-with-reload");this._startWithReloadButton=y.Toolbar.createActionButton(e),t.appendToolbarItem(this._startWithReloadButton),this._toggleRecordButton.setEnabled(!1),this._toggleRecordButton.setVisible(!1)}this._clearButton=new y.ToolbarButton(K(q.clearAll),"largeicon-clear"),this._clearButton.addEventListener(y.ToolbarButton.Events.Click,this._clear.bind(this)),t.appendToolbarItem(this._clearButton),t.appendSeparator(),this._saveButton=new y.ToolbarButton(K(q.export),"largeicon-download"),this._saveButton.addEventListener(y.ToolbarButton.Events.Click,(e=>{this._exportReport()})),t.appendToolbarItem(this._saveButton),this._saveButton.setEnabled(!1),this._textFilterRegExp=null,t.appendSeparator(),this._filterInput=new y.ToolbarInput(K(q.urlFilter),"",.4,1),this._filterInput.setEnabled(!1),this._filterInput.addEventListener(y.ToolbarInput.Event.TextChanged,this._onFilterChanged,this),t.appendToolbarItem(this._filterInput),t.appendSeparator(),this._typeFilterValue=null,this._filterByTypeComboBox=new y.ToolbarComboBox(this._onFilterByTypeChanged.bind(this),K(q.filterCoverageByType));const r=[{label:K(q.all),value:""},{label:K(q.css),value:1},{label:K(q.javascript),value:6}];for(const e of r)this._filterByTypeComboBox.addOption(this._filterByTypeComboBox.createOption(e.label,""+e.value));this._filterByTypeComboBox.setSelectedIndex(0),this._filterByTypeComboBox.setEnabled(!1),t.appendToolbarItem(this._filterByTypeComboBox),t.appendSeparator(),this._showContentScriptsSetting=o.Settings.instance().createSetting("showContentScripts",!1),this._showContentScriptsSetting.addChangeListener(this._onFilterChanged,this),this._contentScriptsCheckbox=new y.ToolbarSettingCheckbox(this._showContentScriptsSetting,K(q.includeExtensionContentScripts),K(q.contentScripts)),this._contentScriptsCheckbox.setEnabled(!1),t.appendToolbarItem(this._contentScriptsCheckbox),this._coverageResultsElement=this.contentElement.createChild("div","coverage-results"),this._landingPage=this._buildLandingPage(),this._listView=new j(this._isVisible.bind(this,!1)),this._statusToolbarElement=this.contentElement.createChild("div","coverage-toolbar-summary"),this._statusMessageElement=this._statusToolbarElement.createChild("div","coverage-message"),this._landingPage.show(this._coverageResultsElement)}static instance(){return X||(X=new ee),X}_buildLandingPage(){const e=new m.VBox;let t;if(this._startWithReloadButton)this._inlineReloadButton=C.createInlineButton(y.Toolbar.createActionButtonForId("coverage.start-with-reload")),t=f.getFormatLocalizedString(Y,q.clickTheReloadButtonSToReloadAnd,{PH1:this._inlineReloadButton});else{const e=C.createInlineButton(y.Toolbar.createActionButton(this._toggleRecordAction));t=f.getFormatLocalizedString(Y,q.clickTheRecordButtonSToStart,{PH1:e})}return t.classList.add("message"),e.contentElement.appendChild(t),e.element.classList.add("landing-page"),e}_clear(){this._model&&this._model.reset(),this._reset()}_reset(){this._decorationManager&&(this._decorationManager.dispose(),this._decorationManager=null),this._listView.reset(),this._listView.detach(),this._landingPage.show(this._coverageResultsElement),this._statusMessageElement.textContent="",this._filterInput.setEnabled(!1),this._filterByTypeComboBox.setEnabled(!1),this._contentScriptsCheckbox.setEnabled(!1),this._saveButton.setEnabled(!1)}_toggleRecording(){!this._toggleRecordAction.toggled()?this._startRecording({reload:!1,jsCoveragePerBlock:this.isBlockCoverageSelected()}):this.stopRecording()}isBlockCoverageSelected(){const e=this._coverageTypeComboBox.selectedOption();return 2===Number(e?e.value:Number.NaN)}_selectCoverageType(e){const t=e?1:0;this._coverageTypeComboBox.setSelectedIndex(t)}_onCoverageTypeComboBoxSelectionChanged(){this._coverageTypeComboBoxSetting.set(this._coverageTypeComboBox.selectedIndex())}async ensureRecordingStarted(){this._toggleRecordAction.toggled()&&await this.stopRecording(),await this._startRecording({reload:!1,jsCoveragePerBlock:!1})}async _startRecording(e){let t,o;this._startWithReloadButton&&this._startWithReloadButton.element.hasFocus()||this._inlineReloadButton&&this._inlineReloadButton.hasFocus()?o=!0:this.hasFocus()&&(t=!0),this._reset();const s=a.TargetManager.instance().mainTarget();if(!s)return;const{reload:i,jsCoveragePerBlock:n}={reload:!1,jsCoveragePerBlock:!1,...e};if(this._model&&!i||(this._model=s.model(F)),!this._model)return;I.actionTaken(E.Action.CoverageStarted),n&&I.actionTaken(E.Action.CoverageStartedPerBlock);await this._model.start(Boolean(n))&&(this._selectCoverageType(Boolean(n)),this._model.addEventListener(M.CoverageUpdated,this._onCoverageDataReceived,this),this._resourceTreeModel=s.model(h.ResourceTreeModel),this._resourceTreeModel&&this._resourceTreeModel.addEventListener(h.Events.MainFrameNavigated,this._onMainFrameNavigated,this),this._decorationManager=new J(this._model),this._toggleRecordAction.setToggled(!0),this._clearButton.setEnabled(!1),this._startWithReloadButton&&(this._startWithReloadButton.setEnabled(!1),this._startWithReloadButton.setVisible(!1),this._toggleRecordButton.setEnabled(!0),this._toggleRecordButton.setVisible(!0),o&&this._toggleRecordButton.focus()),this._coverageTypeComboBox.setEnabled(!1),this._filterInput.setEnabled(!0),this._filterByTypeComboBox.setEnabled(!0),this._contentScriptsCheckbox.setEnabled(!0),this._landingPage.isShowing()&&this._landingPage.detach(),this._listView.show(this._coverageResultsElement),t&&!o&&this._listView.focus(),i&&this._resourceTreeModel?this._resourceTreeModel.reloadPage():this._model.startPolling())}_onCoverageDataReceived(e){const t=e.data;this._updateViews(t)}async stopRecording(){this._resourceTreeModel&&(this._resourceTreeModel.removeEventListener(h.Events.MainFrameNavigated,this._onMainFrameNavigated,this),this._resourceTreeModel=null),this.hasFocus()&&this._listView.focus(),this._model&&(await this._model.stop(),this._model.removeEventListener(M.CoverageUpdated,this._onCoverageDataReceived,this)),this._toggleRecordAction.setToggled(!1),this._coverageTypeComboBox.setEnabled(!0),this._startWithReloadButton&&(this._startWithReloadButton.setEnabled(!0),this._startWithReloadButton.setVisible(!0),this._toggleRecordButton.setEnabled(!1),this._toggleRecordButton.setVisible(!1)),this._clearButton.setEnabled(!0)}processBacklog(){this._model&&this._model.processJSBacklog()}_onMainFrameNavigated(){this._model&&this._model.reset(),this._decorationManager&&this._decorationManager.reset(),this._listView.reset(),this._model&&this._model.startPolling()}_updateViews(e){this._updateStats(),this._listView.update(this._model&&this._model.entries()||[]),this._saveButton.setEnabled(null!==this._model&&this._model.entries().length>0),this._decorationManager&&this._decorationManager.update(e)}_updateStats(){const e={total:0,unused:0},t={total:0,unused:0};let o=!1;if(this._model)for(const s of this._model.entries())e.total+=s.size(),e.unused+=s.unusedSize(),this._isVisible(!1,s)?(t.total+=s.size(),t.unused+=s.unusedSize()):o=!0;function s({total:e,unused:t}){const o=e-t,s=e?Math.round(100*o/e):0;return K(q.sOfSSUsedSoFarSUnused,{PH1:n.bytesToString(o),PH2:n.bytesToString(e),PH3:s,PH4:n.bytesToString(t)})}this._statusMessageElement.textContent=o?K(q.filteredSTotalS,{PH1:s(t),PH2:s(e)}):s(e)}_onFilterChanged(){if(!this._listView)return;const e=this._filterInput.value();this._textFilterRegExp=e?createPlainTextSearchRegex(e,"i"):null,this._listView.updateFilterAndHighlight(this._textFilterRegExp),this._updateStats()}_onFilterByTypeChanged(){if(!this._listView)return;I.actionTaken(E.Action.CoverageReportFiltered);const e=this._filterByTypeComboBox.selectedOption(),t=e&&e.value;this._typeFilterValue=parseInt(t||"",10)||null,this._listView.updateFilterAndHighlight(this._textFilterRegExp),this._updateStats()}_isVisible(e,t){const o=t.url();return!o.startsWith(ee.EXTENSION_BINDINGS_URL_PREFIX)&&(!(t.isContentScript()&&!this._showContentScriptsSetting.get())&&(!(this._typeFilterValue&&!(t.type()&this._typeFilterValue))&&(e||!this._textFilterRegExp||this._textFilterRegExp.test(o))))}async _exportReport(){const e=new R.FileOutputStream,t=`Coverage-${r.toISO8601Compact(new Date)}.json`;await e.open(t)&&this._model&&this._model.exportReport(e)}selectCoverageItemByUrl(e){this._listView.selectByUrl(e)}}ee.EXTENSION_BINDINGS_URL_PREFIX="extensions::";class te{handleAction(e,t){const o="coverage";return B.ViewManager.instance().showView(o,!1,!0).then((()=>{const e=B.ViewManager.instance().view(o);return e&&e.widget()})).then((e=>this._innerHandleAction(e,t))),!0}static instance(e={forceNew:null}){const{forceNew:t}=e;return Q&&!t||(Q=new te),Q}_innerHandleAction(e,t){switch(t){case"coverage.toggle-recording":e._toggleRecording();break;case"coverage.start-with-reload":e._startRecording({reload:!0,jsCoveragePerBlock:e.isBlockCoverageSelected()});break;default:console.assert(!1,"Unknown action: "+t)}}}class oe{constructor(){this._listeners=new WeakMap}static instance({forceNew:e}={forceNew:!1}){return Z&&!e||(Z=new oe),Z}decorate(e,t){const o=e.decorationsForType("coverage");if(!o||!o.size)return void this._uninstallGutter(t);o.values().next().value.data().usageByLine(e).then((o=>{t.operation((()=>this._innerDecorate(e,t,o)))}))}_innerDecorate(e,t,o){const s=oe.GUTTER_TYPE;this._uninstallGutter(t),o.length&&this._installGutter(t,e.url());for(let e=0;e<o.length;++e){if("boolean"!=typeof o[e])continue;const i=o[e]?"text-editor-coverage-used-marker":"text-editor-coverage-unused-marker",n=document.createElement("div");n.classList.add(i),t.setGutterDecoration(e,s,n)}}makeGutterClickHandler(e){return function(t){if(t.data.gutterType!==oe.GUTTER_TYPE)return;const o="coverage";B.ViewManager.instance().showView(o).then((()=>{const e=B.ViewManager.instance().view(o);return e&&e.widget()})).then((t=>{const o=e.match(/(.*):formatted$/),s=o&&o[1]||e;t.selectCoverageItemByUrl(s)}))}}_installGutter(e,t){let o=this._listeners.get(e);o||(o=this.makeGutterClickHandler(t),this._listeners.set(e,o)),e.installGutter(oe.GUTTER_TYPE,!1),e.addEventListener(k.Events.GutterClick,o,this)}_uninstallGutter(e){e.uninstallGutter(oe.GUTTER_TYPE);const t=this._listeners.get(e);t&&(e.removeEventListener(k.Events.GutterClick,t,this),this._listeners.delete(e))}}oe.GUTTER_TYPE="CodeMirror-gutter-coverage",L.registerLineDecorator({lineDecorator:oe.instance,decoratorType:L.DecoratorType.COVERAGE});var se=Object.freeze({__proto__:null,UIStrings:q,CoverageView:ee,ActionDelegate:te,LineDecorator:oe});export{$ as CoverageDecorationManager,W as CoverageListView,O as CoverageModel,se as CoverageView};
