import{i18n as e}from"../i18n/i18n.js";import{SDKModel as t,ResourceTreeModel as i,NetworkManager as s}from"../sdk/sdk.js";import{ResourceType as r,ParsedURL as n,EventTarget as o}from"../common/common.js";import{InspectorFrontendHost as c}from"../host/host.js";import{NetworkLogView as a,NetworkPanel as l}from"../network/network.js";import{Panel as u,UIUtils as h,ARIAUtils as d,TreeOutline as S,Widget as y,Tooltip as g}from"../ui/ui.js";const p={theSecurityOfThisPageIsUnknown:"The security of this page is unknown.",thisPageIsNotSecure:"This page is not secure.",thisPageIsSecureValidHttps:"This page is secure (valid HTTPS).",thisPageIsNotSecureBrokenHttps:"This page is not secure (broken HTTPS).",cipherWithMAC:"{PH1} with {PH2}",keyExchangeWithGroup:"{PH1} with {PH2}"},m=e.registerUIStrings("security/SecurityModel.ts",p),C=e.getLocalizedString.bind(void 0,m);class w extends t.SDKModel{constructor(e){super(e),this._dispatcher=new E(this),this._securityAgent=e.securityAgent(),e.registerSecurityDispatcher(this._dispatcher),this._securityAgent.invoke_enable()}resourceTreeModel(){return this.target().model(i.ResourceTreeModel)}networkManager(){return this.target().model(s.NetworkManager)}static SecurityStateComparator(e,t){const i=v();return(e&&i.get(e)||0)-(t&&i.get(t)||0)}}let f=null;const v=()=>{if(!f){f=new Map;const e=[Protocol.Security.SecurityState.Info,Protocol.Security.SecurityState.InsecureBroken,Protocol.Security.SecurityState.Insecure,Protocol.Security.SecurityState.Neutral,Protocol.Security.SecurityState.Secure,Protocol.Security.SecurityState.Unknown];for(let t=0;t<e.length;t++)f.set(e[t],t+1)}return f};var P;t.SDKModel.register(w,t.Capability.Security,!1),function(e){e.SecurityStateChanged="SecurityStateChanged",e.VisibleSecurityStateChanged="VisibleSecurityStateChanged"}(P||(P={}));const x={[Protocol.Security.SecurityState.Unknown]:C(p.theSecurityOfThisPageIsUnknown),[Protocol.Security.SecurityState.Insecure]:C(p.thisPageIsNotSecure),[Protocol.Security.SecurityState.Neutral]:C(p.thisPageIsNotSecure),[Protocol.Security.SecurityState.Secure]:C(p.thisPageIsSecureValidHttps),[Protocol.Security.SecurityState.InsecureBroken]:C(p.thisPageIsNotSecureBrokenHttps)};class _{constructor(e,t,i){this.securityState=e,this.explanations=t,this.summary=i}}class T{constructor(e,t,i,s){this.securityState=e,this.certificateSecurityState=t?new k(t):null,this.safetyTipInfo=i?new b(i):null,this.securityStateIssueIds=s}}class k{constructor(e){this.protocol=e.protocol,this.keyExchange=e.keyExchange,this.keyExchangeGroup=e.keyExchangeGroup||null,this.cipher=e.cipher,this.mac=e.mac||null,this.certificate=e.certificate,this.subjectName=e.subjectName,this.issuer=e.issuer,this.validFrom=e.validFrom,this.validTo=e.validTo,this.certificateNetworkError=e.certificateNetworkError||null,this.certificateHasWeakSignature=e.certificateHasWeakSignature,this.certificateHasSha1Signature=e.certificateHasSha1Signature,this.modernSSL=e.modernSSL,this.obsoleteSslProtocol=e.obsoleteSslProtocol,this.obsoleteSslKeyExchange=e.obsoleteSslKeyExchange,this.obsoleteSslCipher=e.obsoleteSslCipher,this.obsoleteSslSignature=e.obsoleteSslSignature}isCertificateExpiringSoon(){const e=new Date(1e3*this.validTo).getTime();return e<new Date(Date.now()).setHours(48)&&e>Date.now()}getKeyExchangeName(){return this.keyExchangeGroup?this.keyExchange?C(p.keyExchangeWithGroup,{PH1:this.keyExchange,PH2:this.keyExchangeGroup}):this.keyExchangeGroup:this.keyExchange}getCipherFullName(){return this.mac?C(p.cipherWithMAC,{PH1:this.cipher,PH2:this.mac}):this.cipher}}class b{constructor(e){this.safetyTipStatus=e.safetyTipStatus,this.safeUrl=e.safeUrl||null}}class I{constructor(e,t,i,s,r=[],n=Protocol.Security.MixedContentType.None,o=[]){this.securityState=e,this.title=t,this.summary=i,this.description=s,this.certificate=r,this.mixedContentType=n,this.recommendations=o}}class E{constructor(e){this._model=e}securityStateChanged({securityState:e,explanations:t,summary:i}){const s=new _(e,t,i||null);this._model.dispatchEventToListeners(P.SecurityStateChanged,s)}visibleSecurityStateChanged({visibleSecurityState:e}){const t=new T(e.securityState,e.certificateSecurityState||null,e.safetyTipInfo||null,e.securityStateIssueIds);this._model.dispatchEventToListeners(P.VisibleSecurityStateChanged,t)}certificateError(e){}}var L=Object.freeze({__proto__:null,UIStrings:p,SecurityModel:w,get Events(){return P},SummaryMessages:x,PageSecurityState:_,PageVisibleSecurityState:T,CertificateSecurityState:k,SecurityStyleExplanation:I});const M={overview:"Overview",mainOrigin:"Main origin",nonsecureOrigins:"Non-secure origins",secureOrigins:"Secure origins",unknownCanceled:"Unknown / canceled",reloadToViewDetails:"Reload to view details",mainOriginSecure:"Main origin (secure)",mainOriginNonsecure:"Main origin (non-secure)",securityOverview:"Security overview",secure:"Secure",info:"Info",notSecure:"Not secure",viewCertificate:"View certificate",theSecurityOfThisPageIsUnknown:"The security of this page is unknown.",thisPageIsNotSecure:"This page is not secure.",thisPageIsSecureValidHttps:"This page is secure (valid HTTPS).",thisPageIsNotSecureBrokenHttps:"This page is not secure (broken HTTPS).",notSecureBroken:"Not secure (broken)",thisPageIsDangerousFlaggedBy:"This page is dangerous (flagged by Google Safe Browsing).",flaggedByGoogleSafeBrowsing:"Flagged by Google Safe Browsing",toCheckThisPagesStatusVisit:"To check this page's status, visit g.co/safebrowsingstatus.",thisIsAnErrorPage:"This is an error page.",thisPageIsInsecureUnencrypted:"This page is insecure (unencrypted HTTP).",formFieldEditedOnANonsecurePage:"Form field edited on a non-secure page",dataWasEnteredInAFieldOnA:"Data was entered in a field on a non-secure page. A warning has been added to the URL bar.",thisPageHasANonhttpsSecureOrigin:"This page has a non-HTTPS secure origin.",thisPageIsSuspicious:"This page is suspicious",chromeHasDeterminedThatThisSiteS:"Chrome has determined that this site could be fake or fraudulent.",ifYouBelieveThisIsShownIn:"If you believe this is shown in error please visit https://bugs.chromium.org/p/chromium/issues/entry?template=Safety+Tips+Appeals.",possibleSpoofingUrl:"Possible spoofing URL",thisSitesHostnameLooksSimilarToP:"This site's hostname looks similar to {PH1}. Attackers sometimes mimic sites by making small, hard-to-see changes to the domain name.",ifYouBelieveThisIsShownInErrorSafety:"If you believe this is shown in error please visit https://bugs.chromium.org/p/chromium/issues/entry?template=Safety+Tips+Appeals.",thisPageIsSuspiciousFlaggedBy:"This page is suspicious (flagged by Chrome).",certificate:"Certificate",insecureSha:"insecure (SHA-1)",theCertificateChainForThisSite:"The certificate chain for this site contains a certificate signed using SHA-1.",subjectAlternativeNameMissing:"`Subject Alternative Name` missing",theCertificateForThisSiteDoesNot:"The certificate for this site does not contain a `Subject Alternative Name` extension containing a domain name or IP address.",missing:"missing",thisSiteIsMissingAValidTrusted:"This site is missing a valid, trusted certificate ({PH1}).",validAndTrusted:"valid and trusted",theConnectionToThisSiteIsUsingA:"The connection to this site is using a valid, trusted server certificate issued by {PH1}.",publickeypinningBypassed:"Public-Key-Pinning bypassed",publickeypinningWasBypassedByA:"Public-Key-Pinning was bypassed by a local root certificate.",certificateExpiresSoon:"Certificate expires soon",theCertificateForThisSiteExpires:"The certificate for this site expires in less than 48 hours and needs to be renewed.",connection:"Connection",secureConnectionSettings:"secure connection settings",theConnectionToThisSiteIs:"The connection to this site is encrypted and authenticated using {PH1}, {PH2}, and {PH3}.",sIsObsoleteEnableTlsOrLater:"{PH1} is obsolete. Enable TLS 1.2 or later.",rsaKeyExchangeIsObsoleteEnableAn:"RSA key exchange is obsolete. Enable an ECDHE-based cipher suite.",sIsObsoleteEnableAnAesgcmbased:"{PH1} is obsolete. Enable an AES-GCM-based cipher suite.",theServerSignatureUsesShaWhichIs:"The server signature uses SHA-1, which is obsolete. Enable a SHA-2 signature algorithm instead. (Note this is different from the signature in the certificate.)",obsoleteConnectionSettings:"obsolete connection settings",resources:"Resources",activeMixedContent:"active mixed content",youHaveRecentlyAllowedNonsecure:"You have recently allowed non-secure content (such as scripts or iframes) to run on this site.",mixedContent:"mixed content",thisPageIncludesHttpResources:"This page includes HTTP resources.",nonsecureForm:"non-secure form",thisPageIncludesAFormWithA:'This page includes a form with a non-secure "action" attribute.',activeContentWithCertificate:"active content with certificate errors",youHaveRecentlyAllowedContent:"You have recently allowed content loaded with certificate errors (such as scripts or iframes) to run on this site.",contentWithCertificateErrors:"content with certificate errors",thisPageIncludesResourcesThat:"This page includes resources that were loaded with certificate errors.",allServedSecurely:"all served securely",allResourcesOnThisPageAreServed:"All resources on this page are served securely.",blockedMixedContent:"Blocked mixed content",yourPageRequestedNonsecure:"Your page requested non-secure resources that were blocked.",reloadThePageToRecordRequestsFor:"Reload the page to record requests for HTTP resources.",viewDRequestInNetworkPanel:"View 1 request in Network Panel",viewDRequestsInNetworkPanel:"View {PH1} requests in Network Panel",origin:"Origin",viewRequestsInNetworkPanel:"View requests in Network Panel",protocol:"Protocol",keyExchange:"Key exchange",keyExchangeGroup:"Key exchange group",cipher:"Cipher",certificateTransparency:"Certificate Transparency",subject:"Subject",san:"`SAN`",validFrom:"Valid from",validUntil:"Valid until",issuer:"Issuer",openFullCertificateDetails:"Open full certificate details",sct:"SCT",logName:"Log name",logId:"Log ID",validationStatus:"Validation status",source:"Source",issuedAt:"Issued at",hashAlgorithm:"Hash algorithm",signatureAlgorithm:"Signature algorithm",signatureData:"Signature data",showFullDetails:"Show full details",hideFullDetails:"Hide full details",thisRequestCompliesWithChromes:"This request complies with `Chrome`'s Certificate Transparency policy.",thisRequestDoesNotComplyWith:"This request does not comply with `Chrome`'s Certificate Transparency policy.",thisResponseWasLoadedFromCache:"This response was loaded from cache. Some security details might be missing.",theSecurityDetailsAboveAreFrom:"The security details above are from the first inspected response.",thisOriginIsANonhttpsSecure:"This origin is a non-HTTPS secure origin.",yourConnectionToThisOriginIsNot:"Your connection to this origin is not secure.",noSecurityInformation:"No security information",noSecurityDetailsAreAvailableFor:"No security details are available for this origin.",na:"(n/a)",showLess:"Show less",showMoreSTotal:"Show more ({PH1} total)"},N=e.registerUIStrings("security/SecurityPanel.ts",M),A=e.getLocalizedString.bind(void 0,N);let R;class H extends u.PanelWithSidebar{constructor(){super("security"),this._mainView=new F(this);const e=document.createElement("span");e.classList.add("title"),e.textContent=A(M.overview),this._sidebarMainViewElement=new V(e,this._setVisibleView.bind(this,this._mainView),"security-main-view-sidebar-tree-item","lock-icon"),this._sidebarMainViewElement.tooltip=e.textContent,this._sidebarTree=new O(this._sidebarMainViewElement,this.showOrigin.bind(this)),this.panelSidebarElement().appendChild(this._sidebarTree.element),this._lastResponseReceivedForLoaderId=new Map,this._origins=new Map,this._filterRequestCounts=new Map,t.TargetManager.instance().observeModels(w,this),this._visibleView=null,this._eventListeners=[],this._securityModel=null}static instance(e={forceNew:null}){const{forceNew:t}=e;return R&&!t||(R=new H),R}static _instance(){return H.instance()}static createCertificateViewerButtonForOrigin(e,t){const i=h.createTextButton(e,(async e=>{e.consume();const i=await s.MultitargetNetworkManager.instance().getCertificate(t);i.length>0&&c.InspectorFrontendHostInstance.showCertificateViewer(i)}),"origin-button");return d.markAsButton(i),i}static createCertificateViewerButtonForCert(e,t){const i=h.createTextButton(e,(e=>{e.consume(),c.InspectorFrontendHostInstance.showCertificateViewer(t)}),"origin-button");return d.markAsButton(i),i}static createHighlightedUrl(e,t){const i="://",s=e.indexOf(i);if(-1===s){const t=document.createElement("span");return t.textContent=e,t}const r=document.createElement("span"),n=e.substr(0,s),o=e.substr(s+i.length);return r.createChild("span","url-scheme-"+t).textContent=n,r.createChild("span","url-scheme-separator").textContent=i,r.createChild("span").textContent=o,r}_updateSecurityState(e,t,i){this._sidebarMainViewElement.setSecurityState(e),this._mainView.updateSecurityState(e,t,i)}_onSecurityStateChanged(e){const t=e.data,i=t.securityState,s=t.explanations,r=t.summary;this._updateSecurityState(i,s,r)}_updateVisibleSecurityState(e){this._sidebarMainViewElement.setSecurityState(e.securityState),this._mainView.updateVisibleSecurityState(e)}_onVisibleSecurityStateChanged(e){const t=e.data;this._updateVisibleSecurityState(t)}selectAndSwitchToMainView(){this._sidebarMainViewElement.select(!0)}showOrigin(e){const t=this._origins.get(e);t&&(t.originView||(t.originView=new B(this,e,t)),this._setVisibleView(t.originView))}wasShown(){super.wasShown(),this._visibleView||this.selectAndSwitchToMainView()}focus(){this._sidebarTree.focus()}_setVisibleView(e){this._visibleView!==e&&(this._visibleView&&this._visibleView.detach(),this._visibleView=e,e&&this.splitWidget().setMainWidget(e))}_onResponseReceived(e){const t=e.data.request;t.resourceType()===r.resourceTypes.Document&&this._lastResponseReceivedForLoaderId.set(t.loaderId,t)}_processRequest(e){const t=n.ParsedURL.extractOrigin(e.url());if(!t)return;let i=e.securityState();e.mixedContentType!==Protocol.Security.MixedContentType.Blockable&&e.mixedContentType!==Protocol.Security.MixedContentType.OptionallyBlockable||(i=Protocol.Security.SecurityState.Insecure);const s=this._origins.get(t);if(s){const r=s.securityState;if(s.securityState=this._securityStateMin(r,i),r!==s.securityState){const r=e.securityDetails();r&&(s.securityDetails=r),this._sidebarTree.updateOrigin(t,i),s.originView&&s.originView.setSecurityState(i)}}else{const s={securityState:i,securityDetails:e.securityDetails(),loadedFromCache:e.cached(),originView:void 0};this._origins.set(t,s),this._sidebarTree.addOrigin(t,i)}}_onRequestFinished(e){const t=e.data;this._updateFilterRequestCounts(t),this._processRequest(t)}_updateFilterRequestCounts(e){if(e.mixedContentType===Protocol.Security.MixedContentType.None)return;let t=a.MixedContentFilterValues.All;e.wasBlocked()?t=a.MixedContentFilterValues.Blocked:e.mixedContentType===Protocol.Security.MixedContentType.Blockable?t=a.MixedContentFilterValues.BlockOverridden:e.mixedContentType===Protocol.Security.MixedContentType.OptionallyBlockable&&(t=a.MixedContentFilterValues.Displayed);const i=this._filterRequestCounts.get(t);i?this._filterRequestCounts.set(t,i+1):this._filterRequestCounts.set(t,1),this._mainView.refreshExplanations()}filterRequestCount(e){return this._filterRequestCounts.get(e)||0}_securityStateMin(e,t){return w.SecurityStateComparator(e,t)<0?e:t}modelAdded(e){if(this._securityModel)return;this._securityModel=e;const t=e.resourceTreeModel(),r=e.networkManager();this._eventListeners=[e.addEventListener(P.VisibleSecurityStateChanged,this._onVisibleSecurityStateChanged,this),t.addEventListener(i.Events.MainFrameNavigated,this._onMainFrameNavigated,this),t.addEventListener(i.Events.InterstitialShown,this._onInterstitialShown,this),t.addEventListener(i.Events.InterstitialHidden,this._onInterstitialHidden,this),r.addEventListener(s.Events.ResponseReceived,this._onResponseReceived,this),r.addEventListener(s.Events.RequestFinished,this._onRequestFinished,this)],t.isInterstitialShowing()&&this._onInterstitialShown()}modelRemoved(e){this._securityModel===e&&(this._securityModel=null,o.EventTarget.removeEventListeners(this._eventListeners))}_onMainFrameNavigated(e){const t=e.data,i=this._lastResponseReceivedForLoaderId.get(t.loaderId);this.selectAndSwitchToMainView(),this._sidebarTree.clearOrigins(),this._origins.clear(),this._lastResponseReceivedForLoaderId.clear(),this._filterRequestCounts.clear(),this._mainView.refreshExplanations();const s=n.ParsedURL.extractOrigin(i?i.url():t.url);this._sidebarTree.setMainOrigin(s),i&&this._processRequest(i)}_onInterstitialShown(){this.selectAndSwitchToMainView(),this._sidebarTree.toggleOriginsList(!0)}_onInterstitialHidden(){this._sidebarTree.toggleOriginsList(!1)}}class O extends S.TreeOutlineInShadow{constructor(e,t){super(),this.registerRequiredCSS("security/sidebar.css",{enableLegacyPatching:!0}),this.registerRequiredCSS("security/lockIcon.css",{enableLegacyPatching:!0}),this.appendChild(e),this._showOriginInPanel=t,this._mainOrigin=null,this._originGroupTitles=new Map([[D.MainOrigin,A(M.mainOrigin)],[D.NonSecure,A(M.nonsecureOrigins)],[D.Secure,A(M.secureOrigins)],[D.Unknown,A(M.unknownCanceled)]]),this._originGroups=new Map;for(const e of Object.values(D)){const t=this._createOriginGroupElement(this._originGroupTitles.get(e));this._originGroups.set(e,t),this.appendChild(t)}this._clearOriginGroups();const i=new S.TreeElement(A(M.reloadToViewDetails));i.selectable=!1,i.listItemElement.classList.add("security-main-view-reload-message");this._originGroups.get(D.MainOrigin).appendChild(i),this._elementsByOrigin=new Map}_originGroupTitle(e){return this._originGroupTitles.get(e)}_originGroupElement(e){return this._originGroups.get(e)}_createOriginGroupElement(e){const t=new S.TreeElement(e,!0);return t.selectable=!1,t.setCollapsible(!1),t.expand(),t.listItemElement.classList.add("security-sidebar-origins"),d.setAccessibleName(t.childrenListElement,e),t}toggleOriginsList(e){for(const t of this._originGroups.values())t.hidden=e}addOrigin(e,t){const i=new V(H.createHighlightedUrl(e,t),this._showOriginInPanel.bind(this,e),"security-sidebar-tree-item","security-property");i.tooltip=e,this._elementsByOrigin.set(e,i),this.updateOrigin(e,t)}setMainOrigin(e){this._mainOrigin=e}updateOrigin(e,t){const i=this._elementsByOrigin.get(e);let s;if(i.setSecurityState(t),e===this._mainOrigin)s=this._originGroups.get(D.MainOrigin),t===Protocol.Security.SecurityState.Secure?s.title=A(M.mainOriginSecure):s.title=A(M.mainOriginNonsecure),d.setAccessibleName(s.childrenListElement,s.title);else switch(t){case Protocol.Security.SecurityState.Secure:s=this._originGroupElement(D.Secure);break;case Protocol.Security.SecurityState.Unknown:s=this._originGroupElement(D.Unknown);break;default:s=this._originGroupElement(D.NonSecure)}const r=i.parent;r!==s&&(r&&(r.removeChild(i),0===r.childCount()&&(r.hidden=!0)),s.appendChild(i),s.hidden=!1)}_clearOriginGroups(){for(const e of this._originGroups.values())e.removeChildren(),e.hidden=!0;const e=this._originGroupElement(D.MainOrigin);e.title=this._originGroupTitle(D.MainOrigin),e.hidden=!1}clearOrigins(){this._clearOriginGroups(),this._elementsByOrigin.clear()}}var D;!function(e){e.MainOrigin="MainOrigin",e.NonSecure="NonSecure",e.Secure="Secure",e.Unknown="Unknown"}(D||(D={}));class V extends S.TreeElement{constructor(e,t,i,s){super("",!1),this._selectCallback=t,this._cssPrefix=s,this.listItemElement.classList.add(i),this._iconElement=this.listItemElement.createChild("div","icon"),this._iconElement.classList.add(this._cssPrefix),this.listItemElement.appendChild(e),this._securityState=null,this.setSecurityState(Protocol.Security.SecurityState.Unknown)}setSecurityState(e){this._securityState&&this._iconElement.classList.remove(this._cssPrefix+"-"+this._securityState),this._securityState=e,this._iconElement.classList.add(this._cssPrefix+"-"+e)}securityState(){return this._securityState}onselect(){return this._selectCallback(),!0}}class F extends y.VBox{constructor(e){super(!0),this.registerRequiredCSS("security/mainView.css",{enableLegacyPatching:!0}),this.registerRequiredCSS("security/lockIcon.css",{enableLegacyPatching:!0}),this.setMinimumSize(200,100),this.contentElement.classList.add("security-main-view"),this._panel=e,this._summarySection=this.contentElement.createChild("div","security-summary"),this._securityExplanationsMain=this.contentElement.createChild("div","security-explanation-list security-explanations-main"),this._securityExplanationsExtra=this.contentElement.createChild("div","security-explanation-list security-explanations-extra");const t=this._summarySection.createChild("div","security-summary-section-title");t.textContent=A(M.securityOverview),d.markAsHeading(t,1);const i=this._summarySection.createChild("div","lock-spectrum");this._lockSpectrum=new Map([[Protocol.Security.SecurityState.Secure,i.createChild("div","lock-icon lock-icon-secure")],[Protocol.Security.SecurityState.Neutral,i.createChild("div","lock-icon lock-icon-neutral")],[Protocol.Security.SecurityState.Insecure,i.createChild("div","lock-icon lock-icon-insecure")]]),g.Tooltip.install(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Secure),A(M.secure)),g.Tooltip.install(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Neutral),A(M.info)),g.Tooltip.install(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure),A(M.notSecure)),this._summarySection.createChild("div","triangle-pointer-container").createChild("div","triangle-pointer-wrapper").createChild("div","triangle-pointer"),this._summaryText=this._summarySection.createChild("div","security-summary-text"),d.markAsHeading(this._summaryText,2),this._explanations=null,this._securityState=null}getLockSpectrumDiv(e){const t=this._lockSpectrum.get(e);if(!t)throw new Error("Invalid argument: "+e);return t}_addExplanation(e,t){const i=e.createChild("div","security-explanation");i.classList.add("security-explanation-"+t.securityState),i.createChild("div","security-property").classList.add("security-property-"+t.securityState);const s=i.createChild("div","security-explanation-text"),r=s.createChild("div","security-explanation-title");if(t.title?(r.createChild("span").textContent=t.title+" - ",r.createChild("span","security-explanation-title-"+t.securityState).textContent=t.summary):r.textContent=t.summary,s.createChild("div").textContent=t.description,t.certificate.length&&s.appendChild(H.createCertificateViewerButtonForCert(A(M.viewCertificate),t.certificate)),t.recommendations&&t.recommendations.length){const e=s.createChild("ul","security-explanation-recommendations");for(const i of t.recommendations)e.createChild("li").textContent=i}return s}updateSecurityState(e,t,i){this._summarySection.classList.remove("security-summary-"+this._securityState),this._securityState=e,this._summarySection.classList.add("security-summary-"+this._securityState);const s=new Map([[Protocol.Security.SecurityState.Unknown,A(M.theSecurityOfThisPageIsUnknown)],[Protocol.Security.SecurityState.Insecure,A(M.thisPageIsNotSecure)],[Protocol.Security.SecurityState.Neutral,A(M.thisPageIsNotSecure)],[Protocol.Security.SecurityState.Secure,A(M.thisPageIsSecureValidHttps)],[Protocol.Security.SecurityState.InsecureBroken,A(M.thisPageIsNotSecureBrokenHttps)]]);this._securityState===Protocol.Security.SecurityState.Insecure?(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.add("lock-icon-insecure"),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.remove("lock-icon-insecure-broken"),g.Tooltip.install(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure),A(M.notSecure))):this._securityState===Protocol.Security.SecurityState.InsecureBroken&&(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.add("lock-icon-insecure-broken"),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.remove("lock-icon-insecure"),g.Tooltip.install(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure),A(M.notSecureBroken))),this._summaryText.textContent=i||s.get(this._securityState)||"",this._explanations=t,this.refreshExplanations()}updateVisibleSecurityState(e){this._summarySection.classList.remove("security-summary-"+this._securityState),this._securityState=e.securityState,this._summarySection.classList.add("security-summary-"+this._securityState),this._securityState===Protocol.Security.SecurityState.Insecure?(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.add("lock-icon-insecure"),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.remove("lock-icon-insecure-broken"),g.Tooltip.install(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure),A(M.notSecure))):this._securityState===Protocol.Security.SecurityState.InsecureBroken&&(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.add("lock-icon-insecure-broken"),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.remove("lock-icon-insecure"),g.Tooltip.install(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure),A(M.notSecureBroken)));const{summary:t,explanations:i}=this._getSecuritySummaryAndExplanations(e);this._summaryText.textContent=t||x[this._securityState],this._explanations=this._orderExplanations(i),this.refreshExplanations()}_getSecuritySummaryAndExplanations(e){const{securityState:t,securityStateIssueIds:i}=e;let s;const r=[];if(s=this._explainSafetyTipSecurity(e,s,r),i.includes("malicious-content"))s=A(M.thisPageIsDangerousFlaggedBy),r.unshift(new I(Protocol.Security.SecurityState.Insecure,void 0,A(M.flaggedByGoogleSafeBrowsing),A(M.toCheckThisPagesStatusVisit)));else{if(i.includes("is-error-page")&&(null===e.certificateSecurityState||null===e.certificateSecurityState.certificateNetworkError))return s=A(M.thisIsAnErrorPage),{summary:s,explanations:r};t===Protocol.Security.SecurityState.InsecureBroken&&i.includes("scheme-is-not-cryptographic")&&(s=s||A(M.thisPageIsInsecureUnencrypted),i.includes("insecure-input-events")&&r.push(new I(Protocol.Security.SecurityState.Insecure,void 0,A(M.formFieldEditedOnANonsecurePage),A(M.dataWasEnteredInAFieldOnA))))}return i.includes("scheme-is-not-cryptographic")?(t!==Protocol.Security.SecurityState.Neutral||i.includes("insecure-origin")||(s=A(M.thisPageHasANonhttpsSecureOrigin)),{summary:s,explanations:r}):(this._explainCertificateSecurity(e,r),this._explainConnectionSecurity(e,r),this._explainContentSecurity(e,r),{summary:s,explanations:r})}_explainSafetyTipSecurity(e,t,i){const{securityStateIssueIds:s,safetyTipInfo:r}=e,n=[];if(s.includes("bad_reputation")){const e=`${A(M.chromeHasDeterminedThatThisSiteS)}\n\n${A(M.ifYouBelieveThisIsShownIn)}`;n.push({summary:A(M.thisPageIsSuspicious),description:e})}else if(s.includes("lookalike")&&r&&r.safeUrl){const e=new URL(r.safeUrl).hostname,t=`${A(M.thisSitesHostnameLooksSimilarToP,{PH1:e})}\n\n${A(M.ifYouBelieveThisIsShownInErrorSafety)}`;n.push({summary:A(M.possibleSpoofingUrl),description:t})}return n.length>0&&(t=t||A(M.thisPageIsSuspiciousFlaggedBy),i.push(new I(Protocol.Security.SecurityState.Insecure,void 0,n[0].summary,n[0].description))),t}_explainCertificateSecurity(e,t){const{certificateSecurityState:i,securityStateIssueIds:s}=e,r=A(M.certificate);if(i&&i.certificateHasSha1Signature){const e=A(M.insecureSha),s=A(M.theCertificateChainForThisSite);i.certificateHasWeakSignature?t.push(new I(Protocol.Security.SecurityState.Insecure,r,e,s,i.certificate,Protocol.Security.MixedContentType.None)):t.push(new I(Protocol.Security.SecurityState.Neutral,r,e,s,i.certificate,Protocol.Security.MixedContentType.None))}i&&s.includes("cert-missing-subject-alt-name")&&t.push(new I(Protocol.Security.SecurityState.Insecure,r,A(M.subjectAlternativeNameMissing),A(M.theCertificateForThisSiteDoesNot),i.certificate,Protocol.Security.MixedContentType.None)),i&&null!==i.certificateNetworkError?t.push(new I(Protocol.Security.SecurityState.Insecure,r,A(M.missing),A(M.thisSiteIsMissingAValidTrusted,{PH1:i.certificateNetworkError}),i.certificate,Protocol.Security.MixedContentType.None)):i&&!i.certificateHasSha1Signature&&t.push(new I(Protocol.Security.SecurityState.Secure,r,A(M.validAndTrusted),A(M.theConnectionToThisSiteIsUsingA,{PH1:i.issuer}),i.certificate,Protocol.Security.MixedContentType.None)),s.includes("pkp-bypassed")&&t.push(new I(Protocol.Security.SecurityState.Info,r,A(M.publickeypinningBypassed),A(M.publickeypinningWasBypassedByA))),i&&i.isCertificateExpiringSoon()&&t.push(new I(Protocol.Security.SecurityState.Info,void 0,A(M.certificateExpiresSoon),A(M.theCertificateForThisSiteExpires)))}_explainConnectionSecurity(e,t){const i=e.certificateSecurityState;if(!i)return;const s=A(M.connection);if(i.modernSSL)return void t.push(new I(Protocol.Security.SecurityState.Secure,s,A(M.secureConnectionSettings),A(M.theConnectionToThisSiteIs,{PH1:i.protocol,PH2:i.getKeyExchangeName(),PH3:i.getCipherFullName()})));const r=[];i.obsoleteSslProtocol&&r.push(A(M.sIsObsoleteEnableTlsOrLater,{PH1:i.protocol})),i.obsoleteSslKeyExchange&&r.push(A(M.rsaKeyExchangeIsObsoleteEnableAn)),i.obsoleteSslCipher&&r.push(A(M.sIsObsoleteEnableAnAesgcmbased,{PH1:i.cipher})),i.obsoleteSslSignature&&r.push(A(M.theServerSignatureUsesShaWhichIs)),t.push(new I(Protocol.Security.SecurityState.Info,s,A(M.obsoleteConnectionSettings),A(M.theConnectionToThisSiteIs,{PH1:i.protocol,PH2:i.getKeyExchangeName(),PH3:i.getCipherFullName()}),void 0,void 0,r))}_explainContentSecurity(e,t){let i=!0;const s=A(M.resources),r=e.securityStateIssueIds;r.includes("ran-mixed-content")&&(i=!1,t.push(new I(Protocol.Security.SecurityState.Insecure,s,A(M.activeMixedContent),A(M.youHaveRecentlyAllowedNonsecure),[],Protocol.Security.MixedContentType.Blockable))),r.includes("displayed-mixed-content")&&(i=!1,t.push(new I(Protocol.Security.SecurityState.Neutral,s,A(M.mixedContent),A(M.thisPageIncludesHttpResources),[],Protocol.Security.MixedContentType.OptionallyBlockable))),r.includes("contained-mixed-form")&&(i=!1,t.push(new I(Protocol.Security.SecurityState.Neutral,s,A(M.nonsecureForm),A(M.thisPageIncludesAFormWithA)))),null!==e.certificateSecurityState&&null!==e.certificateSecurityState.certificateNetworkError||(r.includes("ran-content-with-cert-error")&&(i=!1,t.push(new I(Protocol.Security.SecurityState.Insecure,s,A(M.activeContentWithCertificate),A(M.youHaveRecentlyAllowedContent)))),r.includes("displayed-content-with-cert-errors")&&(i=!1,t.push(new I(Protocol.Security.SecurityState.Neutral,s,A(M.contentWithCertificateErrors),A(M.thisPageIncludesResourcesThat))))),i&&(r.includes("scheme-is-not-cryptographic")||t.push(new I(Protocol.Security.SecurityState.Secure,s,A(M.allServedSecurely),A(M.allResourcesOnThisPageAreServed))))}_orderExplanations(e){if(0===e.length)return e;const t=[Protocol.Security.SecurityState.Insecure,Protocol.Security.SecurityState.Neutral,Protocol.Security.SecurityState.Secure,Protocol.Security.SecurityState.Info],i=[];for(const s of t)i.push(...e.filter((e=>e.securityState===s)));return i}refreshExplanations(){if(this._securityExplanationsMain.removeChildren(),this._securityExplanationsExtra.removeChildren(),this._explanations){for(const e of this._explanations)if(e.securityState===Protocol.Security.SecurityState.Info)this._addExplanation(this._securityExplanationsExtra,e);else switch(e.mixedContentType){case Protocol.Security.MixedContentType.Blockable:this._addMixedContentExplanation(this._securityExplanationsMain,e,a.MixedContentFilterValues.BlockOverridden);break;case Protocol.Security.MixedContentType.OptionallyBlockable:this._addMixedContentExplanation(this._securityExplanationsMain,e,a.MixedContentFilterValues.Displayed);break;default:this._addExplanation(this._securityExplanationsMain,e)}if(this._panel.filterRequestCount(a.MixedContentFilterValues.Blocked)>0){const e={securityState:Protocol.Security.SecurityState.Info,summary:A(M.blockedMixedContent),description:A(M.yourPageRequestedNonsecure),mixedContentType:Protocol.Security.MixedContentType.Blockable,certificate:[],title:""};this._addMixedContentExplanation(this._securityExplanationsMain,e,a.MixedContentFilterValues.Blocked)}}}_addMixedContentExplanation(e,t,i){const s=this._addExplanation(e,t),r=this._panel.filterRequestCount(i);if(!r){return void(s.createChild("div","security-mixed-content").textContent=A(M.reloadThePageToRecordRequestsFor))}const n=s.createChild("div","security-mixed-content devtools-link");d.markAsLink(n),n.tabIndex=0,n.textContent=1===r?A(M.viewDRequestInNetworkPanel):A(M.viewDRequestsInNetworkPanel,{PH1:r}),n.addEventListener("click",this.showNetworkFilter.bind(this,i)),n.addEventListener("keydown",(e=>{"Enter"===e.key&&this.showNetworkFilter(i,e)}))}showNetworkFilter(e,t){t.consume(),l.NetworkPanel.revealAndFilter([{filterType:a.FilterType.MixedContent,filterValue:e}])}}class B extends y.VBox{constructor(e,t,i){super(),this._panel=e,this.setMinimumSize(200,100),this.element.classList.add("security-origin-view"),this.registerRequiredCSS("security/originView.css",{enableLegacyPatching:!0}),this.registerRequiredCSS("security/lockIcon.css",{enableLegacyPatching:!0});const s=this.element.createChild("div","title-section"),r=s.createChild("div","title-section-header");r.textContent=A(M.origin),d.markAsHeading(r,1);const o=s.createChild("div","origin-display");this._originLockIcon=o.createChild("span","security-property"),this._originLockIcon.classList.add("security-property-"+i.securityState),o.appendChild(H.createHighlightedUrl(t,i.securityState));const c=s.createChild("div","view-network-button"),u=h.createTextButton(A(M.viewRequestsInNetworkPanel),(e=>{e.consume();const i=new n.ParsedURL(t);l.NetworkPanel.revealAndFilter([{filterType:a.FilterType.Domain,filterValue:i.host},{filterType:a.FilterType.Scheme,filterValue:i.scheme}])}));if(c.appendChild(u),d.markAsLink(u),i.securityDetails){const e=this.element.createChild("div","origin-view-section"),s=e.createChild("div","origin-view-section-title");s.textContent=A(M.connection),d.markAsHeading(s,2);let r=new U;e.appendChild(r.element()),r.addRow(A(M.protocol),i.securityDetails.protocol),i.securityDetails.keyExchange&&r.addRow(A(M.keyExchange),i.securityDetails.keyExchange),i.securityDetails.keyExchangeGroup&&r.addRow(A(M.keyExchangeGroup),i.securityDetails.keyExchangeGroup),r.addRow(A(M.cipher),i.securityDetails.cipher+(i.securityDetails.mac?" with "+i.securityDetails.mac:""));const n=this.element.createChild("div","origin-view-section"),o=n.createChild("div","origin-view-section-title");o.textContent=A(M.certificate),d.markAsHeading(o,2);const c=i.securityDetails.signedCertificateTimestampList.length,a=i.securityDetails.certificateTransparencyCompliance;let l;if(c||a!==Protocol.Network.CertificateTransparencyCompliance.Unknown){l=this.element.createChild("div","origin-view-section");const e=l.createChild("div","origin-view-section-title");e.textContent=A(M.certificateTransparency),d.markAsHeading(e,2)}const u=this._createSanDiv(i.securityDetails.sanList),S=new Date(1e3*i.securityDetails.validFrom).toUTCString(),y=new Date(1e3*i.securityDetails.validTo).toUTCString();if(r=new U,n.appendChild(r.element()),r.addRow(A(M.subject),i.securityDetails.subjectName),r.addRow(A(M.san),u),r.addRow(A(M.validFrom),S),r.addRow(A(M.validUntil),y),r.addRow(A(M.issuer),i.securityDetails.issuer),r.addRow("",H.createCertificateViewerButtonForOrigin(A(M.openFullCertificateDetails),t)),!l)return;const g=new U;g.element().classList.add("sct-summary"),l.appendChild(g.element());for(let e=0;e<c;e++){const t=i.securityDetails.signedCertificateTimestampList[e];g.addRow(A(M.sct),t.logDescription+" ("+t.origin+", "+t.status+")")}const p=l.createChild("div","sct-details");p.classList.add("hidden");for(let e=0;e<c;e++){const t=new U;p.appendChild(t.element());const s=i.securityDetails.signedCertificateTimestampList[e];t.addRow(A(M.logName),s.logDescription),t.addRow(A(M.logId),s.logId.replace(/(.{2})/g,"$1 ")),t.addRow(A(M.validationStatus),s.status),t.addRow(A(M.source),s.origin),t.addRow(A(M.issuedAt),new Date(s.timestamp).toUTCString()),t.addRow(A(M.hashAlgorithm),s.hashAlgorithm),t.addRow(A(M.signatureAlgorithm),s.signatureAlgorithm),t.addRow(A(M.signatureData),s.signatureData.replace(/(.{2})/g,"$1 "))}if(c){const e=h.createTextButton(A(M.showFullDetails),(function(){let t;const i=!p.classList.contains("hidden");t=A(i?M.showFullDetails:M.hideFullDetails),e.textContent=t,d.setAccessibleName(e,t),d.setExpanded(e,!i),g.element().classList.toggle("hidden"),p.classList.toggle("hidden")}),"details-toggle");l.appendChild(e)}switch(a){case Protocol.Network.CertificateTransparencyCompliance.Compliant:l.createChild("div","origin-view-section-notes").textContent=A(M.thisRequestCompliesWithChromes);break;case Protocol.Network.CertificateTransparencyCompliance.NotCompliant:l.createChild("div","origin-view-section-notes").textContent=A(M.thisRequestDoesNotComplyWith);break;case Protocol.Network.CertificateTransparencyCompliance.Unknown:}const m=this.element.createChild("div","origin-view-section origin-view-notes");i.loadedFromCache&&(m.createChild("div").textContent=A(M.thisResponseWasLoadedFromCache)),m.createChild("div").textContent=A(M.theSecurityDetailsAboveAreFrom)}else if(i.securityState===Protocol.Security.SecurityState.Secure){const e=this.element.createChild("div","origin-view-section"),t=e.createChild("div","origin-view-section-title");t.textContent=A(M.secure),d.markAsHeading(t,2),e.createChild("div").textContent=A(M.thisOriginIsANonhttpsSecure)}else if(i.securityState!==Protocol.Security.SecurityState.Unknown){const e=this.element.createChild("div","origin-view-section"),t=e.createChild("div","origin-view-section-title");t.textContent=A(M.notSecure),d.markAsHeading(t,2),e.createChild("div").textContent=A(M.yourConnectionToThisOriginIsNot)}else{const e=this.element.createChild("div","origin-view-section"),t=e.createChild("div","origin-view-section-title");t.textContent=A(M.noSecurityInformation),d.markAsHeading(t,2),e.createChild("div").textContent=A(M.noSecurityDetailsAreAvailableFor)}}_createSanDiv(e){const t=document.createElement("div");if(0===e.length)t.textContent=A(M.na),t.classList.add("empty-san");else{const s=2,r=e.length>s+1;for(let i=0;i<e.length;i++){const n=t.createChild("span","san-entry");n.textContent=e[i],r&&i>=s&&n.classList.add("truncated-entry")}if(r){function i(){const i=t.classList.contains("truncated-san");let r;i?(t.classList.remove("truncated-san"),r=A(M.showLess)):(t.classList.add("truncated-san"),r=A(M.showMoreSTotal,{PH1:e.length})),s.textContent=r,d.setAccessibleName(s,r),d.setExpanded(s,i)}const s=h.createTextButton(A(M.showMoreSTotal,{PH1:e.length}),i);t.appendChild(s),i()}}return t}setSecurityState(e){for(const e of Array.prototype.slice.call(this._originLockIcon.classList))e.startsWith("security-property-")&&this._originLockIcon.classList.remove(e);this._originLockIcon.classList.add("security-property-"+e)}}class U{constructor(){this._element=document.createElement("table"),this._element.classList.add("details-table")}element(){return this._element}addRow(e,t){const i=this._element.createChild("div","details-table-row");i.createChild("div").textContent=e;const s=i.createChild("div");"string"==typeof t?s.textContent=t:s.appendChild(t)}}var q=Object.freeze({__proto__:null,UIStrings:M,SecurityPanel:H,SecurityPanelSidebarTree:O,get OriginGroup(){return D},SecurityPanelSidebarTreeElement:V,SecurityMainView:F,SecurityOriginView:B,SecurityDetailsTable:U});export{L as SecurityModel,q as SecurityPanel};
