/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazonaws.services.ec2.model.VpcEndpoint;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeVpcEndpoints
extends BaseCmd {
    public DescribeVpcEndpoints(String[] args) {
        super("ec2dve", "ec2-describe-vpc-endpoints");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "VPC_ENDPOINT [, VPC_ENDPOINT] [--filter NAME=VALUE, ..] ";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        options.addOption(OptionBuilder.create((String)"F"));
        options.addOption(DescribeVpcEndpoints.createOptionWithArgs(null, "max-results", MAX_RESULTS_DESC, "MAX_RESULTS"));
        options.addOption(DescribeVpcEndpoints.createOptionWithArgs(null, "next-token", NEXT_TOKEN_DESC, "NEXT_TOKEN"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Describes one or more of your VPC endpoints.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
        this.printOption("max-results");
        this.printOption("next-token");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp;
        Integer maxResults;
        String[] vpcEndpointIds = this.getNonOptions();
        try {
            maxResults = this.getOptionInteger("max-results");
        }
        catch (NumberFormatException e) {
            maxResults = null;
        }
        String nextToken = this.getOptionValue("next-token");
        boolean automaticPaging = nextToken == null && maxResults == null;
        ArrayList<VpcEndpoint> vpcEndpoints = new ArrayList<VpcEndpoint>();
        do {
            rsp = jec2.describeVpcEndpoints(vpcEndpointIds, this.getFilters(true), maxResults, nextToken);
            vpcEndpoints.addAll((Collection)rsp.getResponse());
            nextToken = rsp.getNextToken();
        } while (automaticPaging && nextToken != null && !nextToken.isEmpty());
        out.outputVpcEndpoints(System.out, vpcEndpoints);
        out.printNextToken(System.out, nextToken);
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    public static void main(String[] args) {
        new DescribeVpcEndpoints(args).invoke();
    }
}

