/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.util.Arrays;
import sun.security.internal.spec.TlsKeyMaterialParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialSpec;
import sun.security.internal.spec.TlsMasterSecretParameterSpec;
import sun.security.internal.spec.TlsPrfParameterSpec;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;

class ProvSunTLSKDF
extends AsymmetricAlgorithmProvider {
    private static final boolean hasPrfMethods = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                Class<?> clazz = BouncyCastleFipsProvider.class.getClassLoader().loadClass("sun.security.internal.spec.TlsPrfParameterSpec");
                return clazz.getMethod("getPRFHashAlg", new Class[0]) != null;
            }
            catch (Exception exception) {
                return false;
            }
        }
    });
    private static final Constructor tlsPrfParameterSpecConstructor;
    private static final boolean hasGetEncodeSecretMethod;
    private static final String PROVIDER_PACKAGE = "org.bouncycastle.jcajce.provider.";
    private static final String SYMMETRIC_PACKAGE = "org.bouncycastle.jcajce.provider.symmetric.";
    private static final String KDF_PACKAGE = "org.bouncycastle.jcajce.provider.symmetric.kdf.";

    ProvSunTLSKDF() {
    }

    public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SUNTLSRSAPREMASTERSECRET", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLSKeyGeneratorPremaster", new EngineCreator(){

            public Object createInstance(Object object) {
                return new TLSRsaPreMasterSecretGenerator();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SUNTLS12RSAPREMASTERSECRET", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLS12KeyGeneratorPremaster", new EngineCreator(){

            public Object createInstance(Object object) {
                return new TLSRsaPreMasterSecretGenerator();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SUNTLSMASTERSECRET", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLSKeyGeneratorMaster", new EngineCreator(){

            public Object createInstance(Object object) {
                return new TLSMasterSecretGenerator();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SUNTLSEXTENDEDMASTERSECRET", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLSExtendedKeyGeneratorMaster", new EngineCreator(){

            public Object createInstance(Object object) {
                return new TLSExtendedMasterSecretGenerator();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SUNTLS12MASTERSECRET", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLS12KeyGeneratorMaster", new EngineCreator(){

            public Object createInstance(Object object) {
                return new TLSMasterSecretGenerator();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SUNTLSKEYMATERIAL", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLSKeyGeneratorKeyMaterial", new EngineCreator(){

            public Object createInstance(Object object) {
                return new TLSKeyMaterialGenerator();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SUNTLS12KEYMATERIAL", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLS12KeyGeneratorKeyMaterial", new EngineCreator(){

            public Object createInstance(Object object) {
                return new TLSKeyMaterialGenerator();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SUNTLSPRF", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLSKeyGeneratorPRF", new EngineCreator(){

            public Object createInstance(Object object) {
                return new TLSPRFKeyGenerator();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SUNTLS12PRF", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLS12KeyGeneratorPRF", new EngineCreator(){

            public Object createInstance(Object object) {
                return new TLSPRFKeyGenerator();
            }
        });
    }

    private static FipsKDF.TLSPRF getPRF(String string) {
        if (string.equals("NONE")) {
            return null;
        }
        if (string.equals("SHA-256")) {
            return FipsKDF.TLSPRF.SHA256_HMAC;
        }
        if (string.equals("SHA-384")) {
            return FipsKDF.TLSPRF.SHA384_HMAC;
        }
        if (string.equals("SHA-512")) {
            return FipsKDF.TLSPRF.SHA512_HMAC;
        }
        throw new IllegalStateException("Unknown PRF: " + string);
    }

    private static TlsPrfParameterSpec createPrfParameterSpec(SecretKey secretKey, String string, byte[] byArray, int n, String string2, int n2, int n3) {
        Object[] objectArray = hasPrfMethods ? new Object[]{secretKey, string, byArray, n, string2, n2, n3} : new Object[]{secretKey, string, byArray, n};
        try {
            return (TlsPrfParameterSpec)tlsPrfParameterSpecConstructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to construct TlsPrfParameterSpec: " + exception.getMessage(), exception);
        }
    }

    static {
        hasGetEncodeSecretMethod = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Class<?> clazz = BouncyCastleFipsProvider.class.getClassLoader().loadClass("sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec");
                    return clazz.getMethod("getEncodedSecret", new Class[0]) != null;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
        tlsPrfParameterSpecConstructor = AccessController.doPrivileged(new PrivilegedAction<Constructor>(){

            @Override
            public Constructor run() {
                try {
                    Class<?> clazz = BouncyCastleFipsProvider.class.getClassLoader().loadClass("sun.security.internal.spec.TlsPrfParameterSpec");
                    return clazz.getConstructors()[0];
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    static abstract class BaseTLSKeyGeneratorSpi
    extends KeyGeneratorSpi {
        protected SecureRandom secureRandom = null;

        BaseTLSKeyGeneratorSpi() {
        }

        protected void engineInit(SecureRandom secureRandom) {
            throw new UnsupportedOperationException();
        }

        protected void engineInit(int n, SecureRandom secureRandom) {
            throw new UnsupportedOperationException();
        }

        protected SecretKey calculatePRF(TlsPrfParameterSpec tlsPrfParameterSpec, String string) {
            Object object;
            FipsKDF.TLSParametersBuilder tLSParametersBuilder = hasPrfMethods ? ((object = ProvSunTLSKDF.getPRF(tlsPrfParameterSpec.getPRFHashAlg())) == null ? FipsKDF.TLS1_1 : FipsKDF.TLS1_2.withPRF((FipsKDF.TLSPRF)((Object)object))) : FipsKDF.TLS1_1;
            object = tLSParametersBuilder.using(tlsPrfParameterSpec.getSecret().getEncoded(), tlsPrfParameterSpec.getLabel(), new byte[][]{tlsPrfParameterSpec.getSeed()});
            KDFCalculator<FipsKDF.TLSParameters> kDFCalculator = new FipsKDF.TLSOperatorFactory().createKDFCalculator((FipsKDF.TLSParameters)object);
            byte[] byArray = new byte[tlsPrfParameterSpec.getOutputLength()];
            kDFCalculator.generateBytes(byArray);
            return new SecretKeySpec(byArray, string);
        }
    }

    static final class TLSExtendedMasterSecretGenerator
    extends BaseTLSKeyGeneratorSpi {
        private TlsMasterSecretParameterSpec spec;

        TLSExtendedMasterSecretGenerator() {
        }

        protected void engineInit(SecureRandom secureRandom) {
            throw new InvalidParameterException("only initialise with TlsMasterSecretParameterSpec");
        }

        protected void engineInit(int n, SecureRandom secureRandom) {
            throw new InvalidParameterException("only initialise with TlsMasterSecretParameterSpec");
        }

        protected void engineInit(final AlgorithmParameterSpec algorithmParameterSpec, final SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    TLSExtendedMasterSecretGenerator.this.spec = (TlsMasterSecretParameterSpec)algorithmParameterSpec;
                    TLSExtendedMasterSecretGenerator.this.secureRandom = secureRandom;
                    return null;
                }
            });
        }

        protected SecretKey engineGenerateKey() {
            return AccessController.doPrivileged(new PrivilegedAction<SecretKey>(){

                @Override
                public SecretKey run() {
                    String string = "extended master secret";
                    byte[] byArray = TLSExtendedMasterSecretGenerator.this.spec.getExtendedMasterSecretSessionHash();
                    int n = TLSExtendedMasterSecretGenerator.this.spec.getMajorVersion() << 8 | TLSExtendedMasterSecretGenerator.this.spec.getMinorVersion();
                    TlsPrfParameterSpec tlsPrfParameterSpec = n >= 771 ? ProvSunTLSKDF.createPrfParameterSpec(TLSExtendedMasterSecretGenerator.this.spec.getPremasterSecret(), string, byArray, 48, TLSExtendedMasterSecretGenerator.this.spec.getPRFHashAlg(), TLSExtendedMasterSecretGenerator.this.spec.getPRFHashLength(), TLSExtendedMasterSecretGenerator.this.spec.getPRFBlockSize()) : ProvSunTLSKDF.createPrfParameterSpec(TLSExtendedMasterSecretGenerator.this.spec.getPremasterSecret(), string, byArray, 48, "NONE", 0, 0);
                    return TLSExtendedMasterSecretGenerator.this.calculatePRF(tlsPrfParameterSpec, "TlsMasterSecret");
                }
            });
        }
    }

    static final class TLSKeyMaterialGenerator
    extends BaseTLSKeyGeneratorSpi {
        private TlsKeyMaterialParameterSpec spec;

        TLSKeyMaterialGenerator() {
        }

        protected void engineInit(final AlgorithmParameterSpec algorithmParameterSpec, final SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    TLSKeyMaterialGenerator.this.spec = (TlsKeyMaterialParameterSpec)algorithmParameterSpec;
                    TLSKeyMaterialGenerator.this.secureRandom = secureRandom;
                    return null;
                }
            });
        }

        protected SecretKey engineGenerateKey() {
            return AccessController.doPrivileged(new PrivilegedAction<SecretKey>(){

                @Override
                public SecretKey run() {
                    String string;
                    if (TLSKeyMaterialGenerator.this.spec.getExpandedCipherKeyLength() > 0) {
                        throw new UnsupportedOperationException();
                    }
                    int n = TLSKeyMaterialGenerator.this.spec.getCipherKeyLength();
                    int n2 = TLSKeyMaterialGenerator.this.spec.getIvLength();
                    int n3 = TLSKeyMaterialGenerator.this.spec.getMacKeyLength();
                    int n4 = (n + n2 + n3) * 2;
                    byte[] byArray = Arrays.concatenate(TLSKeyMaterialGenerator.this.spec.getServerRandom(), TLSKeyMaterialGenerator.this.spec.getClientRandom());
                    TlsPrfParameterSpec tlsPrfParameterSpec = hasPrfMethods ? ProvSunTLSKDF.createPrfParameterSpec(TLSKeyMaterialGenerator.this.spec.getMasterSecret(), "key expansion", byArray, n4, TLSKeyMaterialGenerator.this.spec.getPRFHashAlg(), TLSKeyMaterialGenerator.this.spec.getPRFHashLength(), TLSKeyMaterialGenerator.this.spec.getPRFBlockSize()) : ProvSunTLSKDF.createPrfParameterSpec(TLSKeyMaterialGenerator.this.spec.getMasterSecret(), "key expansion", byArray, n4, null, 0, 0);
                    byte[] byArray2 = TLSKeyMaterialGenerator.this.calculatePRF(tlsPrfParameterSpec, "DUMMY").getEncoded();
                    SecretKeySpec secretKeySpec = null;
                    SecretKeySpec secretKeySpec2 = null;
                    SecretKeySpec secretKeySpec3 = null;
                    SecretKeySpec secretKeySpec4 = null;
                    IvParameterSpec ivParameterSpec = null;
                    IvParameterSpec ivParameterSpec2 = null;
                    int n5 = 0;
                    if (n3 > 0) {
                        string = "DUMMY";
                        secretKeySpec = new SecretKeySpec(byArray2, n5, n3, string);
                        secretKeySpec2 = new SecretKeySpec(byArray2, n5 += n3, n3, string);
                        n5 += n3;
                    }
                    if (n > 0) {
                        string = TLSKeyMaterialGenerator.this.spec.getCipherAlgorithm();
                        secretKeySpec3 = new SecretKeySpec(byArray2, n5, n, string);
                        secretKeySpec4 = new SecretKeySpec(byArray2, n5 += n, n, string);
                        n5 += n;
                    }
                    if (n2 > 0) {
                        ivParameterSpec = new IvParameterSpec(byArray2, n5, n2);
                        ivParameterSpec2 = new IvParameterSpec(byArray2, n5 += n2, n2);
                        n5 += n2;
                    }
                    if (n5 != n4) {
                        throw new IllegalStateException();
                    }
                    return new TlsKeyMaterialSpec(secretKeySpec, secretKeySpec2, secretKeySpec3, ivParameterSpec, secretKeySpec4, ivParameterSpec2);
                }
            });
        }
    }

    static final class TLSMasterSecretGenerator
    extends BaseTLSKeyGeneratorSpi {
        private TlsMasterSecretParameterSpec spec;

        TLSMasterSecretGenerator() {
        }

        protected void engineInit(final AlgorithmParameterSpec algorithmParameterSpec, final SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    TLSMasterSecretGenerator.this.spec = (TlsMasterSecretParameterSpec)algorithmParameterSpec;
                    TLSMasterSecretGenerator.this.secureRandom = secureRandom;
                    return null;
                }
            });
        }

        protected SecretKey engineGenerateKey() {
            return AccessController.doPrivileged(new PrivilegedAction<SecretKey>(){

                @Override
                public SecretKey run() {
                    byte[] byArray = Arrays.concatenate(TLSMasterSecretGenerator.this.spec.getClientRandom(), TLSMasterSecretGenerator.this.spec.getServerRandom());
                    TlsPrfParameterSpec tlsPrfParameterSpec = hasPrfMethods ? ProvSunTLSKDF.createPrfParameterSpec(TLSMasterSecretGenerator.this.spec.getPremasterSecret(), "master secret", byArray, 48, TLSMasterSecretGenerator.this.spec.getPRFHashAlg(), TLSMasterSecretGenerator.this.spec.getPRFHashLength(), TLSMasterSecretGenerator.this.spec.getPRFBlockSize()) : ProvSunTLSKDF.createPrfParameterSpec(TLSMasterSecretGenerator.this.spec.getPremasterSecret(), "master secret", byArray, 48, null, 0, 0);
                    return TLSMasterSecretGenerator.this.calculatePRF(tlsPrfParameterSpec, "TlsMasterSecret");
                }
            });
        }
    }

    static final class TLSPRFKeyGenerator
    extends BaseTLSKeyGeneratorSpi {
        private TlsPrfParameterSpec spec;

        TLSPRFKeyGenerator() {
        }

        protected void engineInit(final AlgorithmParameterSpec algorithmParameterSpec, final SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    TLSPRFKeyGenerator.this.spec = (TlsPrfParameterSpec)algorithmParameterSpec;
                    TLSPRFKeyGenerator.this.secureRandom = secureRandom;
                    return null;
                }
            });
        }

        protected SecretKey engineGenerateKey() {
            return AccessController.doPrivileged(new PrivilegedAction<SecretKey>(){

                @Override
                public SecretKey run() {
                    return TLSPRFKeyGenerator.this.calculatePRF(TLSPRFKeyGenerator.this.spec, "DUMMY");
                }
            });
        }
    }

    static final class TLSRsaPreMasterSecretGenerator
    extends BaseTLSKeyGeneratorSpi {
        private TlsRsaPremasterSecretParameterSpec spec;

        TLSRsaPreMasterSecretGenerator() {
        }

        protected void engineInit(final AlgorithmParameterSpec algorithmParameterSpec, final SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    TLSRsaPreMasterSecretGenerator.this.spec = (TlsRsaPremasterSecretParameterSpec)algorithmParameterSpec;
                    TLSRsaPreMasterSecretGenerator.this.secureRandom = secureRandom;
                    return null;
                }
            });
        }

        protected SecretKey engineGenerateKey() {
            return AccessController.doPrivileged(new PrivilegedAction<SecretKey>(){

                @Override
                public SecretKey run() {
                    if (hasGetEncodeSecretMethod) {
                        try {
                            Class<?> clazz = BouncyCastleFipsProvider.class.getClassLoader().loadClass("sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec");
                            byte[] byArray = (byte[])clazz.getMethod("getEncodedSecret", new Class[0]).invoke((Object)TLSRsaPreMasterSecretGenerator.this.spec, new Object[0]);
                            if (byArray == null) {
                                byArray = new byte[48];
                                TLSRsaPreMasterSecretGenerator.this.secureRandom.nextBytes(byArray);
                                byArray[0] = (byte)TLSRsaPreMasterSecretGenerator.this.spec.getMajorVersion();
                                byArray[1] = (byte)TLSRsaPreMasterSecretGenerator.this.spec.getMinorVersion();
                            }
                            return new SecretKeySpec(byArray, "TlsPreMasterSecret");
                        }
                        catch (Exception exception) {
                            throw new IllegalStateException("internal error, profile of TlsRSAPremasterSecretParameterSpec has changed: " + exception.getMessage(), exception);
                        }
                    }
                    byte[] byArray = new byte[48];
                    TLSRsaPreMasterSecretGenerator.this.secureRandom.nextBytes(byArray);
                    byArray[0] = (byte)TLSRsaPreMasterSecretGenerator.this.spec.getMajorVersion();
                    byArray[1] = (byte)TLSRsaPreMasterSecretGenerator.this.spec.getMinorVersion();
                    return new SecretKeySpec(byArray, "TlsPreMasterSecret");
                }
            });
        }
    }
}

