/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.calltree;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.calltree.CallNode;
import ghidra.app.plugin.core.calltree.CallTreePlugin;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import resources.Icons;
import resources.MultiIcon;
import resources.icons.TranslateIcon;

public class IncomingCallNode
extends CallNode {
    private Icon INCOMING_ICON = Icons.ARROW_UP_LEFT_ICON;
    private Icon INCOMING_FUNCTION_ICON;
    private Icon icon = null;
    private final Address functionAddress;
    protected final Program program;
    protected final Function function;
    protected String name;
    protected final boolean filterDuplicates;
    private final Address sourceAddress;

    IncomingCallNode(Program program, Function function, Address sourceAddress, boolean filterDuplicates, AtomicInteger filterDepth) {
        super(filterDepth);
        this.program = program;
        this.function = function;
        this.name = function.getName();
        this.sourceAddress = sourceAddress;
        this.filterDuplicates = filterDuplicates;
        this.functionAddress = function.getEntryPoint();
        MultiIcon incomingFunctionIcon = new MultiIcon(this.INCOMING_ICON, false, 32, 16);
        TranslateIcon translateIcon = new TranslateIcon(CallTreePlugin.FUNCTION_ICON, 16, 0);
        incomingFunctionIcon.addIcon((Icon)translateIcon);
        this.INCOMING_FUNCTION_ICON = incomingFunctionIcon;
        this.setAllowsDuplicates(!filterDuplicates);
    }

    @Override
    CallNode recreate() {
        return new IncomingCallNode(this.program, this.function, this.sourceAddress, this.filterDuplicates, this.filterDepth);
    }

    @Override
    public Function getContainingFunction() {
        return this.function;
    }

    @Override
    public ProgramLocation getLocation() {
        return new FunctionSignatureFieldLocation(this.function.getProgram(), this.function.getEntryPoint());
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        FunctionSignatureFieldLocation location = new FunctionSignatureFieldLocation(this.program, this.functionAddress);
        Set<Address> addresses = ReferenceUtils.getReferenceAddresses((ProgramLocation)location, monitor);
        ArrayList<GTreeNode> nodes = new ArrayList<GTreeNode>();
        FunctionManager functionManager = this.program.getFunctionManager();
        for (Address fromAddress : addresses) {
            IncomingCallNode node;
            monitor.checkCanceled();
            Function callerFunction = functionManager.getFunctionContaining(fromAddress);
            if (callerFunction == null || nodes.contains((Object)(node = new IncomingCallNode(this.program, callerFunction, fromAddress, this.filterDuplicates, this.filterDepth)))) continue;
            nodes.add((GTreeNode)node);
        }
        Collections.sort(nodes, new CallNode.CallNodeComparator());
        return nodes;
    }

    @Override
    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    public Icon getIcon(boolean expanded) {
        if (this.icon == null) {
            this.icon = this.INCOMING_FUNCTION_ICON;
            if (this.functionIsInPath()) {
                this.icon = CallTreePlugin.RECURSIVE_ICON;
            }
        }
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTip() {
        return null;
    }

    public boolean isLeaf() {
        return false;
    }
}

