/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.Record;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.mem.BitMappedByteSourceRange;
import ghidra.program.database.mem.ByteSourceRange;
import ghidra.program.database.mem.ByteSourceRangeList;
import ghidra.program.database.mem.MemoryBlockDB;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.database.mem.SubMemoryBlock;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockType;
import java.io.IOException;
import java.util.List;

class BitMappedSubMemoryBlock
extends SubMemoryBlock {
    private final MemoryMapDB memMap;
    private final Address mappedAddress;
    private boolean ioPending;

    BitMappedSubMemoryBlock(MemoryMapDBAdapter adapter, Record record) {
        super(adapter, record);
        this.memMap = adapter.getMemoryMap();
        AddressMapDB addressMap = this.memMap.getAddressMap();
        this.mappedAddress = addressMap.decodeAddress(record.getLongValue(5), false);
    }

    @Override
    public boolean isInitialized() {
        return false;
    }

    @Override
    public byte getByte(long offsetInMemBlock) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        if (this.ioPending) {
            throw new MemoryAccessException("Cyclic Access");
        }
        try {
            this.ioPending = true;
            byte by = this.getBitOverlayByte(offsetInSubBlock);
            return by;
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    public AddressRange getMappedRange() {
        Address endMappedAddress = this.mappedAddress.add((this.subBlockLength - 1L) / 8L);
        return new AddressRangeImpl(this.mappedAddress, endMappedAddress);
    }

    @Override
    public int getBytes(long offsetInMemBlock, byte[] b, int off, int len) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        long available = this.subBlockLength - offsetInSubBlock;
        len = (int)Math.min((long)len, available);
        if (this.ioPending) {
            new MemoryAccessException("Cyclic Access");
        }
        try {
            int i;
            this.ioPending = true;
            for (i = 0; i < len; ++i) {
                b[i + off] = this.getBitOverlayByte(offsetInMemBlock++);
            }
            i = len;
            return i;
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putByte(long offsetInMemBlock, byte b) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        try {
            if (this.ioPending) {
                new MemoryAccessException("Cyclic Access");
            }
            this.ioPending = true;
            this.doPutByte(this.mappedAddress.addNoWrap(offsetInSubBlock / 8L), (int)(offsetInSubBlock % 8L), b);
        }
        catch (AddressOverflowException e) {
            new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    @Override
    public int putBytes(long offsetInMemBlock, byte[] b, int off, int len) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        long available = this.subBlockLength - offsetInSubBlock;
        len = (int)Math.min((long)len, available);
        try {
            int i;
            if (this.ioPending) {
                new MemoryAccessException("Cyclic Access");
            }
            this.ioPending = true;
            for (i = 0; i < len; ++i) {
                this.doPutByte(this.mappedAddress.addNoWrap(offsetInSubBlock / 8L), (int)(offsetInSubBlock % 8L), b[off + i]);
                ++offsetInSubBlock;
            }
            i = len;
            return i;
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    private byte getBitOverlayByte(long blockOffset) throws AddressOverflowException, MemoryAccessException {
        Address otherAddr = this.mappedAddress.addNoWrap(blockOffset / 8L);
        byte b = this.memMap.getByte(otherAddr);
        return (byte)(b >> (int)(blockOffset % 8L) & 1);
    }

    private void doPutByte(Address addr, int bitIndex, byte b) throws MemoryAccessException {
        this.ioPending = true;
        byte value = this.memMap.getByte(addr);
        int mask = 1 << bitIndex % 8;
        value = b == 0 ? (byte)(value & ~mask) : (byte)(value | mask);
        this.memMap.setByte(addr, value);
    }

    @Override
    protected boolean join(SubMemoryBlock sub2) {
        return false;
    }

    @Override
    protected boolean isMapped() {
        return true;
    }

    @Override
    protected MemoryBlockType getType() {
        return MemoryBlockType.BIT_MAPPED;
    }

    @Override
    protected SubMemoryBlock split(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getDescription() {
        return "Bit Mapped: " + this.mappedAddress;
    }

    @Override
    protected ByteSourceRangeList getByteSourceRangeList(MemoryBlock block, Address start, long memBlockOffset, long size) {
        ByteSourceRangeList result = new ByteSourceRangeList();
        Address startMappedAddress = this.mappedAddress.add(memBlockOffset / 8L);
        Address endMappedAddress = this.mappedAddress.add((memBlockOffset + size - 1L) / 8L);
        List<MemoryBlockDB> blocks = this.memMap.getBlocks(startMappedAddress, endMappedAddress);
        for (MemoryBlockDB mappedBlock : blocks) {
            Address startInBlock = this.max(mappedBlock.getStart(), startMappedAddress);
            Address endInBlock = this.min(mappedBlock.getEnd(), endMappedAddress);
            long blockSize = endInBlock.subtract(startInBlock) + 1L;
            ByteSourceRangeList ranges = mappedBlock.getByteSourceRangeList(startInBlock, blockSize);
            for (ByteSourceRange bsRange : ranges) {
                result.add(this.translate(block, bsRange, start, memBlockOffset, size));
            }
        }
        return result;
    }

    private ByteSourceRange translate(MemoryBlock block, ByteSourceRange bsRange, Address start, long offset, long bitLength) {
        Address startMappedAddress = this.mappedAddress.add(offset / 8L);
        Address normalizedStart = start.subtract(offset % 8L);
        long mappedOffsetFromStart = bsRange.getStart().subtract(startMappedAddress);
        long offsetFromStart = mappedOffsetFromStart * 8L;
        Address startAddress = normalizedStart.add(offsetFromStart);
        return new BitMappedByteSourceRange(block, startAddress, bsRange.getSourceId(), bsRange.getOffset(), bsRange.getSize());
    }

    Address min(Address a1, Address a2) {
        return a1.compareTo(a2) <= 0 ? a1 : a2;
    }

    Address max(Address a1, Address a2) {
        return a1.compareTo(a2) >= 0 ? a1 : a2;
    }
}

