/*
 * Decompiled with CFR 0.152.
 */
package help;

import ghidra.util.exception.AssertException;
import help.validator.LinkDatabase;
import help.validator.location.HelpModuleCollection;
import help.validator.model.AnchorDefinition;
import help.validator.model.GhidraTOCFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Date;

public class JavaHelpFilesBuilder {
    private static final String MAP_OUTPUT_FILENAME_SUFFIX = "_map.xml";
    private static final String TOC_OUTPUT_FILENAME_SUFFIX = "_TOC.xml";
    private static final String LOG_FILENAME = "help.log";
    private final String moduleName;
    private Path outputDir;
    private String mapOutputFilename;
    private String tocOutputFilename;
    private LinkDatabase linkDatabase;

    public JavaHelpFilesBuilder(Path outputDir, String moduleName, LinkDatabase linkDatabase) {
        this.moduleName = moduleName;
        this.linkDatabase = linkDatabase;
        this.outputDir = this.initializeOutputDirectory(outputDir);
        this.mapOutputFilename = moduleName + MAP_OUTPUT_FILENAME_SUFFIX;
        this.tocOutputFilename = moduleName + TOC_OUTPUT_FILENAME_SUFFIX;
    }

    private Path initializeOutputDirectory(Path outputDirectory) {
        if (!Files.exists(outputDirectory, new LinkOption[0])) {
            try {
                return Files.createDirectories(outputDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                return null;
            }
        }
        return outputDirectory;
    }

    public void generateHelpFiles(HelpModuleCollection help) throws Exception {
        JavaHelpFilesBuilder.message("Generating Help Files for: " + help);
        LogFileWriter errorLog = this.createLogFile();
        boolean hasErrors = false;
        StringBuffer shortErrorDescription = new StringBuffer();
        try {
            this.generateMapFile(help);
        }
        catch (IOException e) {
            hasErrors = true;
            shortErrorDescription.append("Unexpected error generating map file!\n");
            errorLog.append("Failed to generate " + this.mapOutputFilename + ": ");
            errorLog.append(e.getMessage());
            errorLog.println();
        }
        try {
            this.generateTOCFile(this.linkDatabase, help);
        }
        catch (IOException e) {
            hasErrors = true;
            shortErrorDescription.append("Unexpected error writing TOC file!\n");
            errorLog.append("Failed to generate " + this.tocOutputFilename + ": ");
            errorLog.append(e.getMessage());
            errorLog.println();
        }
        if (hasErrors) {
            errorLog.close();
            throw new RuntimeException("Errors Creating Help Files - " + shortErrorDescription + "\n\tsee help log for details: " + errorLog.getFile());
        }
        errorLog.close();
        if (errorLog.isEmpty()) {
            errorLog.delete();
        }
        JavaHelpFilesBuilder.message("Done generating help files for module: " + this.moduleName);
    }

    private LogFileWriter createLogFile() throws IOException {
        String logFilename = this.moduleName + ".help.log";
        Path logFile = this.outputDir.resolve(logFilename);
        return new LogFileWriter(logFile);
    }

    private static void message(String message) {
        System.out.println("[" + JavaHelpFilesBuilder.class.getSimpleName() + "] " + message);
        System.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMapFile(HelpModuleCollection help) throws IOException {
        Path mapFile = this.outputDir.resolve(this.mapOutputFilename);
        JavaHelpFilesBuilder.message("Generating map file: " + mapFile.toUri() + "...");
        if (Files.exists(mapFile, new LinkOption[0])) {
            Files.delete(mapFile);
        }
        try (LogFileWriter out = new LogFileWriter(mapFile);){
            out.println("<?xml version='1.0' encoding='ISO-8859-1' ?>");
            out.println("<!doctype MAP public \"-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN\">");
            out.println("<!-- Auto-generated on " + new Date().toString() + " : Do Not Edit -->");
            out.println("<map version=\"1.0\">");
            Collection<AnchorDefinition> anchors = help.getAllAnchorDefinitions();
            for (AnchorDefinition a : anchors) {
                String anchorTarget = a.getHelpPath();
                String updatedPath = this.relativize(this.outputDir, anchorTarget);
                out.println("  <mapID target=\"" + a.getId() + "\" url=\"" + updatedPath + "\"/>");
            }
            out.println("</map>");
            JavaHelpFilesBuilder.message("\tfinished generating map file");
        }
    }

    private String relativize(Path parent, String anchorTarget) {
        Path anchorPath = Paths.get(anchorTarget, new String[0]);
        if (anchorPath.isAbsolute()) {
            return anchorTarget;
        }
        if (!parent.endsWith("help")) {
            throw new AssertException("Map file expected in a directory name 'help'.  Update the map file generation code.");
        }
        if (!anchorTarget.startsWith("help")) {
            throw new AssertException("Relative anchor path does not start with 'help'");
        }
        Path relative = anchorPath.subpath(1, anchorPath.getNameCount());
        String relativePath = relative.toString();
        String normalized = relativePath.replaceAll("\\\\", "/");
        return normalized;
    }

    private void generateTOCFile(LinkDatabase database, HelpModuleCollection help) throws IOException {
        JavaHelpFilesBuilder.message("Generating TOC file: " + this.tocOutputFilename + "...");
        GhidraTOCFile sourceTOCFile = help.getSourceTOCFile();
        Path outputFile = this.outputDir.resolve(this.tocOutputFilename);
        database.generateTOCOutputFile(outputFile, sourceTOCFile);
        JavaHelpFilesBuilder.message("\tfinished generating TOC file");
    }

    private class LogFileWriter
    extends PrintWriter {
        private final Path file;

        LogFileWriter(Path logFile) throws IOException {
            super(new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(logFile, new OpenOption[0]))));
            this.file = logFile;
        }

        Path getFile() {
            return this.file;
        }

        boolean isEmpty() {
            try {
                return Files.size(this.file) == 0L;
            }
            catch (IOException e) {
                return true;
            }
        }

        void delete() {
            try {
                Files.delete(this.file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

