/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.android.bootimg.BootImage;
import ghidra.file.formats.android.bootimg.BootImageConstants;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@FileSystemInfo(type="androidbootimg", description="Android Boot and Recovery Images", factory=GFileSystemBaseFactory.class)
public class BootImageFileSystem
extends GFileSystemBase {
    private BootImage header;
    private GFileImpl kernelFile;
    private GFileImpl ramdiskFile;
    private GFileImpl secondStageFile;
    private List<GFileImpl> fileList = new ArrayList<GFileImpl>();

    public BootImageFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] bytes = this.provider.readBytes(0L, (long)BootImageConstants.BOOT_IMAGE_MAGIC_SIZE);
        return Arrays.equals(bytes, BootImageConstants.BOOT_IMAGE_MAGIC_BYTES);
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        this.header = new BootImage(this.provider);
        if (!this.header.getMagic().equals("ANDROID!")) {
            throw new IOException("Invalid Android boot image file!");
        }
        if (this.header.getKernelSize() > 0) {
            this.kernelFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"kernel", (boolean)false, (long)this.header.getKernelSize(), null);
            this.fileList.add(this.kernelFile);
        }
        if (this.header.getRamDiskSize() > 0) {
            this.ramdiskFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"ramdisk", (boolean)false, (long)this.header.getKernelSize(), null);
            this.fileList.add(this.ramdiskFile);
        }
        if (this.header.getSecondStageSize() > 0) {
            this.secondStageFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"second stage", (boolean)false, (long)this.header.getKernelSize(), null);
            this.fileList.add(this.secondStageFile);
        }
    }

    public void close() throws IOException {
        this.kernelFile = null;
        this.ramdiskFile = null;
        this.secondStageFile = null;
        this.header = null;
        super.close();
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return directory == null || directory.equals(this.root) ? new ArrayList<GFileImpl>(this.fileList) : Collections.emptyList();
    }

    public String getInfo(GFile file, TaskMonitor monitor) {
        if (file == this.kernelFile) {
            return "This is the actual KERNEL for the android device. You can analyze this file.";
        }
        if (file == this.ramdiskFile) {
            return "This is a ramdisk, it is a GZIP file containing a CPIO archive.";
        }
        if (file == this.secondStageFile) {
            return "This is a second stage loader file. It appears unused at this time.";
        }
        return null;
    }

    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CancelledException, CryptoException {
        if (file == this.kernelFile) {
            byte[] kernelBytes = this.provider.readBytes((long)this.header.getKernelOffset(), (long)this.header.getKernelSize());
            return new ByteArrayInputStream(kernelBytes);
        }
        if (file == this.ramdiskFile) {
            byte[] ramDiskBytes = this.provider.readBytes((long)this.header.getRamDiskOffset(), (long)this.header.getRamDiskSize());
            return new ByteArrayInputStream(ramDiskBytes);
        }
        if (file == this.secondStageFile) {
            byte[] secondStageBytes = this.provider.readBytes((long)this.header.getSecondStageOffset(), (long)this.header.getSecondStageSize());
            return new ByteArrayInputStream(secondStageBytes);
        }
        return null;
    }
}

