/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

public class NumberUtil {
    public static final int UNSIGNED_BYTE_MASK = 255;
    public static final int UNSIGNED_SHORT_MASK = 65535;
    public static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;

    public static Number getUnsignedValue(Number value) {
        if (value instanceof Byte) {
            return value.byteValue() & 0xFF;
        }
        if (value instanceof Short) {
            return value.shortValue() & 0xFFFF;
        }
        if (value instanceof Integer) {
            return (long)value.intValue() & 0xFFFFFFFFL;
        }
        if (value instanceof Long) {
            if (value.longValue() < 0L) {
                return value.longValue() & 0xFFFFFFFFFFFFFFFFL;
            }
            return value;
        }
        throw new UnsupportedOperationException("Number instance not handled!");
    }

    public static boolean equalsMaxUnsignedValue(Number value) {
        return value.longValue() == -1L;
    }
}

