/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ManifestFileZipEntryHasher;
import org.gradle.api.internal.changedetection.state.PropertiesFileZipEntryHasher;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipEntryContext;
import org.gradle.api.internal.changedetection.state.ZipEntryHasher;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaInfAwareClasspathResourceHasher
implements ResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaInfAwareClasspathResourceHasher.class);
    private final ResourceHasher delegate;
    private final ManifestFileZipEntryHasher manifestFileZipEntryHasher;
    private final PropertiesFileZipEntryHasher propertiesFileZipEntryHasher;

    public MetaInfAwareClasspathResourceHasher(ResourceHasher delegate, ManifestFileZipEntryHasher manifestFileZipEntryHasher, PropertiesFileZipEntryHasher propertiesFileZipEntryHasher) {
        this.delegate = delegate;
        this.manifestFileZipEntryHasher = manifestFileZipEntryHasher;
        this.propertiesFileZipEntryHasher = propertiesFileZipEntryHasher;
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        this.delegate.appendConfigurationToHasher(hasher);
        this.manifestFileZipEntryHasher.appendConfigurationToHasher(hasher);
        this.propertiesFileZipEntryHasher.appendConfigurationToHasher(hasher);
    }

    @Override
    @Nullable
    public HashCode hash(RegularFileSnapshot snapshot) {
        return this.delegate.hash(snapshot);
    }

    @Override
    @Nullable
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        ZipEntry zipEntry = zipEntryContext.getEntry();
        if (MetaInfAwareClasspathResourceHasher.isManifestFile(zipEntry.getName())) {
            return this.tryHashWithFallback(zipEntryContext, this.manifestFileZipEntryHasher);
        }
        if (MetaInfAwareClasspathResourceHasher.isManifestPropertyFile(zipEntry.getName())) {
            return this.tryHashWithFallback(zipEntryContext, this.propertiesFileZipEntryHasher);
        }
        return this.delegate.hash(zipEntryContext);
    }

    @Nullable
    private HashCode tryHashWithFallback(ZipEntryContext zipEntryContext, ZipEntryHasher hasher) throws IOException {
        try {
            return hasher.hash(zipEntryContext);
        }
        catch (IOException e) {
            LOGGER.debug("Could not load fingerprint for " + zipEntryContext.getRootParentName() + "!" + zipEntryContext.getFullName() + ". Falling back to full entry fingerprinting", (Throwable)e);
            return this.delegate.hash(zipEntryContext);
        }
    }

    private static boolean isManifestFile(String name) {
        return name.equals("META-INF/MANIFEST.MF");
    }

    private static boolean isManifestPropertyFile(String name) {
        return name.startsWith("META-INF/") && name.endsWith(".properties");
    }
}

